

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetSPVersionId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetSPVersionId.sp,v $ $Id: simGetSPVersionId.sp,v 1.1.2.13 2020/07/10 22:29:10 kgao Exp $";
--
--  +========================================================================+
--  | Stored Proc:  simGetSPVersionId()
--  |
--  | Description: Adds a package to the simInstalledPackage table and
--	|			   updates version information for the package
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simGetSPVersionId')
BEGIN
	print '>>> Drop Stored Procedure: simGetSPVersionId <<<'
	drop procedure simGetSPVersionId
END
IF EXISTS (select * from GxQscripts where name='simGetSPVersionId')
	delete from GxQscripts where name = 'simGetSPVersionId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetSPVersionId')
	delete from GXDBVersions where aliasname = 'simGetSPVersionId'
GO
print '... Creating Procedure: simGetSPVersionId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetSPVersionId
  @inReleaseId integer, 
  @inBuildId integer, 
  @inSpMajor integer, 
  @inSpMinor integer,
  @inTransactionId integer=0,
  @inRevisionId integer=0,
  @inFriendlyName varchar(256),
  @inUPNumber integer=0,
  @inUPTransactionId integer=0
AS
--	The next lines are the columns, in order, that will be in the result set for this cursor.
--  EXTREME CAUTION must be exercised to ensure that these match up with the result set
--  in terms of type, size and order!
  DECLARE @o_id integer
SET NOCOUNT ON
-- Check PatchSPVersion table for entry
DECLARE @patchSPVersionId integer
SELECT TOP 1 @patchSPVersionId = id
FROM PatchSPVersion
WHERE Release = @inReleaseId AND
	Build = @inBuildId AND
	SPMajor = @inSpMajor AND
	SPMinor = @inSpMinor AND
	TransactionID = @inTransactionId AND
	RevisionID IN (0, @inRevisionId)
ORDER BY RevisionID DESC
-- Replace 0 revisionId with a highest one if exists
IF @patchSPVersionId IS NULL AND @inRevisionId = 0
BEGIN
	SELECT TOP 1 @patchSPVersionId = id
	FROM PatchSPVersion
	WHERE Release = @inReleaseId AND
		Build = @inBuildId AND
		SPMajor = @inSpMajor AND
		SPMinor = @inSpMinor AND
		TransactionID = @inTransactionId
	ORDER BY RevisionId DESC
END
-- Insertion happens here
IF @patchSPVersionId IS NULL
BEGIN
	-- This table refers to a specific service pack recut for the installed package, so we need to add an entry since none exists.
	INSERT INTO PatchSPVersion (Release, Build, SPMajor, SPMinor, TransactionID, RevisionID, FriendlyName, Timestamp, ReleaseStr, BuildIdString, DVDName, SPName, bIsDVDPresent, bShowInGUI, nCacheFlags, nLTSFlag, nBootstrapperDelayDays, nGUIDownloadDelayDays)
	VALUES (@inReleaseId, @inBuildId, @inSpMajor, @inSpMinor, @inTransactionId, @inRevisionID, @inFriendlyName, 0, '', '', '', '', 0, 0, 0, 0, 0, 0)
	SET @patchSPVersionId = SCOPE_IDENTITY()
END
IF @inUPNumber > 0
BEGIN
	IF EXISTS (SELECT 1 FROM PatchUPVersion WHERE SPVersionId = @patchSPVersionId AND UPNumber = @inUPNumber)
		UPDATE PatchUPVersion SET MaxTransactionID = @inUPTransactionId WHERE SPVersionId = @patchSPVersionId AND UPNumber = @inUPNumber AND MaxTransactionID = 0
	ELSE
		INSERT INTO PatchUPVersion SELECT @patchSPVersionId, @inUPNumber, @inUPTransactionId, 0, 0, @inFriendlyName, 0, 0, 0
END
SELECT @patchSPVersionId
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetSPVersionId')
	delete from GxQscripts where name = 'simGetSPVersionId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetSPVersionId')
	delete from GXDBVersions where aliasname = 'simGetSPVersionId'
GO

insert into GXDBVersions values(2, 'simGetSPVersionId',  '00010001000200130000', 'simGetSPVersionId', '00010001000200130000')
GO

