

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetPseudoClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetPseudoClients.sp,v $ $Id: simGetPseudoClients.sp,v 1.1.2.11 2020/04/22 04:28:20 rengu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SimGetPseudoClients')
BEGIN
	print '>>> Drop Stored Procedure: SimGetPseudoClients <<<'
	drop procedure SimGetPseudoClients
END
IF EXISTS (select * from GxQscripts where name='SimGetPseudoClients')
	delete from GxQscripts where name = 'SimGetPseudoClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SimGetPseudoClients')
	delete from GXDBVersions where aliasname = 'SimGetPseudoClients'
GO
print '... Creating Procedure: SimGetPseudoClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SimGetPseudoClients
  @i_ClientId INTEGER,
  @i_ReleaseId INTEGER
AS
  DECLARE @o_clientId INT
  DECLARE @o_appType INT
  DECLARE @o_clientType VARCHAR(MAX)
DECLARE @clientIdStr		VARCHAR(32) = cast(@i_ClientId as varchar(32))
DECLARE @PseudoClients		TABLE (t_clientID INT, t_type INT)
DECLARE @PseudoClientTypes	TABLE (t_type INT, t_appType INT, t_name VARCHAR(1024))
INSERT INTO @PseudoClientTypes VALUES (1,	80,		'Oracle RAC')
INSERT INTO @PseudoClientTypes VALUES (2,		53,	'DAG (MS EXCH DB)')
INSERT INTO @PseudoClientTypes VALUES (3,	124,	'Object Link')
INSERT INTO @PseudoClientTypes VALUES (4,		103,		'DB2 DPF')
INSERT INTO @PseudoClientTypes VALUES (5,		81,		'MSSQL')
INSERT INTO @PseudoClientTypes VALUES (6,		135,		'SAP Hana')
INSERT INTO @PseudoClientTypes VALUES (7,		106,	'Hyper-V')
INSERT INTO @PseudoClientTypes VALUES (8,	33,	'Non-NDMP Filer')
INSERT INTO @PseudoClientTypes VALUES (9,		38,		'OpenVMS')
DECLARE @xmlProp		TABLE (t_cid INT, t_attrName VARCHAR(MAX), t_attrVal NVARCHAR(MAX))
INSERT INTO @xmlProp SELECT DISTINCT componentNameId, attrName, attrVal FROM APP_INSTANCEPROP WHERE attrName IN ('Availability Group', 'Availability Replicas', 'Vs Member Servers') AND modified = 0
-- ORACLE_RAC
INSERT INTO @PseudoClients
SELECT DISTINCT A.clientId, 1
FROM    APP_Application A WITH (NOLOCK) JOIN APP_OracleRacInstance O WITH (NOLOCK) ON A.instance = O.instaceId AND O.clientId = @i_ClientId
-- DAG_EX_DB
INSERT INTO @PseudoClients
SELECT DISTINCT P.componentNameId, 2
FROM	APP_ClientProp P WITH (NOLOCK), APP_Client C WITH (NOLOCK)
WHERE	C.id = @i_ClientId AND P.attrType = 125 AND P.attrName = C.net_hostname AND P.modified = 0
-- OBJECT_LINK
INSERT INTO @PseudoClients
SELECT DISTINCT P.componentNameId, 3
FROM	APP_ClientProp P WITH (NOLOCK) CROSS APPLY dbo.SplitIDString(replace(P.attrVal,':',',')) T
WHERE	P.attrName = 'Object Server Member Servers List' AND P.modified = 0 AND T._ID = @i_ClientId
-- DB2_DPF
INSERT INTO @PseudoClients
SELECT DISTINCT A.clientId, 4
FROM    APP_Application A WITH (NOLOCK),
	(	SELECT t_instance = IP.componentNameId, t_pClientId = substring(T1.Data, CHARINDEX(',', T1.Data)+1, LEN(T1.Data))
    		FROM	APP_InstanceProp IP WITH (NOLOCK) CROSS APPLY dbo.SplitString(IP.attrVal, ' ') T1
    		WHERE	IP.attrName = 'DB2 Partition Clients' and IP.modified = 0) T2
WHERE	appTypeId = 103 AND instance = t_instance AND T2.t_pClientId = CAST(@i_ClientId as varchar(64))
-- SQL
DECLARE @InstanceList TABLE (t_ID INT)
INSERT INTO @InstanceList
SELECT componentNameId FROM APP_InstanceProp P WITH (NOLOCK) WHERE P.attrName = 'Proxy Client Id' AND P.attrVal = @i_ClientId AND P.modified = 0
UNION
SELECT t_cid FROM @xmlProp CROSS APPLY (select cast(t_attrval as xml)) as X(X)
		     	WHERE	(t_attrName = 'Availability Group' AND X.value('(App_SQLAvailabilityGroup/primaryReplicaClient/@clientId)[1]', 'int') = @i_ClientId)
			   OR 	(t_attrName = 'Availability Replicas' AND @i_ClientId in (SELECT ref.value('@clientId', 'int') FROM X.nodes('App_SQLAvailabilityReplicas/SQLAvailabilityReplicaList/replicaClient') R (ref)))
INSERT INTO @PseudoClients
SELECT DISTINCT A.clientId, 5
FROM    APP_Application A WITH (NOLOCK) JOIN @InstanceList ON instance = t_ID
-- SAP_HANA
INSERT INTO @PseudoClients
SELECT DISTINCT A.clientId, 6
FROM    APP_Application A WITH (NOLOCK), APP_InstanceProp P WITH (NOLOCK)
WHERE	A.instance = P.componentNameId AND P.attrName = 'Database Clients'
	AND (attrVal = @clientIdStr OR attrVal like '%+' + @clientIdStr + '+%' OR attrVal like '%+' + @clientIdStr OR attrVal like @clientIdStr + '+%')
-- HYPERV
INSERT INTO @PseudoClients
SELECT DISTINCT A.clientId, 7
FROM    APP_Application A WITH (NOLOCK)
WHERE	instance in (	SELECT t_cid FROM @xmlProp CROSS APPLY (select cast(t_attrval as xml)) as X(X) CROSS APPLY X.nodes('App_MemberServers/memberServers') as P(P)
		     	WHERE t_attrName = 'Vs Member Servers' AND (	P.value('(client/@clientId)[1]', 'int') = @i_ClientId OR
									P.value('(client/@clientGroupId)[1]', 'int') IN (select clientGroupId from APP_ClientGroupAssoc WITH (NOLOCK) where clientID = @i_ClientId)))
-- NON_NDMP_FILER
INSERT INTO @PseudoClients
SELECT DISTINCT A.clientId, 8
FROM    APP_Application A WITH (NOLOCK) JOIN App_SubClientProp P WITH (NOLOCK) ON A.id = P.componentNameId AND P.cs_attrName = checksum(N'Turbo NAS Proxy Client') AND P.modified = 0 AND P.attrVal = CAST(@i_ClientId AS nvarchar(max))
-- OPEN_VMS
INSERT INTO @PseudoClients
SELECT DISTINCT componentNameId, 9
FROM	APP_ClientProp WITH (NOLOCK)
WHERE	attrName = 'Open VMS proxy client' AND attrVal = CAST(@i_ClientId AS VARCHAR(32)) AND modified = 0
-- Do not return clients with packages installed
DELETE @PseudoClients FROM simInstalledpackages WITH (NOLOCK) WHERE clientid = t_clientID
DELETE @PseudoClients FROM APP_Client WITH (NOLOCK)
WHERE id = t_clientID AND (	@i_ReleaseId > 0 AND releaseID >= @i_ReleaseId
OR t_type = 6 AND (status & 0x2000000) = 0
OR t_type = 8 AND (status & 0x8000000) = 0 )
-- Return pseudo clients
IF object_id('tempdb.dbo.#simGetPseudoClients_ExtTempTable') is not null
BEGIN
	INSERT INTO #simGetPseudoClients_ExtTempTable
	SELECT DISTINCT t_clientID AS clientId, T.t_appType as type, t_name as name
	FROM @PseudoClients C JOIN @PseudoClientTypes T ON C.t_type = T.t_type
	ORDER BY t_clientID
END
ELSE
BEGIN
	SELECT DISTINCT t_clientID, T.t_appType, t_name
	FROM @PseudoClients C JOIN @PseudoClientTypes T ON C.t_type = T.t_type
	ORDER BY t_clientID
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'simGetPseudoClients')
	delete from GxQscripts where name = 'simGetPseudoClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetPseudoClients')
	delete from GXDBVersions where aliasname = 'simGetPseudoClients'
GO

insert into GXDBVersions values(2, 'simGetPseudoClients',  '00010001000200110000', 'simGetPseudoClients', '00010001000200110000')
GO

