

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetProcessorType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetProcessorType.sp,v $ $Id: simGetProcessorType.sp,v 1.4.276.2 2018/03/22 01:36:34 jiechen Exp $";
--
--  +========================================================================+
--  |      Cursor:  simGetProcessorType()
--  |
--  | Description:  It will return the type of processor for the given client.
--	|
--  |	   Input :  ClientID
--	|
--  |      Output:  It returns o_processorType.Following are the possible values.
--	|				1 for 32 Bit
--	|				2 for IA64
--	|				3 for AMD64
--	|
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      Hemant Mishra  Getting Processor Type
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetProcessorType <<<'

IF EXISTS (select * from sysobjects where name='simGetProcessorType')
	drop procedure simGetProcessorType
IF EXISTS (select * from GxQscripts where name='simGetProcessorType')
	delete from GxQscripts where name = 'simGetProcessorType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetProcessorType')
	delete from GXDBVersions where aliasname = 'simGetProcessorType'
GO
print '... Creating Procedure: simGetProcessorType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetProcessorType
  @i_clientID integer
AS
  DECLARE @o_processorType integer
SET NOCOUNT ON
DECLARE @SimOSID INTEGER
--SET @SimOSID = (select S.id from simos S, simsystemos Ss, app_client A
--where  A.id=@i_clientID AND A.simsystemosid=Ss.id AND Ss.simosid=S.id)
SET @SimOSID = (select simOperatingSystemId from APP_client where id=@i_clientID)
IF  @SimOSID in  (select id from simOperatingSystem where platformType = 'X64')
SET @o_processorType = 3
ELSE  IF  @SimOSID in  (select id from simOperatingSystem where platformType in ('IA64', 'PPC64'))
SET @o_processorType = 2
ELSE
SET @o_processorType = 1
select @o_processorType
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetProcessorType')
	delete from GxQscripts where name = 'simGetProcessorType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetProcessorType')
	delete from GXDBVersions where aliasname = 'simGetProcessorType'
GO

insert into GXDBVersions values(2, 'simGetProcessorType',  '00010004027600020000', 'simGetProcessorType', '00010004027600020000')
GO

