

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetPatchHealthStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetPatchHealthStatus.sp,v $ $Id: simGetPatchHealthStatus.sp,v 1.1.2.11 2020/05/29 20:29:10 kgao Exp $";
--
--  +========================================================================+
--  |   Cursor:  simGetPatchHealthStatus
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |   1.0       Kim    Gets all client Ids and missing patches list
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simGetPatchHealthStatus')
BEGIN
	print '>>> Drop Stored Procedure: simGetPatchHealthStatus <<<'
	drop procedure simGetPatchHealthStatus
END
IF EXISTS (select * from GxQscripts where name='simGetPatchHealthStatus')
	delete from GxQscripts where name = 'simGetPatchHealthStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetPatchHealthStatus')
	delete from GXDBVersions where aliasname = 'simGetPatchHealthStatus'
GO
print '... Creating Procedure: simGetPatchHealthStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetPatchHealthStatus
  @inClientType INTEGER
AS
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
-- These lines represent the actual SQL code that will get executed.
-- :PARAM input lines
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
/* Caller will create temp table #TempResSimGetPatchHealthStatus
(
	oClientType			VARCHAR(128),
	oClientName			VARCHAR(2048),
	oInstalledRelease	VARCHAR(128),
	oInstalledSPMajor	INTEGER,
	oInstalledSPMinor	INTEGER,
	oCSRelease			VARCHAR(128),
	oCSSPMajor			INTEGER,
	oCSSPMinor			INTEGER,
	oLatestRelease		VARCHAR(128),
	oLatestSPMajor		INTEGER,
	oLatestSPMinor		INTEGER,
	oLatestSPMajorForInstalledVersion	INTEGER,  -- if cannot find it, 0 will be used
	oLatestSPMinorForInstalledVersion	INTEGER,  -- if cannot find it, 0 will be used
	oInstalledAddUpdates	VARCHAR(MAX),
	oMissingInstalledUpdates		VARCHAR(MAX),
	oMissingDownloadedUpdates		VARCHAR(MAX)
)
*/
DECLARE @CSNode INT
DECLARE @CSClientId INT
DECLARE @CSSPVersionId INT
DECLARE @CSReleaseID INT
DECLARE @CSReleaseStr VARCHAR(128)
DECLARE @CSMajorSP	INT
DECLARE @CSMinorSP	INT
DECLARE @LatestRel INT
DECLARE @LatestRelStr VARCHAR(128)
DECLARE @LatestSPMajor INT
DECLARE @LatestSPMinor INT
SELECT TOP 1 @CSNode = clientId FROM APP_Platform WHERE platformType = 1
-- Get the latest release and SP on download center
SET @LatestRel = (SELECT MAX(Release) FROM PatchSPVersion Where bIsDVDPresent = 1)
SET @LatestRelStr = (SELECT SA.release from simAllGalaxyRel SA where SA.id = @LatestRel)
SET @LatestSPMajor = (SELECT MAX (SPMajor) FROM PatchSPVersion Where Release = @LatestRel AND bIsDVDPresent = 1)
SET @LatestSPMinor = (SELECT MAX (SPMinor) FROM PatchSPVersion Where Release = @LatestRel AND SPMajor = @LatestSPMajor AND bIsDVDPresent = 1)
CREATE TABLE #ClientMissingInstalledPatches   (ClientId INT, simPkgId INT, PatchName VARCHAR(512))
CREATE TABLE #ClientInstalledAddPatches  (ClientId INT, simPkgId INT, PatchName VARCHAR(512))
DECLARE @PackageBasedUpdates TABLE (packageId INT, OSId INT, patchId VARCHAR(512))
IF OBJECT_ID('tempdb..#ClientDetails') IS NOT NULL
       DROP TABLE #ClientDetails
CREATE TABLE #ClientDetails (ClientId INT,
	ClientName VARCHAR(1024),
	ClientType INT DEFAULT 2,
	SPVersionId INT,
	ReleaseId INT,
	ReleaseStr VARCHAR(16),
	SPMajor INT,
	SPMinor INT,
	UpdateOSId INT,
	installedAddPatches VARCHAR(MAX),
	missingInstalledPatches VARCHAR(MAX),
	missingDownloadedPatches VARCHAR(MAX)) --ClientType => 0:CS, 1:Servers, 2:Laptops, 4:MediaAgents
CREATE CLUSTERED INDEX Cl_ClientDetails  On #ClientDetails(ClientId,ClientType)
IF OBJECT_ID('tempdb..#ClientMissingDownloadedAddPatches') IS NOT NULL
       DROP TABLE #ClientMissingDownloadedAddPatches
CREATE TABLE #ClientMissingDownloadedAddPatches (ClientId INT,
	simPkgId INT,
	PatchName VARCHAR(512))
CREATE CLUSTERED INDEX Cl_MissingDownloadedAddPatches On #ClientMissingDownloadedAddPatches(ClientId)
CREATE NONCLUSTERED INDEX Cl_MissingDownloadedAddPatches_1 On #ClientMissingDownloadedAddPatches(PatchName)
IF OBJECT_ID('tempdb..#ClientInstalledAddPatchesAll') IS NOT NULL
       DROP TABLE #ClientInstalledAddPatchesAll
CREATE TABLE #ClientInstalledAddPatchesAll (ClientId INT,
	AllPatchName VARCHAR(MAX))
CREATE  CLUSTERED INDEX Cl_InstalledAddPatchesAll On #ClientInstalledAddPatchesAll(ClientId)
IF OBJECT_ID('tempdb..#ClientMissingInstalledPatchesAll') IS NOT NULL
       DROP TABLE #ClientMissingInstalledPatchesAll
CREATE TABLE #ClientMissingInstalledPatchesAll (ClientId INT,
	AllPatchName VARCHAR(MAX))
CREATE CLUSTERED INDEX Cl_MissingInstalledPatchesAll ON #ClientMissingInstalledPatchesAll(ClientId)
IF OBJECT_ID('tempdb..#ClientMissingDownloadedPatchesAll') IS NOT NULL
       DROP TABLE #ClientMissingDownloadedPatchesAll
CREATE TABLE #ClientMissingDownloadedPatchesAll (ClientId INT,
	AllPatchName VARCHAR(MAX))
CREATE CLUSTERED INDEX Cl_MissingDownloadedPatchesAll ON #ClientMissingDownloadedPatchesAll(ClientId)
-- Always the active physical node of CommServ as CommServ client id
SET @CSClientId = ISNULL((SELECT attrVal FROM App_ClientProp
    WHERE componentNameId = @CSNode AND attrName like 'CS Active Physical Node' AND modified = 0), @CSNode)
-- We may use the PatchSPVersion's ReleaseStr once it is ready
SELECT @CSSPVersionId = MAX(SPVersionID) FROM simInstalledPackages WITH(NOLOCK) WHERE ClientId=@CSClientId
SELECT @CSReleaseID = PS.Release,
	@CSReleaseStr = SR.release,
	@CSMajorSP = SPMajor,
	@CSMinorSP = SPMinor
	FROM PatchSPVersion AS PS WITH(NOLOCK), simAllGalaxyRel AS SR WITH(NOLOCK) WHERE PS.id = @CSSPVersionId AND SR.id = PS.Release
-- Adding all clients which are visible in GUI
IF Object_ID('Tempdb.dbo.#ClientList') is not null
BEGIN
		     INSERT INTO #ClientDetails(ClientId, ClientName, ClientType, SPVersionId)
	   SELECT C.id,
			C.name,
			(CASE WHEN C.id = @CSClientId THEN 1 WHEN (C.status & 0x1000) > 0 THEN 4 ELSE 2 END),
			MAX(sim.SPVersionId)
			FROM simInstalledPackages sim WITH(NOLOCK)
			INNER JOIN App_Client C WITH(NOLOCK)
				  ON sim.ClientId = C.id
		     INNER JOIN #ClientList ON C.ID=#ClientList.ClientID
	   WHERE  C.id > 1 AND C.specialClientFlags&1 <> 1
	   GROUP BY C.id, C.name, C.status
END
ELSE
BEGIN
	   INSERT INTO #ClientDetails(ClientId, ClientName, ClientType, SPVersionId)
	   SELECT C.id,
			C.name,
			(CASE WHEN C.id = @CSClientId THEN 1 WHEN (C.status & 0x1000) > 0 THEN 4 ELSE 2 END),
			MAX(sim.SPVersionId)
			FROM simInstalledPackages sim WITH(NOLOCK)
			INNER JOIN App_Client C WITH(NOLOCK)
				  ON sim.ClientId = C.id
	   WHERE  C.id > 1 AND C.specialClientFlags&1 <> 1
	   GROUP BY C.id, C.name, C.status
END
-- remove the clients who has no agents installed or not deconfigured and not MA
 DELETE    c
 	FROM #ClientDetails c  LEFT JOIN
	 (SELECT DISTINCT ClientId FROM MMHost WITH(NOLOCK)
	  UNION ALL
	  SELECT DISTINCT clientId FROM APP_IDAName WITH (NOLOCK) WHERE (status & 4) = 0
	  EXCEPT (SELECT DISTINCT componentNameId ClientID FROM APP_ClientProp WITH(NOLOCK) WHERE attrName = 'PlatformDeleted 4' AND attrVal = '1' AND modified = 0)  ) b
	  On  c.ClientId= b.clientId
	  WHERE b.ClientId is null
-- Update MA status
UPDATE CD SET ClientType = 8 FROM #ClientDetails CD INNER JOIN MMHost MA ON MA.ClientId = CD.ClientId AND CD.ClientId <> @CSClientId -- MediAgents
--delete unused types
DELETE FROM #ClientDetails WHERE ClientType & @inClientType = 0
-- update os id
UPDATE #ClientDetails SET UpdateOSId = PatchUpdateOS.NewUpdateOSID FROM #ClientDetails, App_ClientProp, PatchUpdateOS
	WHERE #ClientDetails.ClientId = App_ClientProp.componentNameId AND App_ClientProp.attrName = 'Binary Set ID' AND App_ClientProp.attrVal = PatchUpdateOS.BinarySetID
-- update release and sp info
UPDATE #ClientDetails SET ReleaseId = PatchSPVersion.Release, ReleaseStr = simAllGalaxyRel.release, SPMajor = PatchSPVersion.SPMajor, SPMinor = PatchSPVersion.SPMinor FROM #ClientDetails, PatchSPVersion, simAllGalaxyRel
	WHERE #ClientDetails.SPVersionId = PatchSPVersion.id AND PatchSPVersion.Release = simAllGalaxyRel.id
-- Split the Updates Ids in simInstalledPackages table
INSERT INTO #ClientInstalledAddPatches(ClientId, simPkgId, PatchName)
SELECT DISTINCT sim.ClientId, sim.simPackageID, AP._ID
	FROM simInstalledPackages sim
	CROSS APPLY dbo.SplitIDString(sim.AdditionalPatches) AS AP
	WHERE AP._ID <> 'None'AND sim.ClientId IN (SELECT ClientId FROM #ClientDetails)
-- Split the Missing updates in simInstalledPackages table when it is below baseline
INSERT INTO #ClientMissingInstalledPatches(ClientId, simPkgId, PatchName)
SELECT DISTINCT sim.ClientId, sim.simPackageID, AP._ID
	FROM simInstalledPackages sim
	CROSS APPLY dbo.SplitIDString(sim.BaselineDeltaUpdate) AS AP
	WHERE (dbo.simGetBaseline(sim.Baseline) & 2) > 0 AND AP._ID <> 'None' AND sim.ClientId IN (SELECT ClientId FROM #ClientDetails)
-- Save all updates which are not downloaded but on downloadcenter
INSERT INTO @PackageBasedUpdates (packageId, OSId, patchId)
SELECT DISTINCT st._ID, po.NewUpdateOSID, patchInfo.UpdatesNumber
    FROM PatchUpdatesInfo as patchInfo
    CROSS APPLY dbo.SplitIDString(patchInfo.PkgList) as st
    JOIN PatchUpdateOS as po ON patchInfo.BinarySetId = po.BinarySetID
    FULL OUTER JOIN (SELECT pm.OSId, AU._ID FROM PatchMultiCache pm CROSS APPLY dbo.SplitIDString(pm.AddUpdates) AS AU WHERE pm.ClientId = @CSNode
		AND pm.IsSPValid = 1
		AND pm.ReleaseId = @CSReleaseID
		AND pm.HighestSP = dbo.GetServicePackStr(@CSMajorSP, @CSMinorSP)) AS T ON po.NewUpdateOSID = T.OSId AND T._ID = patchInfo.UpdatesNumber
    WHERE patchInfo.SPVersionId = @CSSPVersionId AND T._ID IS NULL
-- missing download updates: updates not installed or downloaded but available in PatchUpdatesInfo table
INSERT INTO #ClientMissingDownloadedAddPatches(clientId, simPkgId, PatchName)
SELECT DISTINCT sim.ClientId, sim.simPackageID, bp.patchId
	FROM simInstalledPackages AS sim WITH(NOLOCK) INNER JOIN #ClientDetails AS cdl WITH(NOLOCK) ON sim.ClientId = cdl.ClientId, @PackageBasedUpdates AS bp
	WHERE sim.simPackageID = bp.packageId
		AND bp.patchId NOT IN (SELECT PatchName FROM #ClientInstalledAddPatches WHERE ClientId = sim.ClientId AND simPackageID = bp.packageId)
		AND cdl.ReleaseId = @CSReleaseID
		AND cdl.SPMajor = @CSMajorSP
		AND cdl.SPMinor = @CSMinorSP
		AND cdl.UpdateOSId = bp.OSId
-- merge all missing installed updates
INSERT INTO #ClientMissingInstalledPatchesAll(ClientId, AllPatchName)
SELECT DISTINCT ST2.ClientId,ST3.AllPatchName
FROM #ClientMissingInstalledPatches ST2
CROSS APPLY
   (
        SELECT DISTINCT (ST1.PatchName + ',') AS [text()]
        FROM #ClientMissingInstalledPatches ST1
        WHERE ST1.ClientId = ST2.ClientId
        FOR XML PATH ('')
    )  St3(AllPatchName)
-- merge all missing downloaded updates
INSERT INTO #ClientMissingDownloadedPatchesAll(ClientId, AllPatchName)
SELECT DISTINCT ST2.ClientId,St3.AllPatchName
FROM #ClientMissingDownloadedAddPatches ST2
CROSS APPLY
(
        SELECT DISTINCT ST1.PatchName + ',' AS [text()]
        FROM #ClientMissingDownloadedAddPatches ST1
        WHERE ST1.ClientId = ST2.ClientId
        FOR XML PATH ('')
    )  St3(AllPatchName)
 --generate all install patches for each client
INSERT INTO #ClientInstalledAddPatchesAll(ClientId, AllPatchName)
SELECT DISTINCT ST2.ClientId,st3.AllPatchName
FROM #ClientInstalledAddPatches ST2
CROSS APPLY
 (
        SELECT DISTINCT ST1.PatchName + ',' AS [text()]
        FROM #ClientInstalledAddPatches ST1
        WHERE ST1.ClientId = ST2.ClientId
        FOR XML PATH ('')
    ) St3(AllPatchName)
UPDATE #ClientDetails SET #ClientDetails.installedAddPatches = ISNULL (
	(SELECT LEFT(AllPatchName, Len(AllPatchName) - 1)
		FROM #ClientInstalledAddPatchesAll WHERE #ClientInstalledAddPatchesAll.ClientId = #ClientDetails.ClientId AND #ClientInstalledAddPatchesAll.AllPatchName LIKE '%,'), '')
UPDATE #ClientDetails SET #ClientDetails.missingInstalledPatches = ISNULL(
	(SELECT LEFT(AllPatchName, Len(AllPatchName) - 1)
		FROM #ClientMissingInstalledPatchesAll WHERE #ClientMissingInstalledPatchesAll.ClientId = #ClientDetails.ClientId AND #ClientMissingInstalledPatchesAll.AllPatchName LIKE '%,'), '')
UPDATE #ClientDetails SET #ClientDetails.missingDownloadedPatches = ISNULL(
	(SELECT LEFT(AllPatchName, Len(AllPatchName) - 1)
	FROM #ClientMissingDownloadedPatchesAll WHERE #ClientMissingDownloadedPatchesAll.ClientId = #ClientDetails.ClientId AND #ClientMissingDownloadedPatchesAll.AllPatchName LIKE '%,'), '')
IF OBJECT_ID('tempdb..#TempResSimGetPatchHealthStatus') IS NOT NULL
BEGIN
	INSERT INTO #TempResSimGetPatchHealthStatus
	SELECT
		CASE ClientType WHEN 1 THEN 'CommServ' WHEN 2 THEN 'Servers' WHEN 4 THEN 'Laptops' WHEN 8 THEN 'MediaAgents' END AS 'Client Type',
		ClientName AS 'Client Name',
		ReleaseStr AS 'Installed Release',
		SPMajor AS 'Installed SP Major',
		SPMinor AS 'Installed SP Minor',
		@CSReleaseStr AS 'CommServer Release',
		@CSMajorSP AS 'CommServer SP Major',
		@CSMinorSP AS 'CommServer SP Minor',
		@LatestRelStr AS 'Latest Release',
		@LatestSPMajor AS 'Latest SP Major',
		@LatestSPMinor AS 'Latest SP Minor',
		ISNULL((SELECT TOP 1 SPMajor AS 'Latest SP Major For Installed Version' FROM PatchSPVersion WHERE Release = ReleaseId AND bIsDVDPresent = 1 ORDER BY SPMajor DESC, SPMinor DESC, TransactionID DESC), 0),
		ISNULL((SELECT TOP 1 SPMinor AS 'Latest SP Minor For Installed Version' FROM PatchSPVersion WHERE Release = ReleaseId AND bIsDVDPresent = 1 ORDER BY SPMajor DESC, SPMinor DESC, TransactionID DESC), 0),
		ISNULL(installedAddPatches, ''),
		ISNULL(missingInstalledPatches, ''),
		ISNULL(missingDownloadedPatches, '')
	 FROM #ClientDetails
END
DROP TABLE #ClientDetails
DROP TABLE #ClientMissingDownloadedAddPatches
DROP TABLE #ClientInstalledAddPatchesAll
DROP TABLE #ClientMissingInstalledPatchesAll
DROP TABLE #ClientMissingDownloadedPatchesAll
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetPatchHealthStatus')
	delete from GxQscripts where name = 'simGetPatchHealthStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetPatchHealthStatus')
	delete from GXDBVersions where aliasname = 'simGetPatchHealthStatus'
GO

insert into GXDBVersions values(2, 'simGetPatchHealthStatus',  '00010001000200110000', 'simGetPatchHealthStatus', '00010001000200110000')
GO

