

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetPackageIDFromAppType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetPackageIDFromAppType.sp,v $ $Id: simGetPackageIDFromAppType.sp,v 1.3.276.1 2018/03/27 09:09:51 jiechen Exp $";
--
--  +========================================================================+
--  |      Cursor:  simGetPackageIDFromAppType()
--  |
--  | Description:  It gets the package ID from Apptype and simoperating system ID
--	|
--  |	   Input :  Apptype/SimOperatingSystemID
--	|
--  |      Output:  It returns o_simPackageID.
--	|
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      Hemant Mishra  Getting SIM PackageID from Apptype/simoperating system ID
--  |     1.3      Xuemei	  added SQL function GetPackageID
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetPackageIDFromAppType <<<'

IF EXISTS (select * from sysobjects where name='simGetPackageIDFromAppType')
	drop procedure simGetPackageIDFromAppType
IF EXISTS (select * from GxQscripts where name='simGetPackageIDFromAppType')
	delete from GxQscripts where name = 'simGetPackageIDFromAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetPackageIDFromAppType')
	delete from GXDBVersions where aliasname = 'simGetPackageIDFromAppType'
GO
print '... Creating Procedure: simGetPackageIDFromAppType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetPackageIDFromAppType
  @i_appTypeID integer,
  @i_simOperatingSystemID integer
AS
  DECLARE @o_simPackageID integer
SET NOCOUNT ON
SELECT dbo.GetPackageID(@i_appTypeID, @i_simOperatingSystemID)
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetPackageIDFromAppType')
	delete from GxQscripts where name = 'simGetPackageIDFromAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetPackageIDFromAppType')
	delete from GXDBVersions where aliasname = 'simGetPackageIDFromAppType'
GO

insert into GXDBVersions values(2, 'simGetPackageIDFromAppType',  '00010003027600010000', 'simGetPackageIDFromAppType', '00010003027600010000')
GO

