

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetMountPathsOnMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetMountPathsOnMA.sp,v $ $Id: simGetMountPathsOnMA.sp,v 1.2.304.1 2018/03/22 01:38:41 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: simGetMountPathsOnMA
--  |
--  | Description:	During the MA reinstalls or upgrades, get the number of mount
--  |				paths configured on that MA.
--  |
--  |   Revisions  Author           Description
--  |   ---------  -------          ---------------------------------------------
--  |   1.0        M J Venkatesh    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetMountPathsOnMA <<<'

IF EXISTS (select * from sysobjects where name='simGetMountPathsOnMA')
	drop procedure simGetMountPathsOnMA
IF EXISTS (select * from GxQscripts where name='simGetMountPathsOnMA')
	delete from GxQscripts where name = 'simGetMountPathsOnMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetMountPathsOnMA')
	delete from GXDBVersions where aliasname = 'simGetMountPathsOnMA'
GO
print '... Creating Procedure: simGetMountPathsOnMA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetMountPathsOnMA
  @in_ClientId INTEGER
AS
-- Output variables of the stored procedure
  DECLARE @out_NumMountPaths INTEGER
	SET NOCOUNT ON
	Declare @l_NumMountPaths	INTEGER
	SET @l_NumMountPaths = 0
	set @l_NumMountPaths = (select COUNT(*)
	from MMMedia as MM
	where EXISTS(select MediaId from MMMediaSide as MS where MS.MediaId = MM.MediaId)
	AND EXISTS(select distinct MLC.libraryId
			from MMLibrary as ML LEFT OUTER JOIN MMLibraryController as MLC ON MLC.LibraryId = ML.LibraryId
			where MLC.ClientId = @in_ClientId AND ML.LibraryTypeId = 3 AND MM.LibraryId = ML.LibraryId))
	----If there are no regular mountpaths, then check of there are any non-regular mount paths created on this Client
	IF( ( @l_NumMountPaths = 0 ) AND ( (select count(*) from MMDevicecontroller where ClientId = @in_ClientId) > 0) )
	BEGIN
		set @l_NumMountPaths = (select count(*)
					from MMMountPathToStorageDevice as MMP2SD LEFT OUTER JOIN MMDevice as MD ON MD.DeviceId = MMP2SD.DeviceId
					LEFT OUTER JOIN MMDevicecontroller as MDC ON MD.DeviceId = MDC.DeviceId
					where MDC.ClientId = @in_ClientId)
	END
	select @l_NumMountPaths
GO

IF EXISTS (select * from GxQscripts where name = 'simGetMountPathsOnMA')
	delete from GxQscripts where name = 'simGetMountPathsOnMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetMountPathsOnMA')
	delete from GXDBVersions where aliasname = 'simGetMountPathsOnMA'
GO

insert into GXDBVersions values(2, 'simGetMountPathsOnMA',  '00010002030400010000', 'simGetMountPathsOnMA', '00010002030400010000')
GO

