

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetIsNASInstalled.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetIsNASInstalled.sp,v $ $Id: simGetIsNASInstalled.sp,v 1.3.294.1 2018/03/22 01:44:05 jiechen Exp $";
--
--  +========================================================================+
--  |      Cursor:  simGetIsNASInstalled()
--  |
--  | Description:  Retrieves the version of the Galaxy Client
--  | 				It will just check one of the products installed on the
--  |				client assuming that every product is from the same
--  |				release
--  |
--  |       Input:  ClientID
--	|
--  |      Output:  Returns rows that match input criteria
--  |
--  |      Notes:	This cursor have a problem at the moment where the client
--  | 				is being installed since we might have two different
--  |				versions at the same time
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetIsNASInstalled <<<'

IF EXISTS (select * from sysobjects where name='simGetIsNASInstalled')
	drop procedure simGetIsNASInstalled
IF EXISTS (select * from GxQscripts where name='simGetIsNASInstalled')
	delete from GxQscripts where name = 'simGetIsNASInstalled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetIsNASInstalled')
	delete from GXDBVersions where aliasname = 'simGetIsNASInstalled'
GO
print '... Creating Procedure: simGetIsNASInstalled'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetIsNASInstalled
  @ClientId integer
AS
  DECLARE @InstalledLicType integer
	SET NOCOUNT ON
	SET @InstalledLicType = 0
-- SIM_CSL_AT_V2_NAS, SIM_CSL_AT_V2_NAS_EMC_CELERRA, SIM_CSL_AT_V2_NAS_EMC_CHAMELEON,
-- SIM_CSL_AT_V2_NAS_EMC_CENTERA, SIM_CSL_AT_V2_NAS_BLUEARC, SIM_CSL_AT_V2_NAS_GENERIC, SIM_CSL_AT_V2_HITACHI_ENAS
	SET @InstalledLicType = ( SELECT TOP 1 LU.LicType FROM LicUsage LU
		WHERE LU.OpType='Install' AND LU.CId = @ClientId AND LU.LicType IN ( 25, 33, 34, 35, 47, 119, 120 )
		ORDER BY LU.id DESC )
	SELECT @InstalledLicType
	SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetIsNASInstalled')
	delete from GxQscripts where name = 'simGetIsNASInstalled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetIsNASInstalled')
	delete from GXDBVersions where aliasname = 'simGetIsNASInstalled'
GO

insert into GXDBVersions values(2, 'simGetIsNASInstalled',  '00010003029400010000', 'simGetIsNASInstalled', '00010003029400010000')
GO

