

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetInstalledPackagesForUpgrade.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetInstalledPackagesForUpgrade.sp,v $ $Id: simGetInstalledPackagesForUpgrade.sp,v 1.1.2.1 2016/02/01 17:02:18 xsui Exp $";
--
--  +========================================================================+
--  |	Cursor:  simGetInstalledPackagesForUpgrade
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |	1.1       Xuemei  Get the list of packages installed on CS from app manager and licensing tables.
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetInstalledPackagesForUpgrade <<<'

IF EXISTS (select * from sysobjects where name='simGetInstalledPackagesForUpgrade')
	drop procedure simGetInstalledPackagesForUpgrade
IF EXISTS (select * from GxQscripts where name='simGetInstalledPackagesForUpgrade')
	delete from GxQscripts where name = 'simGetInstalledPackagesForUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetInstalledPackagesForUpgrade')
	delete from GXDBVersions where aliasname = 'simGetInstalledPackagesForUpgrade'
GO
print '... Creating Procedure: simGetInstalledPackagesForUpgrade'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetInstalledPackagesForUpgrade
  @i_clientId integer,
  @i_includeDeConfigPackages integer=0
AS
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_packageId integer
  DECLARE @o_packageName varchar(1024)
  DECLARE @o_bInstalled integer
  DECLARE @o_releaseId integer
  DECLARE @o_flag integer
  DECLARE @o_osType varchar(1024)
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
SET NOCOUNT ON
DECLARE	@clientPackages	TABLE (t_packageId int, t_packageName varchar(1024), t_bInstalled int, t_releaseId int, t_flag int, t_osType varchar(1024))
INSERT INTO @clientPackages
EXEC simGetInstalledPackages @i_clientId, @i_includeDeConfigPackages
DELETE	@clientPackages
WHERE	t_packageId IN (select id from simPackage with (NOLOCK) where (flag | 2) > 0) AND
	NOT EXISTS (select id from simInstalledPackages with (NOLOCK) where clientID = @i_clientId AND simPackageID = t_packageId) AND
	NOT EXISTS (select I.* from APP_iDAName I with (NOLOCK) JOIN simPackageMap M with (NOLOCK) ON I.appTypeId = M.appType where clientID = @i_clientId AND M.simPackageID = t_packageId)
SELECT * FROM @clientPackages
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetInstalledPackagesForUpgrade')
	delete from GxQscripts where name = 'simGetInstalledPackagesForUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetInstalledPackagesForUpgrade')
	delete from GXDBVersions where aliasname = 'simGetInstalledPackagesForUpgrade'
GO

insert into GXDBVersions values(2, 'simGetInstalledPackagesForUpgrade',  '00010001000200010000', 'simGetInstalledPackagesForUpgrade', '00010001000200010000')
GO

