

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetInstalledPackages.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetInstalledPackages.sp,v $ $Id: simGetInstalledPackages.sp,v 1.41.2.13 2019/03/11 16:33:12 xsui Exp $";
--
--  +========================================================================+
--  |	Cursor:  simGetInstalledPackages
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |	1.1       Xuemei  Get the list of packages installed on CS from app manager and licensing tables.
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simGetInstalledPackages')
BEGIN
	print '>>> Drop Stored Procedure: simGetInstalledPackages <<<'
	drop procedure simGetInstalledPackages
END
IF EXISTS (select * from GxQscripts where name='simGetInstalledPackages')
	delete from GxQscripts where name = 'simGetInstalledPackages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetInstalledPackages')
	delete from GXDBVersions where aliasname = 'simGetInstalledPackages'
GO
print '... Creating Procedure: simGetInstalledPackages'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetInstalledPackages
  @i_clientId integer,
  @i_filterFlags integer=0
AS
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_packageId integer
  DECLARE @o_packageName varchar(1024)
  DECLARE @o_configInstallStatus integer
  DECLARE @o_releaseId integer
  DECLARE @o_flag integer
  DECLARE @o_osType varchar(64)
-- These lines represent the actual SQL code that will get executed.
-- :PARAM input lines
SET NOCOUNT ON
DECLARE @clientRelease INT
DECLARE @clientPackages TABLE (t_appTypeId int, t_packageId int, t_bConfigured int, t_releaseId int, t_flag int, t_bInstalledState int)
DECLARE @deprecatedUninstalledPackages TABLE (t_appTypeId int, t_packageId int, t_bConfigured int, t_releaseId int, t_flag int, t_bInstalledState int)
DECLARE @fileSystemAdvanced TABLE (t_pkgId int)
DECLARE @simOSID INT
DECLARE @simOSType varchar(64)
SELECT @simOSID = simOperatingSystemID FROM APP_Client WITH (NOLOCK) WHERE id = @i_clientId
SELECT @clientRelease = releaseId FROM APP_Client WITH (NOLOCK) WHERE id = @i_clientId
SELECT @simOSType = type from simOperatingSystem sos WHERE id = @simOSID
INSERT INTO @fileSystemAdvanced VALUES (702), (1101), (2001)
--#########################################
--Insert from License table
--#########################################
INSERT INTO @clientPackages
SELECT	DISTINCT appType, 0, (CASE optype when 'Install' then 1 else 0 end), releaseId, 2, 1
FROM	licUsage
WHERE	cID = @i_clientId AND licType NOT IN (10, 26, 71, 33554432) AND installFlag = 0
--#########################################
--Insert from Agent table
--#########################################
INSERT INTO @clientPackages
SELECT	DISTINCT appTypeId, 0, (CASE WHEN status & 2 > 0 THEN 0 ELSE 1 END), @clientRelease, 1, 1
FROM	APP_IDAName
WHERE	clientId = @i_clientId AND (status & 2) IN (0, 2)
--#########################################
--Insert using Client Prop table
--#########################################
INSERT INTO @clientPackages
SELECT (CASE WHEN vApp.t_apptype IS NULL THEN 0 ELSE vApp.t_apptype END),
		vPkg.t_packageid,
		(CASE vPkg.t_configuredState WHEN N'1' then 1 ELSE 0 END),
		@clientRelease,
		(CASE vPkg.t_configuredState WHEN N'1' THEN 4 ELSE 0 END),
		1
FROM simGetClientPropPackagesForClient(@i_clientId) vPkg
LEFT JOIN simGetClientPropAppTypesForClient(@i_clientId) vApp on vPkg.t_packageId = vApp.t_packageid
--#########################################
if ( (SELECT COUNT(*) FROM MMHost WHERE ClientId = @i_clientId) > 0 )
      INSERT INTO @clientPackages
SELECT 1002, 0, 1, 0, 0, 1
UPDATE @clientPackages
SET  t_packageId = dbo.GetPackageID(t_appTypeId, @simOSID)
WHERE t_packageId = 0
--##################################################################################
-- Fix for Cell level licenses which has client side package.
--##################################################################################
IF @i_clientId = 2
BEGIN
	DELETE @clientPackages
	WHERE t_appTypeId in (select appTypeId from simapptypelictypemap where isCellLevel = 1)
	AND NOT EXISTS (select 1 from simInstalledPackages where ClientId = @i_clientId and simPackageID = t_packageId)
END
--##################################################################################
-- make sure that non dummy apptypes, the apptype must exist in app_idaName table
--##################################################################################
DELETE @clientPackages
WHERE t_appTypeId > 0 AND NOT EXISTS (SELECT 1 FROM SIMGetDummyAppTypes WHERE appType = t_appTypeId) AND
	NOT EXISTS (SELECT 1 FROM APP_iDAName WITH (NOLOCK) WHERE clientId = @i_clientId AND apptypeId = t_appTypeId)
--##################################################################################
-- MR: 49286 -- During uninstall, we are incorrectly detecting that SharePoint Database V2 is installed
--##################################################################################
DELETE @clientPackages
WHERE	t_releaseId > 12 AND t_packageId in (902, 906)
--##################################################################################
--Fix For FS Advanced packages
--##################################################################################
UPDATE @clientPackages
SET t_flag = ISNULL((select MAX(CASE Optype when 'Install' then 1 else 0 END) from LicUsage where cid=@i_clientId AND licType IN (1, 2)), 0)
WHERE t_packageId in (SELECT * from @fileSystemAdvanced) AND t_flag = 0
--##################################################################################
-- Fix for Exchange Package
--##################################################################################
IF EXISTS (
	SELECT 1 FROM simInstalledPackages sip WITH(NOLOCK)
	JOIN PatchSPVersion psp WITH(NOLOCK) ON sip.SPVersionID = psp.id
	WHERE sip.clientid = @i_clientId
	AND psp.release >= 16
	AND psp.SPMajor >= 12 )
BEGIN
	IF EXISTS (SELECT 1 FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @i_clientId AND attrname = 'PackageStateForId 151')
	BEGIN
		INSERT INTO @clientPackages
SELECT 0, 151, attrVal, @clientRelease, (CASE WHEN attrVal = 1 THEN 4 ELSE 0 END), 0
		FROM APP_ClientProp
		WHERE componentNameId = @i_clientId AND attrname = 'PackageStateForId 151'
	END
	UPDATE @clientPackages
SET t_packageId = 151
WHERE t_packageId IN (151,
152,
153,
155,
157,
171)
END
--##################################################################################
-- Set the Installed State for the packages
--##################################################################################
UPDATE @clientPackages
SET t_bInstalledState = 0
WHERE NOT EXISTS (SELECT id FROM simInstalledPackages WITH (NOLOCK) WHERE clientID = @i_clientId AND simPackageID = t_packageId)
--##################################################################################
-- Updating installstate based on rows in simInstalledPackages table in case of virtual node(to cover restore only agents).
--##################################################################################
IF EXISTS (SELECT 1 from App_clientprop WITH (NOLOCK) where componentnameid = @i_clientId AND attrname = 'Virtual Client' AND attrval = '1')
BEGIN
       UPDATE @clientPackages
       SET t_bInstalledState = 1
       WHERE t_bInstalledState = 0
       AND EXISTS (select 1 from simInstalledPackages WITH (NOLOCK)
                           WHERE simpackageID = t_packageId
                           AND clientid in
                                  (select attrval from app_clientprop WITH (NOLOCK)
                                   where modified = 0 and
                                         componentnameid = @i_clientId and
                                         attrname = 'Active Physical Node' ))
END
--##################################################################################
-- Apply filters
--##################################################################################
IF (@i_filterFlags & 1) = 0
        DELETE FROM @clientPackages WHERE t_bConfigured = 0
IF (@i_filterFlags & 2) > 0	OR
(@i_filterFlags & 4	) > 0
BEGIN
	INSERT INTO @deprecatedUninstalledPackages
		SELECT  * FROM @clientPackages
WHERE t_packageId IN (SELECT id FROM simPackage WHERE (flag & 2) > 0) AND
			  t_packageId IN (SELECT t_packageId FROM @clientPackages WHERE t_bInstalledState = 0)
		AND NOT EXISTS
					(SELECT I.* FROM APP_iDAName I WITH (NOLOCK)
					JOIN simPackageMap M
					ON I.appTypeId = M.appType
					WHERE clientID = @i_clientId AND M.simPackageID = t_packageId)
END
IF (@i_filterFlags & 2) > 0
BEGIN
        DELETE FROM @clientPackages
		WHERE t_packageId IN (SELECT t_packageId from @deprecatedUninstalledPackages)
END
IF (@i_filterFlags & 4) > 0
BEGIN
        DELETE @clientPackages
		INSERT INTO @clientPackages
		SELECT *
		FROM @deprecatedUninstalledPackages
END
IF (@i_filterFlags & 8) > 0
BEGIN
	DELETE @clientPackages
	FROM	APP_iDANAME I WITH (NOLOCK), APP_iDAProp P WITH (NOLOCK)
	WHERE	I.clientID = @i_clientId AND I.appTypeId = t_appTypeId AND I.id = P.ComponentNameId AND P.attrName = 'Pseudo Apptype' AND P.attrVal = '1' AND P.modified = 0
END
--##################################################################################
-- Select all remaining entries
--##################################################################################
SELECT t_packageId, (SELECT name FROM SimPackage WHERE id = t_packageId),
	CASE WHEN MAX(t_bConfigured) > 0 AND MAX(t_bInstalledState) > 0 THEN 3 WHEN MAX(t_bConfigured) = 0 AND MAX(t_bInstalledState) > 0 THEN 2 WHEN MAX(t_bConfigured) > 0 AND MAX(t_bInstalledState) = 0 THEN 1 ELSE 0 END,
	MAX(t_releaseId), SUM(DISTINCT t_flag) , @simOSType
FROM	@clientPackages
WHERE	t_packageId > 0
GROUP BY t_packageId
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetInstalledPackages')
	delete from GxQscripts where name = 'simGetInstalledPackages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetInstalledPackages')
	delete from GXDBVersions where aliasname = 'simGetInstalledPackages'
GO

insert into GXDBVersions values(2, 'simGetInstalledPackages',  '00010041000200130000', 'simGetInstalledPackages', '00010041000200130000')
GO

