

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetInstalledPackageIDFromAppType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetInstalledPackageIDFromAppType.sp,v $ $Id: simGetInstalledPackageIDFromAppType.sp,v 1.1.274.1 2018/03/27 08:51:18 jiechen Exp $";
--
--  +========================================================================+
--  |      Cursor:  simGetInstalledPackageIDFromAppType()
--  |
--  | Description:  It gets the installed package ID from Apptype and simoperating system ID for a given client ID.
--	|
--  |	   Input :  Apptype/SimOperatingSystemID
--	|
--  |      Output:  It returns o_simPackageID.
--	|
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      Hemant Mishra  Getting SIM Installed PackageID from ClientID/Apptype/simoperating system ID
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetInstalledPackageIDFromAppType <<<'

IF EXISTS (select * from sysobjects where name='simGetInstalledPackageIDFromAppType')
	drop procedure simGetInstalledPackageIDFromAppType
IF EXISTS (select * from GxQscripts where name='simGetInstalledPackageIDFromAppType')
	delete from GxQscripts where name = 'simGetInstalledPackageIDFromAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetInstalledPackageIDFromAppType')
	delete from GXDBVersions where aliasname = 'simGetInstalledPackageIDFromAppType'
GO
print '... Creating Procedure: simGetInstalledPackageIDFromAppType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetInstalledPackageIDFromAppType
  @i_clientID integer,
  @i_appTypeID integer,
  @i_simOperatingSystemID integer
AS
  DECLARE @o_simPackageID integer
SET NOCOUNT ON
SET @o_simPackageID = dbo.GetPackageID(@i_appTypeID, @i_simOperatingSystemID)
IF(@i_appTypeID < 1000 AND
   @i_appTypeID NOT IN (select componentNameId from simAppTypeProp where attrName = 'DummyApptype' and attrVal = '1') AND
   NOT EXISTS (select * from APP_iDAName where clientId = @i_clientID AND apptypeId = @i_appTypeID))
	SELECT 0
ELSE
	SELECT @o_simPackageID
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetInstalledPackageIDFromAppType')
	delete from GxQscripts where name = 'simGetInstalledPackageIDFromAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetInstalledPackageIDFromAppType')
	delete from GXDBVersions where aliasname = 'simGetInstalledPackageIDFromAppType'
GO

insert into GXDBVersions values(2, 'simGetInstalledPackageIDFromAppType',  '00010001027400010000', 'simGetInstalledPackageIDFromAppType', '00010001027400010000')
GO

