

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetFullVersionAndOSInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetFullVersionAndOSInfo.sp,v $ $Id: simGetFullVersionAndOSInfo.sp,v 1.1.4.5 2020/06/18 14:43:11 tdontham Exp $";
--
--  +==============================================================================+
--  |   Cursor:  simGetFullVersionAndOSInfo
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ----------------------------------------------------------
--  |   1.0       tdontham  Gets the FullVersion and OS info of Installed Releases
--  +===============================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simGetFullVersionAndOSInfo')
BEGIN
	print '>>> Drop Stored Procedure: simGetFullVersionAndOSInfo <<<'
	drop procedure simGetFullVersionAndOSInfo
END
IF EXISTS (select * from GxQscripts where name='simGetFullVersionAndOSInfo')
	delete from GxQscripts where name = 'simGetFullVersionAndOSInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetFullVersionAndOSInfo')
	delete from GXDBVersions where aliasname = 'simGetFullVersionAndOSInfo'
GO
print '... Creating Procedure: simGetFullVersionAndOSInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetFullVersionAndOSInfo
AS
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_xmlText XML
-- These lines represent the actual SQL code that will get executed.
-- :PARAM input lines
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#AllSPOSInfo') IS NOT NULL DROP TABLE #AllSPOSInfo
CREATE TABLE #AllSPOSInfo
(
  release		INTEGER,
  build   		INTEGER,
  SPMajor  		INTEGER,
  SPMinor 		INTEGER,
  SPTransId 	INTEGER,
  RevisionId 	INTEGER,
  UPNumber 		INTEGER,
  UPTransId 	INTEGER,
  OSId 			INTEGER
)
INSERT INTO #AllSPOSInfo( release, build, SPMajor, SPMinor, SPTransId, RevisionId, UPNumber,  UPTransId, OSId )
SELECT DISTINCT
		psp2.release, psp2.build, psp2.SPMajor, psp2.SPMinor, max(psp2.TransactionID),max(psp2.RevisionID),
		MIN(COALESCE(pup.UPNumber,0)),min(COALESCE(pup.MaxTransactionID, 0)), p.NewUpdateOSID
	FROM PatchUpdateOS p WITH(NOLOCK)
	JOIN APP_ClientProp ap WITH(NOLOCK)  ON p.BinarySetID = ap.attrVal
	JOIN simInstalledPackages sip WITH(NOLOCK) on sip.ClientId = ap.componentNameId
	JOIN PatchSPVersion psp WITH(NOLOCK) ON sip.SPVersionID = psp.id
	JOIN PatchSPVersion psp2 WITH(NOLOCK) ON psp.release = psp2.Release AND psp.build = psp2.build AND psp.SPmajor = psp2.SPMajor and
			psp.SPMinor = psp2.SPMinor AND psp.TransactionID = psp2.TransactionID
	LEFT JOIN PatchuPVersion pup WITH(NOLOCK) on psp2.id = pup.SPVersionID AND sip.UPNumber = pup.UPNumber
	WHERE ap.attrName = 'Binary Set Id' AND ap.modified =0 AND psp2.nLTSFlag <> 2 AND psp2.Release>=16
	GROUP BY psp2.Release, psp2.build, psp2.SPMajor, psp2.SPMinor, p.NewUpdateOSID
	ORDER BY  psp2.SPMajoR
DECLARE @outputXml xml = (
	SELECT
		(SELECT
			release AS 'spVersion/@ReleaseId',
			build AS 'spVersion/@Build',
			SPMajor AS 'spVersion/@Major',
			SPMinor AS 'spVersion/@Minor',
			Max(SPTransId) AS 'spVersion/@TransactionId',
			Max(RevisionId) AS 'spVersion/@RevisionID',
				( SELECT ISNULL(MIN(UPNumber),0) AS 'cumulativeUpdatePackVersion/@Number' ,
              ISNULL(MAX(UPTransId),0) AS 'cumulativeUpdatePackVersion/@TransactionId'  where  SPMajor = aspv1.SPMajor and build = aspv1.build FOR XML PATH(''), TYPE ) FOR XML PATH('fullVersion'), TYPE ),
		( SELECT DISTINCT OSId AS updateOSId from #AllSPOSInfo where  SPMajor = aspv1.SPMajor and build = aspv1.build
			FOR XML RAW('OSId')  , type )
	FROM #AllSPOSInfo aspv1
	GROUP BY  release, build, SPMajor,SPMinor
	FOR XML PATH('verOs'),type)
SELECT @outputXml for xml raw('UpdatePatches_InstalledVerOs')
IF object_id('tempdb.dbo.#AllSPOSInfo') IS NOT NULL DROP TABLE #AllSPOSInfo

IF EXISTS (select * from GxQscripts where name = 'simGetFullVersionAndOSInfo')
	delete from GxQscripts where name = 'simGetFullVersionAndOSInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetFullVersionAndOSInfo')
	delete from GXDBVersions where aliasname = 'simGetFullVersionAndOSInfo'
GO

insert into GXDBVersions values(2, 'simGetFullVersionAndOSInfo',  '00010001000400050000', 'simGetFullVersionAndOSInfo', '00010001000400050000')
GO

