

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetFileCacheWebServerList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetFileCacheWebServerList.sp,v $ $Id: simGetFileCacheWebServerList.sp,v 1.1.2.2 2019/07/05 16:17:20 arasheed Exp $";
--
--  +========================================================================+
--  |      Procedure Name:  simGetFileCacheWebServerList.sp
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simGetFileCacheWebServerList')
BEGIN
	print '>>> Drop Stored Procedure: simGetFileCacheWebServerList <<<'
	drop procedure simGetFileCacheWebServerList
END
IF EXISTS (select * from GxQscripts where name='simGetFileCacheWebServerList')
	delete from GxQscripts where name = 'simGetFileCacheWebServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetFileCacheWebServerList')
	delete from GXDBVersions where aliasname = 'simGetFileCacheWebServerList'
GO
print '... Creating Procedure: simGetFileCacheWebServerList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetFileCacheWebServerList
AS
  DECLARE @o_componentNameId integer
  DECLARE @o_clientName char(1024)
  DECLARE @o_clientHostName char(1024)
  DECLARE @o_portNumber integer
  DECLARE @o_webAlias char(1024)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT CL.id AS clientId,
	name,
	net_hostname,
	ISNULL(MAX(CASE WHEN attrName='FileCacheWebService Port' THEN attrVal END),0) AS fcwsPort,
	ISNULL(MAX(CASE WHEN attrName='FileCacheWebService Alias' THEN attrVal END),'') AS fcwsAlias
FROM APP_Client (NOLOCK) AS CL
INNER JOIN APP_ClientProp (NOLOCK) AS CP ON CL.id = CP.componentNameId
WHERE CL.id IN (SELECT ClientId FROM simInstalledPackages WHERE SimPackageId = 272)
AND (attrName='FileCacheWebService Port' OR attrName='FileCacheWebService Alias')
GROUP BY CL.id, name, net_hostname
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simGetFileCacheWebServerList')
	delete from GxQscripts where name = 'simGetFileCacheWebServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetFileCacheWebServerList')
	delete from GXDBVersions where aliasname = 'simGetFileCacheWebServerList'
GO

insert into GXDBVersions values(2, 'simGetFileCacheWebServerList',  '00010001000200020000', 'simGetFileCacheWebServerList', '00010001000200020000')
GO

