

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetFSAgentAppType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetFSAgentAppType.sp,v $ $Id: simGetFSAgentAppType.sp,v 1.1.2.1 2020/03/11 01:00:47 anguyen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						Stored Proc: "simGetFSAgentAppType"				|
--	| Get Appropriate FileSystem apptype for a given physical client		|
--  |																		|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simGetFSAgentAppType')
BEGIN
	print '>>> Drop Stored Procedure: simGetFSAgentAppType <<<'
	drop procedure simGetFSAgentAppType
END
IF EXISTS (select * from GxQscripts where name='simGetFSAgentAppType')
	delete from GxQscripts where name = 'simGetFSAgentAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetFSAgentAppType')
	delete from GXDBVersions where aliasname = 'simGetFSAgentAppType'
GO
print '... Creating Procedure: simGetFSAgentAppType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetFSAgentAppType
  @i_clientId INTEGER
AS
SET NOCOUNT ON
BEGIN
	-- Only proceed if given client is a physical client
	--
	IF (EXISTS(SELECT 1 FROM simInstalledPackages WITH(NOLOCK) WHERE ClientId = @i_clientId))
	BEGIN
		SELECT TOP 1 appTypeId
		FROM APP_IDAName WITH(NOLOCK)
		WHERE clientId = @i_clientId AND appTypeId IN (SELECT DISTINCT appTypeId FROM GetAppTypesForAppGroup(35,0)) -- FS appgroup
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'simGetFSAgentAppType')
	delete from GxQscripts where name = 'simGetFSAgentAppType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetFSAgentAppType')
	delete from GXDBVersions where aliasname = 'simGetFSAgentAppType'
GO

insert into GXDBVersions values(2, 'simGetFSAgentAppType',  '00010001000200010000', 'simGetFSAgentAppType', '00010001000200010000')
GO

