

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetConsumedLicenses.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetConsumedLicenses.sp,v $ $Id: simGetConsumedLicenses.sp,v 1.14.198.1 2018/03/27 09:05:06 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetConsumedLicenses <<<'

IF EXISTS (select * from sysobjects where name='simGetConsumedLicenses')
	drop procedure simGetConsumedLicenses
IF EXISTS (select * from GxQscripts where name='simGetConsumedLicenses')
	delete from GxQscripts where name = 'simGetConsumedLicenses'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetConsumedLicenses')
	delete from GXDBVersions where aliasname = 'simGetConsumedLicenses'
GO
print '... Creating Procedure: simGetConsumedLicenses'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure simGetConsumedLicenses
  @xmlText XML
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
    CREATE TABLE #ConsumedLicenses (
     clientId integer ,
     licTypeId integer ,
     appTypeId integer,
     installFlag integer
    )
	declare		@i_clientId			INT
	declare		@i_releaseId		INT
	declare		@i_platform			INT
	SET @i_clientId	 = ISNULL(( SELECT ref.value('@clientId', 'int')
							FROM @xmlText.nodes('TMMsg_GetConsumedLicenseListReq/clientEntity') R ( ref ) ),
							0)
	SET @i_platform	 = ISNULL(( SELECT ref.value('@platformType', 'int')
							FROM @xmlText.nodes('TMMsg_GetConsumedLicenseListReq') R ( ref ) ),
							0)
	IF @i_clientId <> 0
	BEGIN
		SET @i_releaseId = (SELECT releaseid from APP_CLIENT WHERE ID = @i_clientId)
		IF @i_platform = 2
		BEGIN
		    -- Inserting the result in a temp table.
		    INSERT INTO #ConsumedLicenses
				EXEC LicGetInstalledClientAgentLicenses @i_clientId, 0, 2
		    -- It should return only MediaAgent and Block Level Dedup license
		    DELETE #ConsumedLicenses WHERE licTypeId NOT IN (11,12,13,14,15,48,53,72,33554432,67108864,168, 169, 139, 132, 84, 190)
		    SET @xmlText =
			(SELECT
			LU.[appTypeId] AS '@appType', LU.[licTypeId] AS '@licenseType', SLA.[short_name] + ' - ' + TY.name AS '@licenseName'
			FROM #ConsumedLicenses LU, simLicAppTypeV2 SLA,  APP_iDAType TY
			WHERE LU.clientId = @i_clientId
			AND TY.TYPE = LU.appTypeId
			AND LU.licTypeId = SLA.id AND LU.installFlag = 0
			FOR XML PATH('licenses'), ROOT('TMMsg_GetConsumedLicenseListResp'))
	        END
		ELSE
		BEGIN
			-- Inserting the result in a temp table.
			INSERT INTO #ConsumedLicenses
				EXEC LicGetInstalledClientAgentLicenses @i_clientId, 0, 4
			-- It should not return sharepoint DB license as it gets released along with sharepoint doc license if the client is on or above 8.0
			-- IF @i_releaseId > 12
			-- DELETE #ConsumedLicenses WHERE appTypeId = 69 OR licTypeId = 48
			SET @xmlText =
				(SELECT
				LU.[appTypeId] AS '@appType', LU.[licTypeId] AS '@licenseType', SLA.[short_name] + ' - ' + TY.name AS '@licenseName'
				FROM #ConsumedLicenses LU, simLicAppTypeV2 SLA, APP_iDAType TY
				WHERE LU.clientId = @i_clientId
				AND TY.TYPE = LU.appTypeId
				AND LU.licTypeId = SLA.id AND LU.installFlag = 0
				FOR XML PATH('licenses'), ROOT('TMMsg_GetConsumedLicenseListResp'))
		END
	END
	SELECT @xmlText
	drop table #ConsumedLicenses
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simGetConsumedLicenses')
	delete from GxQscripts where name = 'simGetConsumedLicenses'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetConsumedLicenses')
	delete from GXDBVersions where aliasname = 'simGetConsumedLicenses'
GO

insert into GXDBVersions values(2, 'simGetConsumedLicenses',  '00010014019800010000', 'simGetConsumedLicenses', '00010014019800010000')
GO

