

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetClientsWithDeprecatedOS.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetClientsWithDeprecatedOS.sp,v $ $Id: simGetClientsWithDeprecatedOS.sp,v 1.1.2.5 2020/09/03 17:44:11 xsui Exp $";
--
--  +========================================================================+
--  | Stored Precedure: simGetClientsWithDeprecatedOS
--  |
--  | Description:	Return a list of clients with deprecated OS
--  |
--  |
--  |   Revisions  Author           Description
--  |   ---------  -------          ---------------------------------------------
--  |   1.0        Xuemei	    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simGetClientsWithDeprecatedOS')
BEGIN
	print '>>> Drop Stored Procedure: simGetClientsWithDeprecatedOS <<<'
	drop procedure simGetClientsWithDeprecatedOS
END
IF EXISTS (select * from GxQscripts where name='simGetClientsWithDeprecatedOS')
	delete from GxQscripts where name = 'simGetClientsWithDeprecatedOS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetClientsWithDeprecatedOS')
	delete from GXDBVersions where aliasname = 'simGetClientsWithDeprecatedOS'
GO
print '... Creating Procedure: simGetClientsWithDeprecatedOS'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetClientsWithDeprecatedOS
  @i_clientID integer=0,
  @i_bPreUpgrade integer=0
AS
-- Output variables of the stored procedure
  DECLARE @o_clientId INTEGER
  DECLARE @o_OSVersion VARCHAR(64)
  DECLARE @o_osName VARCHAR(64)
  DECLARE @o_isCS INTEGER
SET NOCOUNT ON
IF object_id('tempdb.dbo.#clientsWithDeprecatedOS') is not null	DROP TABLE #clientsWithDeprecatedOS
IF object_id('tempdb.dbo.#guestOsVersionTable') is not null	DROP TABLE #guestOsVersionTable
CREATE TABLE #clientsWithDeprecatedOS (	clientId INT, operatingSystemVersion VARCHAR(256), operatingSystemName VARCHAR(256),
					installedV1 VARCHAR(32), installedV2 VARCHAR(32), blockedV1 INT, blockedV2 FLOAT, nGlibcLen INT, bDeprecated INT)
CREATE TABLE #guestOsVersionTable (name varchar(255), versionNumber float)
DECLARE @supportedVersion	FLOAT = 6.2
DECLARE @csClientID		INT = 2
DECLARE @delim			VARCHAR(32) = ':-'
-- Include warning for preupgrade report: Windows MA
IF @i_bPreUpgrade > 0
BEGIN
	INSERT INTO #guestOsVersionTable
	SELECT	CASE WHEN CHARINDEX(@delim, OSVersion) > 0 THEN SUBSTRING(OSVersion, 1, CHARINDEX(@delim, OSVersion) - 1) ELSE 'Unknown OS' END,
		CASE WHEN CHARINDEX(@delim, OSVersion) > 0 THEN CAST(SUBSTRING(OSVersion, CHARINDEX(@delim, OSVersion)+2, LEN(OSVersion)) AS FLOAT) ELSE '' END
	FROM	SimDeprecatedOS
WHERE	packageID = 51
	INSERT INTO #clientsWithDeprecatedOS
	SELECT DISTINCT C.id, dbo.GetClientOSRelease(C.id, ''), dbo.scgGetClientOSName(C.id), '', '', '', '', 0, 1
	FROM APP_Client C WITH (NOLOCK) JOIN simInstalledPackages SIP WITH (NOLOCK) on C.id = SIP.ClientId
WHERE SIP.simPackageID = 51 OR
		(	(C.id = @csClientID OR C.id IN (SELECT PMClientId from APP_VmToPMMap NOLOCK WHERE VMClientId = @csClientID)) AND
			 C.simOperatingSystemID IN (select id from SimOperatingSystem NOLOCK where type = 'Windows'))
	UPDATE  #clientsWithDeprecatedOS
	SET operatingSystemVersion = GOS.versionNumber
	FROM #clientsWithDeprecatedOS MA JOIN #guestOsVersionTable GOS ON MA.operatingSystemVersion = GOS.name
	WHERE CHARINDEX('w', MA.operatingSystemVersion) = 1
	DELETE #clientsWithDeprecatedOS
	WHERE operatingSystemVersion = 'New' OR ISNUMERIC(operatingSystemVersion) > 0 AND operatingSystemVersion >= @supportedVersion
	GOTO SP_EXIT
END
IF @i_clientID > 0 AND EXISTS (SELECT 1 FROM GxGlobalParam NOLOCK WHERE name = 'PushSkipDeprecatedOSSP' AND Value <> '0')
	GOTO SP_EXIT
-- Blocked by download & push
INSERT INTO #clientsWithDeprecatedOS
SELECT DISTINCT P.ComponentNameID, dbo.GetClientOSRelease(P.ComponentNameID, ''), dbo.scgGetClientOSName(P.ComponentNameID), '', '', '', '', 0, 1
FROM APP_ClientProp P WITH (NOLOCK)	JOIN patchUpdateOS O WITH (NOLOCK) ON P.attrName = 'Binary Set ID' and modified = 0 and attrval = O.binarysetID
JOIN SimDeprecatedOS D WITH (NOLOCK) ON D.UpdateOSId = O.NewUpdateOSID AND D.BinarySetID = 0
WHERE (@i_clientID = 0 OR @i_clientID = P.ComponentNameID) AND P.ComponentNameID IN (select clientID from simInstalledPackages NOLOCK)
-- Blocked by installer
INSERT INTO #clientsWithDeprecatedOS
SELECT DISTINCT P.ComponentNameID, dbo.GetClientOSRelease(P.ComponentNameID, ''), dbo.scgGetClientOSName(P.ComponentNameID), '', '', '', '', 0, 1
FROM APP_ClientProp P WITH (NOLOCK) JOIN SimDeprecatedOS D WITH (NOLOCK) ON attrName = 'Binary Set ID' and modified = 0 and attrval = D.binarysetID AND (D.flags & 0x1) = 0
WHERE (@i_clientID = 0 OR @i_clientID = P.ComponentNameID) AND P.ComponentNameID IN (select clientID from simInstalledPackages NOLOCK)
-- Windows Version lower than server 2008 and vista are deprecated
INSERT INTO #clientsWithDeprecatedOS
SELECT DISTINCT C.id, dbo.GetClientOSRelease(C.id, ''), dbo.scgGetClientOSName(C.id), '', '',
		substring(D.OSVersion, 0, CHARINDEX('.', D.OSVersion)),
		substring(D.OSVersion, CHARINDEX('.', D.OSVersion) + 1, LEN(D.OSVersion) - LEN(CHARINDEX('.', D.OSVersion))), 0, -1
FROM APP_Client C WITH (NOLOCK)	JOIN simInstalledPackages P WITH (NOLOCK) ON C.id = P.ClientId AND P.simpackageID = 1
				JOIN SimDeprecatedOS D WITH (NOLOCK) ON P.simpackageID = D.packageID
WHERE @i_clientID = 0 OR @i_clientID = C.ID
-- Linux clients with glibc
DECLARE @glibcLen INT = LEN('glibc')+1
INSERT INTO #clientsWithDeprecatedOS
SELECT DISTINCT P.ComponentNameID, attrval, dbo.scgGetClientOSName(P.ComponentNameID), '', '',
		substring(D.OSVersion, @glibcLen, CHARINDEX('.', D.OSVersion)-@glibcLen),
		substring(D.OSVersion, CHARINDEX('.', D.OSVersion) + 1, LEN(D.OSVersion) - LEN(CHARINDEX('.', D.OSVersion))), (CASE CHARINDEX('glibc',attrval) WHEN 0 THEN 0 ELSE @glibcLen END), -1
FROM APP_ClientProp P WITH (NOLOCK), SimDeprecatedOS D WITH (NOLOCK)
WHERE (@i_clientID = 0 OR @i_clientID = P.ComponentNameID) AND P.ComponentNameID IN (select clientID from simInstalledPackages NOLOCK) AND
attrName = 'SIM OS DETAILS' and modified = 0 AND D.binarysetID = 7 AND (D.flags & 0x1) > 0
-- Comparing version
UPDATE #clientsWithDeprecatedOS
SET	installedV1 = (CASE	WHEN CHARINDEX('.',operatingSystemVersion) > 0
					THEN substring(operatingSystemVersion, nGlibcLen, CHARINDEX('.',operatingSystemVersion)-nGlibcLen)
				ELSE installedV1 END),
	installedV2 = (CASE 	WHEN CHARINDEX('.',operatingSystemVersion) > 0
					THEN substring(operatingSystemVersion, CHARINDEX('.', operatingSystemVersion) + 1, LEN(operatingSystemVersion) - LEN(CHARINDEX('.', operatingSystemVersion)))
				ELSE '' END)
WHERE bDeprecated < 0
UPDATE #clientsWithDeprecatedOS
SET bDeprecated = CASE WHEN installedV1 > 0 AND installedV1 < blockedV1 OR installedV1 = blockedV1 AND installedV2 < blockedV2 THEN 1 ELSE 0 END
WHERE bDeprecated < 0
SP_EXIT:
	SELECT DISTINCT clientId, operatingSystemVersion,
		operatingSystemName = (CASE WHEN CHARINDEX(':-', operatingSystemName) > 0 THEN SUBSTRING(operatingSystemName, 1, CHARINDEX(':-', operatingSystemName) - 1) ELSE 'Unknown OS' END),
		isCS = (CASE WHEN (clientId = @csClientID OR clientId IN (SELECT PMClientId from APP_VmToPMMap NOLOCK WHERE VMClientId = @csClientID)) THEN 1 ELSE 0 END)
	FROM #clientsWithDeprecatedOS WHERE bDeprecated > 0
GO

IF EXISTS (select * from GxQscripts where name = 'simGetClientsWithDeprecatedOS')
	delete from GxQscripts where name = 'simGetClientsWithDeprecatedOS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetClientsWithDeprecatedOS')
	delete from GXDBVersions where aliasname = 'simGetClientsWithDeprecatedOS'
GO

insert into GXDBVersions values(2, 'simGetClientsWithDeprecatedOS',  '00010001000200050000', 'simGetClientsWithDeprecatedOS', '00010001000200050000')
GO

