

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetClientUpdatedBinarySetId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   simGetClientUpdatedBinarySetId.SP   - Get the updated binary set id of a given client id
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetClientUpdatedBinarySetId <<<'

IF EXISTS (select * from sysobjects where name='simGetClientUpdatedBinarySetId')
	drop procedure simGetClientUpdatedBinarySetId
IF EXISTS (select * from GxQscripts where name='simGetClientUpdatedBinarySetId')
	delete from GxQscripts where name = 'simGetClientUpdatedBinarySetId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetClientUpdatedBinarySetId')
	delete from GXDBVersions where aliasname = 'simGetClientUpdatedBinarySetId'
GO
print '... Creating Procedure: simGetClientUpdatedBinarySetId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetClientUpdatedBinarySetId
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @clientId INTEGER
AS
  DECLARE @binarySetId INTEGER
DECLARE @origOsName  VARCHAR(MAX)
DECLARE @osVersion   VARCHAR(MAX)
DECLARE @version     FLOAT
SET NOCOUNT ON
SET @binarySetId = (SELECT attrVal FROM App_ClientProp WITH (READUNCOMMITTED) WHERE componentNameId = @clientId AND attrName = 'Binary set ID')
SET @origOsName = (SELECT name FROM simBinaryset WITH (READUNCOMMITTED) WHERE id = @binarySetId)
-- Update the binary set id only if current os name is AIX and version is like 5.X
IF @origOsName LIKE 'aix5.%'
BEGIN
       SET @osVersion = ISNULL(dbo.getClientOSVersion(@clientId, NULL), '')
       SET @version = CAST(@osVersion AS FLOAT)
       IF @version >= 6
       BEGIN
           SET @binarySetId = (SELECT id FROM simBinarySet WITH (READUNCOMMITTED) WHERE name = 'aix6.1')
       END
END
SELECT @binarySetId
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetClientUpdatedBinarySetId')
	delete from GxQscripts where name = 'simGetClientUpdatedBinarySetId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetClientUpdatedBinarySetId')
	delete from GXDBVersions where aliasname = 'simGetClientUpdatedBinarySetId'
GO

insert into GXDBVersions values(2, 'simGetClientUpdatedBinarySetId',  '00000000000000000000', 'simGetClientUpdatedBinarySetId', '00000000000000000000')
GO

