

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetClientPackageSPVersion.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetClientPackageSPVersion.sp,v $ $Id: simGetClientPackageSPVersion.sp,v 1.1.2.10 2018/05/07 17:16:24 kgao Exp $";
--
--  +========================================================================+
--  |   Cursor:  simGetClientPackageSPVersion
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |   1.0       Philip  Gets the SPVersion info for the given client and package
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetClientPackageSPVersion <<<'

IF EXISTS (select * from sysobjects where name='simGetClientPackageSPVersion')
	drop procedure simGetClientPackageSPVersion
IF EXISTS (select * from GxQscripts where name='simGetClientPackageSPVersion')
	delete from GxQscripts where name = 'simGetClientPackageSPVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetClientPackageSPVersion')
	delete from GXDBVersions where aliasname = 'simGetClientPackageSPVersion'
GO
print '... Creating Procedure: simGetClientPackageSPVersion'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetClientPackageSPVersion
  @i_clientId integer,
  @i_packageId integer = 0
AS
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_release INT
  DECLARE @o_build INT
  DECLARE @o_majorSP INT
  DECLARE @o_minorSP INT
  DECLARE @o_revisionId INT
  DECLARE @o_timestamp INT
  DECLARE @o_transactionId INT
  DECLARE @o_friendlyName VARCHAR(MAX)
-- These lines represent the actual SQL code that will get executed.
-- :PARAM input lines
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT TOP 1
       psp2.release,
       dbo.GetBuildNum(psp.release),
       psp2.SPMajor,
       psp2.SPMinor,
       psp2.RevisionId,
       0,
       psp2.TransactionID,
       ''
       FROM simInstalledPackages sip
       JOIN PatchSPVersion psp ON sip.SPVersionID = psp.id
       JOIN PatchSPVersion psp2 ON psp.release = psp2.Release AND psp.build = psp2.build AND psp.SPmajor = psp2.SPMajor and psp.SPMinor = psp2.SPMinor AND psp.TransactionID = psp2.TransactionID
       WHERE sip.clientid = @i_clientid AND
       sip.simPackageID = CASE WHEN @i_packageId = 0 THEN sip.simPackageID ELSE @i_packageId END
       ORDER BY sip.HighestSP DESC, sip.SpMinorVersion DESC, psp2.TransactionID DESC, psp2.RevisionId DESC
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetClientPackageSPVersion')
	delete from GxQscripts where name = 'simGetClientPackageSPVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetClientPackageSPVersion')
	delete from GXDBVersions where aliasname = 'simGetClientPackageSPVersion'
GO

insert into GXDBVersions values(2, 'simGetClientPackageSPVersion',  '00010001000200100000', 'simGetClientPackageSPVersion', '00010001000200100000')
GO

