

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetClientPackageFullVersion.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetClientPackageFullVersion.sp,v $ $Id: simGetClientPackageFullVersion.sp,v 1.1.4.8 2019/12/06 15:31:04 kgao Exp $";
--
--  +========================================================================+
--  |   Cursor:  simGetClientPackageFullVersion
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |   1.0       Philip  Gets the FullVersion info for the given client and package
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simGetClientPackageFullVersion')
BEGIN
	print '>>> Drop Stored Procedure: simGetClientPackageFullVersion <<<'
	drop procedure simGetClientPackageFullVersion
END
IF EXISTS (select * from GxQscripts where name='simGetClientPackageFullVersion')
	delete from GxQscripts where name = 'simGetClientPackageFullVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetClientPackageFullVersion')
	delete from GXDBVersions where aliasname = 'simGetClientPackageFullVersion'
GO
print '... Creating Procedure: simGetClientPackageFullVersion'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetClientPackageFullVersion
  @i_clientId integer,
  @i_packageId integer = 0
AS
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_xmlText XML
-- These lines represent the actual SQL code that will get executed.
-- :PARAM input lines
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @spVersion XML=
	(SELECT TOP 1
		   (psp2.release - 5) AS Version,
		   psp2.release AS ReleaseId,
		   dbo.GetBuildNum(psp.release) AS Build,
		   psp2.SPMajor As Major,
		   psp2.SPMinor As Minor,
		   psp2.RevisionId As RevisionID,
		   0 AS Timestamp,
		   psp2.TransactionID As TransactionId,
		   '' AS FriendlyName
	FROM simInstalledPackages sip WITH(NOLOCK)
	JOIN PatchSPVersion psp WITH(NOLOCK) ON sip.SPVersionID = psp.id
	JOIN PatchSPVersion psp2 WITH(NOLOCK) ON psp.release = psp2.Release AND psp.build = psp2.build AND psp.SPmajor = psp2.SPMajor and psp.SPMinor = psp2.SPMinor AND psp.TransactionID = psp2.TransactionID
	WHERE sip.clientid = @i_clientid AND
	sip.simPackageID = CASE WHEN @i_packageId = 0 THEN sip.simPackageID ELSE @i_packageId END
	ORDER BY sip.HighestSP DESC, sip.SpMinorVersion DESC, psp2.TransactionID DESC, psp2.RevisionId DESC
	FOR XML RAW('spVersion'))
DECLARE @upVersion XML = ISNULL((SELECT TOP 1 pup.UPNumber as Number, pup.MaxTransactionID AS TransactionID
		FROM simInstalledPackages sip WITH(NOLOCK) JOIN PatchUPVersion pup WITH(NOLOCK) ON sip.UPNumber = pup.UPNumber
			JOIN PatchSPVersion psp1 WITH(NOLOCK) ON psp1.id = sip.spVersionId JOIN PatchSPVersion psp2 WITH(NOLOCK) ON psp2.id = pup.spVersionId
		WHERE clientid = @i_clientId AND psp1.release = psp2.release AND psp1.build = psp2.build AND psp1.SPMajor = psp2.SPMajor AND psp1.SPMinor = psp2.SPMinor AND psp1.TransactionId = psp2.TransactionId
		ORDER BY pup.UPNumber DESC, pup.MaxTransactionID DESC
		FOR XML RAW('cumulativeUpdatePackVersion')),
		(SELECT 0 AS Number, 0 AS TransactionId FOR XML RAW('cumulativeUpdatePackVersion')))
SELECT @spVersion, @upVersion
FOR XML RAW('FullVersion')
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetClientPackageFullVersion')
	delete from GxQscripts where name = 'simGetClientPackageFullVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetClientPackageFullVersion')
	delete from GXDBVersions where aliasname = 'simGetClientPackageFullVersion'
GO

insert into GXDBVersions values(2, 'simGetClientPackageFullVersion',  '00010001000400080000', 'simGetClientPackageFullVersion', '00010001000400080000')
GO

