

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetClientList.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simGetClientList')
BEGIN
	print '>>> Drop Stored Procedure: simGetClientList <<<'
	drop procedure simGetClientList
END
IF EXISTS (select * from GxQscripts where name='simGetClientList')
	delete from GxQscripts where name = 'simGetClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetClientList')
	delete from GXDBVersions where aliasname = 'simGetClientList'
GO
print '... Creating Procedure: simGetClientList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure simGetClientList
  @i_userID integer,
  @i_releaseId integer,
  @i_requestFlags integer
AS
  DECLARE @o_clientID integer
  DECLARE @o_clientGUID uniqueidentifier
  DECLARE @o_clientName nvarchar(255)
  DECLARE @o_clientHostName nvarchar(255)
  DECLARE @o_clientDisplayName nvarchar(255)
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#clientsToReturn') IS NOT NULL DROP TABLE #clientsToReturn
CREATE TABLE #clientsToReturn (t_Id INT, t_GUID uniqueidentifier, t_name nvarchar(255), t_HostName nvarchar(255), t_displayName nvarchar(255))
IF (@i_requestFlags & 0x400) > 0
BEGIN
	INSERT INTO #clientsToReturn
	SELECT	id, GUID, name, net_hostname, displayname
	FROM	APP_client NOLOCK
WHERE	id > 2 AND (@i_releaseId = 0 OR @i_releaseId = releaseID) AND (status & 0x00020) = 0 AND (status & 0x00010) = 0 AND (status & 0x1000) > 0
END
ELSE IF (@i_requestFlags & 0x200) > 0
BEGIN
	INSERT INTO #clientsToReturn
	SELECT	id, GUID, name, net_hostname, displayname
	FROM	APP_client NOLOCK
WHERE	id > 2 AND (@i_releaseId = 0 OR @i_releaseId = releaseID) AND (status & 0x00020) = 0 AND (status & 0x00010) = 0 AND
		id in (	SELECT DISTINCT clientID
			FROM	(select A.clientID, A.id from APP_Application A WITH(NOLOCK) JOIN APP_iDAType I WITH(NOLOCK) ON I.name like 'Windows% file system' and A.appTypeID = I.type) T1
			JOIN	(select DISTINCT appId from JMBkpStats NOLOCK WHERE status in (1, 3, 14)) T2 ON T1.id = T2.appId)
END
ELSE IF (@i_requestFlags & 0x80) > 0
BEGIN
	INSERT INTO #clientsToReturn
	SELECT	id, GUID, name, net_hostname, displayname
	FROM	APP_client NOLOCK
	WHERE	(@i_releaseId = 0 OR @i_releaseId = releaseID) AND
		id IN ( SELECT DISTINCT clientID
			FROM	(select A.clientID, A.id from APP_Application A WITH(NOLOCK) JOIN APP_iDAType I WITH(NOLOCK) ON I.name like 'Windows% file system' and A.appTypeID = I.type) T1
JOIN	(select DISTINCT appId from JMBkpStats NOLOCK WHERE (bkpattributes & 0x100000) > 0 AND status in (1, 3, 14)) T2 ON T1.id = T2.appId)
END
ELSE IF (@i_requestFlags & 0x1) > 0 OR (@i_requestFlags & 0x2) > 0
BEGIN
	INSERT INTO #clientsToReturn
	SELECT	id, GUID, name, net_hostname, displayname
	FROM	APP_client NOLOCK
WHERE	id > 2 AND (@i_releaseId = 0 OR @i_releaseId = releaseID) AND (status & 0x00002) > 0 AND id IN (select cid from licusage NOLOCK where optype = 'uninstall')
END
ELSE IF (@i_requestFlags & 0x40) > 0
BEGIN
	INSERT INTO #clientsToReturn
	SELECT	id, GUID, name, net_hostname, displayname
	FROM	APP_client NOLOCK
WHERE	id > 2 AND (@i_releaseId = 0 OR @i_releaseId = releaseID) AND (status & 0x00020) = 0 AND (status & 0x00010) = 0
END
ELSE IF (@i_requestFlags & 0x8) > 0
BEGIN	--all clients - restore only client + deconfigured clients
	INSERT INTO #clientsToReturn
	SELECT	id, GUID, name, net_hostname, displayname
	FROM	APP_client NOLOCK
WHERE	id > 2 AND (@i_releaseId = 0 OR @i_releaseId = releaseID) AND (status & 0x00002) > 0 AND
		(id IN (select clientID from SimInstalledPackages NOLOCK) OR id IN (select cid from licusage NOLOCK where optype = 'uninstall'))
END
ELSE
BEGIN
	INSERT INTO #clientsToReturn
	SELECT	id, GUID, name, net_hostname, displayname
	FROM	APP_client NOLOCK JOIN (select DISTINCT clientID from SimInstalledPackages NOLOCK) T ON id = clientID
	WHERE	@i_releaseId = 0 OR @i_releaseId = releaseID
END
IF @i_userID > 0
BEGIN
	IF OBJECT_ID('tempdb.dbo.#clientListByUser') IS NOT NULL DROP TABLE #clientListByUser
	CREATE TABLE #clientListByUser (t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT)
EXEC sec_getIdaObjectsForUser @i_userID, 3, 0, 0, '#clientListByUser'
	DELETE #clientsToReturn WHERE t_Id NOT IN (select t_clientId from #clientListByUser)
	DROP TABLE #clientListByUser
END
SELECT * FROM #clientsToReturn
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simGetClientList')
	delete from GxQscripts where name = 'simGetClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetClientList')
	delete from GXDBVersions where aliasname = 'simGetClientList'
GO

insert into GXDBVersions values(2, 'simGetClientList',  '00000000000000000000', 'simGetClientList', '00000000000000000000')
GO

