

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetClientIDsByNames.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetClientIDsByNames.sp,v $ $Id: simGetClientIDsByNames.sp,v 1.1.2.2 2020/12/07 20:27:12 xsui Exp $";
--
--  +========================================================================+
--  | Stored Precedure: simGetClientIDsByNames
--  |
--  | Description:	Return client IDs by lookup names
--  |
--  |
--  |   Revisions  Author           Description
--  |   ---------  -------          ---------------------------------------------
--  |   1.0        Xuemei	    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='simGetClientIDsByNames')
BEGIN
	print '>>> Drop Stored Procedure: simGetClientIDsByNames <<<'
	drop procedure simGetClientIDsByNames
END
IF EXISTS (select * from GxQscripts where name='simGetClientIDsByNames')
	delete from GxQscripts where name = 'simGetClientIDsByNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetClientIDsByNames')
	delete from GXDBVersions where aliasname = 'simGetClientIDsByNames'
GO
print '... Creating Procedure: simGetClientIDsByNames'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure simGetClientIDsByNames
  @i_clientName NVARCHAR(255),
  @i_hostName NVARCHAR(255),
  @i_GUID VARCHAR(255),
  @i_CVDPort integer,
  @i_jobID BIGINT,
  @i_options integer=0
AS
-- Output variables of the stored procedure
  DECLARE @o_clientId INTEGER
SET NOCOUNT ON
DECLARE @clientIDs	TABLE (t_id INT, t_name NVARCHAR(255), t_hostName NVARCHAR(255), t_port INT, bVM INT, bExactMatch INT)
IF @i_jobID > 0
	INSERT INTO @clientIDs SELECT clientId, clientName, net_hostname, cvdPort, 0, 1
	FROM JMQinetixUpdateStatus J WITH (NOLOCK) JOIN APP_Client C WITH (NOLOCK) ON J.clientId = C.id
	WHERE Jobid = @i_jobID AND clientName = @i_clientName
IF NOT EXISTS (select 1 from @clientIDs)
BEGIN
IF @i_GUID <> ''
	INSERT INTO @clientIDs SELECT id, name, net_hostname, cvdPort, 0, 1
	FROM APP_Client NOLOCK WHERE GUID = @i_GUID
ELSE IF @i_hostName <> ''
	INSERT INTO @clientIDs SELECT id, name, net_hostname, cvdPort, 1, 1
	FROM APP_Client (NOLOCK)
	WHERE id IN (	SELECT	componentNameID
			FROM    (	SELECT componentNameID, attrName, attrVal FROM APP_clientProp NOLOCK
					WHERE attrName IN ('Virtual Machine IP Address','Virtual Machine Name','Virtual Machine Deletion Time') AND modified = 0) T
			PIVOT	(MAX(attrVal) FOR attrName IN ([Virtual Machine IP Address], [Virtual Machine Name], [Virtual Machine Deletion Time])) AS P
			WHERE	[Virtual Machine IP Address] = @i_hostName AND [Virtual Machine Name] = @i_clientName AND [Virtual Machine Deletion Time] = 0	)
END
IF NOT EXISTS (select 1 from @clientIDs)
BEGIN
IF (@i_options & 0x1) = 0
		INSERT INTO @clientIDs SELECT id, name, net_hostname, cvdPort, 0, 0
		FROM APP_Client NOLOCK WHERE name = @i_clientName AND (@i_hostName = '' OR net_hostname = @i_hostName)
ELSE IF (@i_options & 0x2) > 0 OR (@i_options & 0x4) > 0
		INSERT INTO @clientIDs SELECT id, name, net_hostname, cvdPort, 0, 0
		FROM APP_Client NOLOCK WHERE name = @i_clientName OR name like (@i_clientName + '[_][_][_]%[0-9]')
	ELSE
		INSERT INTO @clientIDs SELECT id, name, net_hostname, cvdPort, 0, 0
		FROM APP_Client NOLOCK WHERE name = @i_clientName OR name like (@i_clientName + '[_][_][_]%[0-9]') OR net_HostName = @i_hostName
END
UPDATE @clientIDs SET bVM = 1
WHERE (	t_id IN (SELECT componentNameID FROM APP_ClientProp NOLOCK WHERE attrname IN ('Virtual Server Discovered Clients', 'Mini SRM Agent') AND attrVal = '1' AND modified = 0)
	OR
	t_id IN (SELECT A.clientID FROM APP_ClientGroup G WITH (NOLOCK) JOIN APP_ClientGroupAssoc A WITH (NOLOCK) ON G.id = A.clientGroupId AND G.name LIKE '%NBU_%')	)
	AND
	t_id NOT IN (SELECT clientID FROM SimInstalledPackages NOLOCK)
IF (@i_options & 0x2) = 0 AND (@i_options & 0x4) = 0
	DELETE @clientIDs WHERE bVM = 0 AND @i_clientName <> t_name AND @i_CVDPort > 0 AND t_port > 0 AND @i_CVDPort <> t_port
UPDATE @clientIDs SET bExactMatch = 1
WHERE	(t_name = @i_clientName OR t_name like (@i_clientName + '[_][_][_]%[0-9]')) AND t_hostName = @i_hostName AND t_port = @i_CVDPort
-- RETURN RESULT
SELECT t_id FROM @clientIDs ORDER BY bExactMatch DESC, t_port DESC
GO

IF EXISTS (select * from GxQscripts where name = 'simGetClientIDsByNames')
	delete from GxQscripts where name = 'simGetClientIDsByNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetClientIDsByNames')
	delete from GXDBVersions where aliasname = 'simGetClientIDsByNames'
GO

insert into GXDBVersions values(2, 'simGetClientIDsByNames',  '00010001000200020000', 'simGetClientIDsByNames', '00010001000200020000')
GO

