

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetClientConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetClientConfig.sp,v $ $Id: simGetClientConfig.sp,v 1.11.60.4 2019/03/11 16:33:21 xsui Exp $";
--
--  +========================================================================+
--  |      Cursor:  simGetClientConfig.sp()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simGetClientConfig')
BEGIN
	print '>>> Drop Stored Procedure: simGetClientConfig <<<'
	drop procedure simGetClientConfig
END
IF EXISTS (select * from GxQscripts where name='simGetClientConfig')
	delete from GxQscripts where name = 'simGetClientConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetClientConfig')
	delete from GXDBVersions where aliasname = 'simGetClientConfig'
GO
print '... Creating Procedure: simGetClientConfig'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetClientConfig
  @in_clientId integer,
  @in_includeDeConfigPackages integer=0
AS
  DECLARE @outputConfig XML
DECLARE @clientOSId INTEGER
DECLARE @osVersion char(1024)
DECLARE @simOSName char(1024)
declare @tempTblComponents TABLE (ComponentId int, ComponentName varchar(1024), installed int, releaseid int, nstatus int, OSType varchar(1024))
SET NOCOUNT ON
INSERT @tempTblComponents (ComponentId , ComponentName , installed , releaseid , nstatus, OSType)
	exec  simGetInstalledPAckages @in_clientId,@in_includeDeConfigPackages
SET @clientOSId = (SELECT simOperatingSystemId from APP_Client WHERE id = @in_clientId)
SET @osVersion = (SELECT TOP 1 Version FROM simOperatingSystem WHERE id = @clientOSId)
SET @simOSName = substring(dbo.GetPropValue('Sim OS Info', @in_clientId), 0, CHARINDEX(':-', dbo.GetPropValue('Sim OS Info', @in_clientId)))
BEGIN TRY
set @outputConfig =
(
		SELECT
		(
			SELECT TOP 1
			-- fill cvd port and password
			Client.clientDescription AS 'client/@clientDescription',
			Client.client_password AS  'client/@clientPassword',
			Client.cvdPort AS 'client/@cvdPort',
			Client.evmgrcPort AS 'client/@evmgrcPort',
			-- fill in install and job results dir
			appPlatform.install_dir AS 'client/@installDirectory',
			Client.jobResultDir AS 'client/jobResulsDir/@path',
			ISNULL(dbo.GetPropValue('Job Results Dir Username', Client.id), '') AS 'client/jobResulsDir/userAccount/@userName',
			ISNULL(dbo.GetPropValue('Job Results Dir Password', Client.id), '') AS 'client/jobResulsDir/userAccount/@password',
			-- fill in client entity
			Client.id  AS 'client/clientEntity/@clientId',
			Client.name  AS 'client/clientEntity/@clientName',
			Client.net_hostname AS 'client/clientEntity/@hostName',
			(select '3') AS 'client/clientEntity/@_type_',
			-- fill in OS information
			Client.simOperatingSystemId AS 'client/osInfo/@osId',
			--dbo.GetClientOSRelease(Client.id, dbo.GetPropValue('Sim OS Info', Client.id)) AS 'client/osInfo/@Version',
			RTrim(@osVersion) AS 'client/osInfo/@Version',
			(select Type from simOperatingSystem where id = Client.simOperatingSystemId) AS 'client/osInfo/@Type',
			(select SubType from simOperatingSystem where id = Client.simOperatingSystemId) AS 'client/osInfo/@SubType',
			(select PlatformType from simOperatingSystem where id = Client.simOperatingSystemId) AS 'client/osInfo/@PlatformType',
			-- fill in OS display information
			--dbo.GetClientOSName(Client.id, dbo.GetPropValue('Sim OS Info', Client.id)) AS 'client/osInfo/OsDisplayInfo/@OSName',
			RTrim(@simOSName) AS 'client/osInfo/OsDisplayInfo/@OSName',
			dbo.GetClientHardwareName(Client.id, dbo.GetPropValue('Sim OS Info', Client.id)) AS 'client/osInfo/OsDisplayInfo/@ProcessorType',
			dbo.GetClientOSVersion(Client.id, dbo.GetPropValue('Sim OS Info', Client.id)) AS 'client/osInfo/OsDisplayInfo/@OSBuild',
			--fill in Galaxy release information
			dbo.GetPropValue('Galaxy Build', Client.id) AS 'client/versionInfo/@GalaxyBuildNumber',
			Client.releaseId AS 'client/versionInfo/GalaxyRelease/@ReleaseID',
			(select release from simAllGalaxyRel where id = Client.releaseId) AS 'client/versionInfo/GalaxyRelease/@ReleaseString',
			(select '58') AS 'client/versionInfo/GalaxyRelease/@_type_',
			--fill in client props
			ISNULL(dbo.GetPropValue('Virtual Client', Client.id), 0) AS 'clientProps/@IsVirtualClient',
			dbo.GetPropValue('DataPipeInterface', Client.id) AS 'clientProps/@ClientInterface',
			dbo.GetPropValue('Binary Set ID', Client.id) AS 'clientProps/@BinarySetID',
			ISNULL(dbo.GetPropValue('CPU count', Client.id), 0) AS 'clientProps/@CPUCount',
			dbo.GetPropValue('Byte Order', Client.id) AS 'clientProps/@byteOrder',
			ISNULL(dbo.GetPropValue('Galaxy Instance name', Client.id),'') AS 'clientProps/@simpanaInstance'
			FROM app_client Client, APP_ClientProp ClientProp , APP_Platform appPlatform
			WHERE  ((Client.id = @in_clientId) AND
					(ClientProp.componentNameId = @in_clientId) AND
					(appPlatform.clientId = @in_clientId) )
			FOR XML PATH('clientInfo'), Type
		),
		(SELECT
				(
					(SELECT ComponentId  AS 'componentInfo/@ComponentId',
							ComponentName  AS  'componentInfo/@ComponentName',
(CASE (installed & 2) WHEN 0 THEN 0 ELSE 1 END) AS 'componentInfo/@installedState',
							(select '60') AS 'componentInfo/@_type_'
					FROM @tempTblComponents FOR XML PATH(''), Type)
				)
				FOR XML PATH('components'), Type)
		FOR XML PATH('clientComposition'), Type
)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @outputConfig  = '<clientComposition><clientError ErrorCode="-10" ErrorString="Exception caught"/></clientComposition>'
END CATCH
select @outputConfig
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetClientConfig')
	delete from GxQscripts where name = 'simGetClientConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetClientConfig')
	delete from GXDBVersions where aliasname = 'simGetClientConfig'
GO

insert into GXDBVersions values(2, 'simGetClientConfig',  '00010011006000040000', 'simGetClientConfig', '00010011006000040000')
GO

