

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetAvaliableDM2WebServers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetAvaliableDM2WebServers.sp,v $ $Id: simGetAvaliableDM2WebServers.sp,v 1.9.74.6 2020/06/18 18:03:19 xsui Exp $";
--
--  +========================================================================+
--  |      Cursor:  simGetAvaliableDM2WebServers.sp()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simGetAvaliableDM2WebServers')
BEGIN
	print '>>> Drop Stored Procedure: simGetAvaliableDM2WebServers <<<'
	drop procedure simGetAvaliableDM2WebServers
END
IF EXISTS (select * from GxQscripts where name='simGetAvaliableDM2WebServers')
	delete from GxQscripts where name = 'simGetAvaliableDM2WebServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetAvaliableDM2WebServers')
	delete from GXDBVersions where aliasname = 'simGetAvaliableDM2WebServers'
GO
print '... Creating Procedure: simGetAvaliableDM2WebServers'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetAvaliableDM2WebServers
  @i_bInstalled integer = 0
AS
  DECLARE @o_componentNameId integer
  DECLARE @o_portNumber integer
  DECLARE @o_apachePortNumber integer
  DECLARE @o_clientName char(1024)
  DECLARE @o_clientHostName char(1024)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @WebServerList TABLE (t_id int)
IF @i_bInstalled = 0
INSERT INTO @WebServerList SELECT componentNameId from App_ClientProp (NOLOCK) WHERE attrName = 'Desktop Search Server' AND attrVal = 1
ELSE
INSERT INTO @WebServerList SELECT clientId from simInstalledPackages (NOLOCK) WHERE SimPackageId IN (803, 852)
DELETE @WebServerList FROM App_ClientProp (NOLOCK) WHERE attrName = 'Linked CS Client' AND attrval = CAST(t_id as VARCHAR(32))
SELECT componentNameId,
ISNULL(MAX(CASE WHEN attrName='DM2WebService Web Site Port' THEN attrVal END),0) AS IISPort,
ISNULL(MAX(CASE WHEN attrName='DM2WebService Apache Port' THEN attrVal END),0 ) AS ApachePort,
name, net_hostname
FROM APP_ClientProp (NOLOCK) AS appClientProp
JOIN APP_Client (NOLOCK) AS appClient
ON appClient.id = appClientProp.componentNameId
WHERE appClientProp.componentNameId in (select t_id from @WebServerList)
GROUP BY componentNameId, name, net_hostname
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetAvaliableDM2WebServers')
	delete from GxQscripts where name = 'simGetAvaliableDM2WebServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetAvaliableDM2WebServers')
	delete from GXDBVersions where aliasname = 'simGetAvaliableDM2WebServers'
GO

insert into GXDBVersions values(2, 'simGetAvaliableDM2WebServers',  '00010009007400060000', 'simGetAvaliableDM2WebServers', '00010009007400060000')
GO

