

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetApplianceOSes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetApplianceOSes.sp,v $ $Id: simGetApplianceOSes.sp,v 1.1.2.13.6.1 2021/05/03 20:49:07 kgao Exp $";
--
--  +========================================================================+
--  | Stored Proc:  simGetApplianceOSes()
--  |
--  | Description: Return the appliance OS names for selected client in the Commcell
--	|              inClientId = 0 means for all clients
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='simGetApplianceOSes')
BEGIN
	print '>>> Drop Stored Procedure: simGetApplianceOSes <<<'
	drop procedure simGetApplianceOSes
END
IF EXISTS (select * from GxQscripts where name='simGetApplianceOSes')
	delete from GxQscripts where name = 'simGetApplianceOSes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetApplianceOSes')
	delete from GXDBVersions where aliasname = 'simGetApplianceOSes'
GO
print '... Creating Procedure: simGetApplianceOSes'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure simGetApplianceOSes
  @inClientId INTEGER
AS
--	The next lines are the columns, in order, that will be in the result set for this cursor.
--  EXTREME CAUTION must be exercised to ensure that these match up with the result set
--  in terms of type, size and order!
  DECLARE @o_OSNameVersion VARCHAR(255)
  DECLARE @o_MainOSType INTEGER
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @uaId integer = -1
DECLARE @uaMainOsType integer = -1
DECLARE @oTmpOut TABLE (oOSNameVer VARCHAR(255), oMainOSType INTEGER)
IF object_id('tempdb.dbo.#AU_ApplianceClientIds') IS NOT null DROP TABLE #AU_ApplianceClientIds
CREATE TABLE #AU_ApplianceClientIds
(
	cid INTEGER,
simOSInfo	VARCHAR(1024),
	mainOSType INTEGER,
	PRIMARY KEY (cid)
)
IF object_id('tempdb.dbo.#AU_RemoteCacheAssocClientIDs') IS NOT null DROP TABLE #AU_RemoteCacheAssocClientIDs
CREATE TABLE #AU_RemoteCacheAssocClientIDs
(
	cid INTEGER,
	rcMainOSType INTEGER,
	PRIMARY KEY (cid)
)
IF object_id('tempdb.dbo.#AU_SIMOSInfoTbl') IS NOT null DROP TABLE #AU_SIMOSInfoTbl
CREATE TABLE #AU_SIMOSInfoTbl
(
	cid INTEGER,
simOSInfo NVARCHAR(1024),
	PRIMARY KEY (cid)
)
IF object_id('tempdb.dbo.#AU_MMApplianceIds') IS NOT null DROP TABLE #AU_MMApplianceIds
CREATE TABLE #AU_MMApplianceIds
(
	cid INTEGER,
	PRIMARY KEY (cid)
)
SELECT @uaId=id from PatchUpdateAgentInfo where clientId=@inClientId and isEnabled = 1 and isDeleted = 0
SELECT @uaMainOsType = (CASE WHEN APPCP.attrVal IN ('1', '3') THEN 1 ELSE 0 END) from PatchUpdateAgentInfo with(nolock) join App_ClientProp APPCP with(nolock)
on PatchUpdateAgentInfo.clientid = APPCP.componentNameId where APPCP.attrName = 'Binary Set ID' and APPCP.modified = 0 and @inClientId = PatchUpdateAgentInfo.clientId
if @uaId > 1
begin
	insert into #AU_RemoteCacheAssocClientIDs
	select componentNameId, @uaMainOsType from App_Clientprop WITH(NOLOCK) where attrName = 'UPDATE CACHE AGENT ID' and attrVal = CAST (@uaId AS NVARCHAR(255)) and modified =0
		UNION
	SELECT ACGA.clientId as componentNameId, @uaMainOsType from APP_ComponentProp ACOMP WITH(NOLOCK) JOIN APP_ClientGroupAssoc ACGA WITH(NOLOCK) ON ACOMP.componentId =  ACGA.clientGroupId
	WHERE (ACOMP.componentType = 8 and ACOMP.propertyTypeId =1300 AND ACOMP.longVal =@uaId)
end
INSERT INTO #AU_SIMOSInfoTbl
SELECT ComponentNameID, attrVal FROM APP_ClientProp WITH(NOLOCK) WHERE attrName = 'SIM OS INFO' AND modified = 0
	AND (@inClientId = 0 OR @inClientId = ComponentNameID OR ComponentNameID IN (SELECT cid FROM #AU_RemoteCacheAssocClientIDs WHERE rcMainOSType = 1))
INSERT INTO #AU_MMApplianceIds
SELECT EntityId FROM MMEntityProp WITH(NOLOCK) WHERE EntityType = 10 AND PropertyName = 'MediaAgentApplianceType' AND intVal in (1, 2)
	AND (@inClientId = 0 OR @inClientId = EntityId OR EntityId IN (SELECT cid FROM #AU_RemoteCacheAssocClientIDs WHERE rcMainOSType = 0))
UNION
SELECT DISTINCT ComponentNameID FROM APP_ClientProp WITH(NOLOCK) WHERE attrName = 'FBR MediaAgent' AND attrVal = '1' AND modified = 0
	AND (@inClientId = 0 OR @inClientId = ComponentNameID OR ComponentNameID IN (SELECT cid FROM #AU_RemoteCacheAssocClientIDs WHERE rcMainOSType = 0))
INSERT INTO #AU_ApplianceClientIds
SELECT MIN(C.ID), T1.simOSInfo, -1
FROM App_Client C WITH(NOLOCK)
JOIN #AU_SIMOSInfoTbl T1 ON C.id = T1.cid
JOIN #AU_MMApplianceIds T2 ON C.id = T2.cid
WHERE C.specialClientFlags&1 <> 1
GROUP BY T1.simOSInfo
UPDATE #AU_ApplianceClientIds SET mainOSType = (CASE WHEN APPCP.attrVal IN ('1', '3') THEN 1 ELSE 0 END) FROM #AU_ApplianceClientIds, App_ClientProp APPCP WITH(NOLOCK)
	WHERE #AU_ApplianceClientIds.cid = APPCP.componentNameId AND APPCP.attrName = 'Binary Set ID' AND APPCP.modified = 0
INSERT INTO @oTmpOut
SELECT DISTINCT CASE
	WHEN CHARINDEX('Red Hat Enterprise Linux', V.osName) = 1 THEN 'rhel-' + SUBSTRING(simOSInfo, P3.Pos + 2, LEN(simOSInfo) - P3.Pos - 1)
	WHEN CHARINDEX('CentOS Linux', V.osName) = 1 THEN 'frel-' + SUBSTRING(simOSInfo, P3.Pos + 2, LEN(simOSInfo) - P3.Pos - 1)
	ELSE '' END, mainOSType
FROM #AU_ApplianceClientIds A
CROSS APPLY(SELECT (CHARINDEX(':-', simOSInfo))) AS P1(Pos)
CROSS APPLY(SELECT (CHARINDEX(':-', simOSInfo, P1.Pos+1))) AS P2(Pos)
CROSS APPLY(SELECT (CHARINDEX(':-', simOSInfo, P2.Pos+1))) AS P3(Pos)
JOIN ClientOSNameView V on A.cid = V.clientId
-- Windows & SQL appliance starts here
IF EXISTS (SELECT 1 FROM GxGlobalParam WHERE name='Patch Enable SW Appliance Update' and value='1')
BEGIN
	-- insert Windows appliance
	INSERT INTO @oTmpOut
	SELECT DISTINCT version, type
	FROM simInstalledThirdPartyCU S WITH(NOLOCK) LEFT JOIN #AU_RemoteCacheAssocClientIDs R WITH(NOLOCK) ON S.clientId = R.cid
	WHERE (@inClientId = 0 OR R.cid IS NOT NULL) AND S.enabled = 1
	UNION
	SELECT DISTINCT version, type
	FROM simInstalledThirdPartyCU S WITH(NOLOCK)
	WHERE @inClientId = S.clientId AND S.enabled = 1
END
SELECT oOSNameVer, oMainOSType FROM @oTmpOut
DROP TABLE #AU_ApplianceClientIds
DROP TABLE #AU_RemoteCacheAssocClientIDs
DROP TABLE #AU_MMApplianceIds
DROP TABLE #AU_SIMOSInfoTbl
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetApplianceOSes')
	delete from GxQscripts where name = 'simGetApplianceOSes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetApplianceOSes')
	delete from GXDBVersions where aliasname = 'simGetApplianceOSes'
GO

insert into GXDBVersions values(2, 'simGetApplianceOSes',  'v1.1.2.13.6.1', 'simGetApplianceOSes', 'v1.1.2.13.6.1')
GO

