

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetAllVMsMappedToAPM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetAllVMsMappedToAPM.sp,v $ $Id: simGetAllVMsMappedToAPM.sp,v 1.6.208.3 2018/03/22 01:48:55 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: simGetAllVMsMappedToAPM
--  |
--  | Description:	This stored procedure returns all the Virtual clients that
--	|				are pointing to ONLY the Physical client that is passed
--	|				in as argument to this procedure.
--  |
--  |
--  |   Revisions  Author           Description
--  |   ---------  -------          ---------------------------------------------
--  |   1.0        M J Venkatesh    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetAllVMsMappedToAPM <<<'

IF EXISTS (select * from sysobjects where name='simGetAllVMsMappedToAPM')
	drop procedure simGetAllVMsMappedToAPM
IF EXISTS (select * from GxQscripts where name='simGetAllVMsMappedToAPM')
	delete from GxQscripts where name = 'simGetAllVMsMappedToAPM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetAllVMsMappedToAPM')
	delete from GXDBVersions where aliasname = 'simGetAllVMsMappedToAPM'
GO
print '... Creating Procedure: simGetAllVMsMappedToAPM'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetAllVMsMappedToAPM
  @in_PMClientId INTEGER,
  @in_AppType INTEGER,
  @in_LicType INTEGER
AS
-- Output variables of the stored procedure
  DECLARE @out_Id INTEGER
  DECLARE @out_VMClientId INTEGER
  DECLARE @out_VMName NVARCHAR(255)
  DECLARE @out_PMClientId INTEGER
  DECLARE @out_PMName NVARCHAR(255)
  DECLARE @out_AppType INTEGER
  DECLARE @out_LicType INTEGER
	SELECT 1, VMClientId,
		VMName = ( SELECT Name from APP_Client where id = VMClientId ),
		PMClientId,
		PMName = ( SELECT Name from APP_Client where id = PMClientId ), @in_AppType, @in_LicType
		FROM APP_VMToPMMap X
		WHERE VMClientId IN (
			SELECT DISTINCT MAP.VMClientId FROM APP_VMToPMMap AS MAP WHERE MAP.PMClientId = @in_PMClientId
            AND NOT EXISTS (SELECT 1 FROM APP_VMToPMMap WHERE PMClientId <> @in_PMClientId AND MAP.VMClientId = VMClientId))
GO


IF EXISTS (select * from GxQscripts where name = 'simGetAllVMsMappedToAPM')
	delete from GxQscripts where name = 'simGetAllVMsMappedToAPM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetAllVMsMappedToAPM')
	delete from GXDBVersions where aliasname = 'simGetAllVMsMappedToAPM'
GO

insert into GXDBVersions values(2, 'simGetAllVMsMappedToAPM',  '00010006020800030000', 'simGetAllVMsMappedToAPM', '00010006020800030000')
GO

