

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetAllPMsMappedToOnlyAVM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetAllPMsMappedToOnlyAVM.sp,v $ $Id: simGetAllPMsMappedToOnlyAVM.sp,v 1.11.290.3 2018/03/22 01:38:56 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: simGetAllPMsMappedToOnlyAVM
--  |
--  | Description:	This stored procedure returns all the Physical clients that
--	|				are mapped to ONLY the virtual client that is passed
--	|				in as argument to this procedure.
--  |				Additional info
--	|				----------------
--	|				 This procedure will check the following:
--	|				 For a given virtual client gets all the associated physical clients
--	|				 Checks if the above selected physical clients have any other association other
--	|				 than the passed in virtual client
--	|				 If there are no association other than the passed in vm, then will check if there are
--	|				 any licensed installs on this physical client
--	|				 If not, will return that physical client, which can be safely deleted
--  |
--  |   Revisions  Author           Description
--  |   ---------  -------          ---------------------------------------------
--  |   1.0        M J Venkatesh    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetAllPMsMappedToOnlyAVM <<<'

IF EXISTS (select * from sysobjects where name='simGetAllPMsMappedToOnlyAVM')
	drop procedure simGetAllPMsMappedToOnlyAVM
IF EXISTS (select * from GxQscripts where name='simGetAllPMsMappedToOnlyAVM')
	delete from GxQscripts where name = 'simGetAllPMsMappedToOnlyAVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetAllPMsMappedToOnlyAVM')
	delete from GXDBVersions where aliasname = 'simGetAllPMsMappedToOnlyAVM'
GO
print '... Creating Procedure: simGetAllPMsMappedToOnlyAVM'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetAllPMsMappedToOnlyAVM
  @in_VMClientId INTEGER,
  @in_AppTypeId INTEGER
AS
-- Output variables of the stored procedure
  DECLARE @out_PMClientId INTEGER
		IF object_id('tempdb.dbo.#TMP') IS NOT null DROP TABLE #TMP
		CREATE TABLE #TMP
		( PMClientId	int )
		INSERT INTO #TMP
			SELECT DISTINCT MAP.PMclientId FROM APP_VMToPMMap AS MAP WHERE MAP.VMClientId = @in_VMClientId
			AND NOT EXISTS ( SELECT * FROM APP_VMToPMMap WHERE MAP.VMClientId <> VMClientId AND MAP.PMClientId =  PMClientid )
		IF @in_AppTypeId = 1001
		BEGIN
			DELETE FROM #TMP
				WHERE EXISTS
					(
					   SELECT id FROM LicUsage idn
						   WHERE idn.CId = #TMP.PMClientId AND InstallFlag = 0 AND OpType = 'Install'
						   AND idn.AppType in (1001, 1004, 1006, 1007, 1061, 1008, 1009, 1010, 1011, 1012, 1013, 1016, 1017, 1029, 1031, 1040, 1033, 1066, 1064, 1065, 1070)
				   )
		END
		IF @in_AppTypeId = 1045
		BEGIN
			DELETE FROM #TMP
				WHERE EXISTS
					(
					   SELECT id FROM LicUsage idn
						   WHERE idn.CId = #TMP.PMClientId AND InstallFlag = 0 AND OpType = 'Install'
						   AND idn.AppType in (1004, 1006, 1007, 1061, 1008, 1009, 1010, 1011, 1012, 1013, 1016, 1017, 1029, 1031, 1040, 1033, 1066, 1064, 1065, 1070)
				   )
		END
		IF @in_AppTypeId = 1001 OR @in_AppTypeId = 1045
		BEGIN
			DELETE FROM #TMP
				WHERE EXISTS
					(
					   SELECT id FROM LicUsage idn
						   WHERE idn.CId = #TMP.PMClientId AND idn.AppType < 1000 AND InstallFlag = 0 AND OpType = 'Install'
						   AND licType NOT IN (10, 26, 71, 127, 33554432, 16777216, 50331648, 67108864)
				   )
		END
		ELSE
		BEGIN
			DELETE FROM #TMP
				WHERE EXISTS
					( SELECT id FROM LicUsage idn
						WHERE idn.CId = #TMP.PMClientId AND idn.AppType = @in_AppTypeId AND InstallFlag = 0 AND OpType = 'Install' AND licType NOT IN (10, 26, 71, 127,33554432,16777216, 50331648, 67108864) )
		END
		SELECT * FROM #TMP
		DROP TABLE #TMP
GO

IF EXISTS (select * from GxQscripts where name = 'simGetAllPMsMappedToOnlyAVM')
	delete from GxQscripts where name = 'simGetAllPMsMappedToOnlyAVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetAllPMsMappedToOnlyAVM')
	delete from GXDBVersions where aliasname = 'simGetAllPMsMappedToOnlyAVM'
GO

insert into GXDBVersions values(2, 'simGetAllPMsMappedToOnlyAVM',  '00010011029000030000', 'simGetAllPMsMappedToOnlyAVM', '00010011029000030000')
GO

