

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetAllMissingPatches.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetAllMissingPatches.sp,v $ $Id: simGetAllMissingPatches.sp,v 1.1.2.5 2020/05/01 18:18:29 kgao Exp $";
--
--  +========================================================================+
--  |   Cursor:  simGetAllMissingPatches
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |   1.0       Kim    Gets all client Ids and missing patches list
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simGetAllMissingPatches')
BEGIN
	print '>>> Drop Stored Procedure: simGetAllMissingPatches <<<'
	drop procedure simGetAllMissingPatches
END
IF EXISTS (select * from GxQscripts where name='simGetAllMissingPatches')
	delete from GxQscripts where name = 'simGetAllMissingPatches'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetAllMissingPatches')
	delete from GXDBVersions where aliasname = 'simGetAllMissingPatches'
GO
print '... Creating Procedure: simGetAllMissingPatches'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetAllMissingPatches
AS
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @oUpdateOSId INTEGER
  DECLARE @oUpdatesList VARCHAR(MAX)
-- These lines represent the actual SQL code that will get executed.
-- :PARAM input lines
SET NOCOUNT ON
DECLARE @missingUpdates TABLE (UpdateOSId INT, updateNum VARCHAR(256))
INSERT INTO @missingUpdates
SELECT DISTINCT P.NewUpdateOSId, T.updatesNum
	FROM (SELECT clientId, Baseline, P._ID as UpdatesNum
		FROM simInstalledPackages S WITH(NOLOCK) CROSS APPLY dbo.SplitIDString(BaselineDeltaUpdate) P
			JOIN App_Client C WITH(NOLOCK) ON C.id = S.clientId
WHERE (Baseline & 2) > 0 AND C.releaseId = 16) T
		JOIN APP_ClientProp A WITH(NOLOCK) ON T.ClientId = A.componentNameId, PatchUpdateOS P
WHERE A.attrName = 'Binary Set ID' AND CAST(P.BinarySetID AS VARCHAR(128)) = A.attrVal
SELECT Main.UpdateOSId,
       ISNULL(LEFT(Main.updateNum,Len(Main.updateNum)-1), '') AS updateNum
FROM
    (
        SELECT DISTINCT ST2.UpdateOSId,
            (
                SELECT ST1.updateNum + ',' AS [text()]
                FROM @missingUpdates ST1
                WHERE ST1.UpdateOSId = ST2.UpdateOSId
                ORDER BY ST1.UpdateOSId
                FOR XML PATH ('')
            ) [updateNum]
        FROM @missingUpdates ST2
    ) [Main]
ORDER BY Main.UpdateOSId ASC
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetAllMissingPatches')
	delete from GxQscripts where name = 'simGetAllMissingPatches'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetAllMissingPatches')
	delete from GXDBVersions where aliasname = 'simGetAllMissingPatches'
GO

insert into GXDBVersions values(2, 'simGetAllMissingPatches',  '00010001000200050000', 'simGetAllMissingPatches', '00010001000200050000')
GO

