

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetAllCUs.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SimGetAllCUs.sp,v $ $Id: SimGetAllCUs.sp,v 1.1.2.2 2018/09/02 03:16:38 rnethi Exp $";
--  +========================================================================+
--  | Stored Proc:  simGetAllCUs()
--  |
--  | Description: Return all Cumulative UpdatePack info belongs to given ServicePack
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simGetAllCUs')
BEGIN
	print '>>> Drop Stored Procedure: simGetAllCUs <<<'
	drop procedure simGetAllCUs
END
IF EXISTS (select * from GxQscripts where name='simGetAllCUs')
	delete from GxQscripts where name = 'simGetAllCUs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetAllCUs')
	delete from GXDBVersions where aliasname = 'simGetAllCUs'
GO
print '... Creating Procedure: simGetAllCUs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure simGetAllCUs
  @inSPVer XML
AS
  DECLARE @oCUsForSP XML
SET NOCOUNT ON
DECLARE @inReleaseId INT
DECLARE @inBuild INT
DECLARE @inSPMajor INT
DECLARE @inSPMinor INT
DECLARE @inTransactionId INT
DECLARE @tmpTbl TABLE(osid INT, CUNum INT, TransactionId INT, FriendlyName VARCHAR(64))
SELECT @inReleaseId = x.ref.value('(@ReleaseId)[1]', 'INT'),
	   @inBuild = x.ref.value('(@Build)[1]', 'INT'),
	   @inSPMajor = x.ref.value('(@Major)[1]', 'INT'),
	   @inSPMinor = x.ref.value('(@Minor)[1]', 'INT'),
	   @inTransactionId = x.ref.value('(@TransactionId)[1]', 'INT')
	FROM @inSPVer.nodes('/UpdatePatches_SPVersion') AS x(ref)
INSERT INTO @tmpTbl
SELECT pmc.osid, COALESCE(UPNumber, 0), COALESCE(MaxTransactionId, 0), COALESCE(U.FriendlyName,'')
FROM PatchMultiCache pmc WITH(NOLOCK)
	JOIN PatchSPVersion S1 WITH(NOLOCK) ON pmc.spVersionId = S1.id
	LEFT JOIN PatchCacheUpdatePackMap pcup WITH(NOLOCK) ON pmc.id = pcup.CacheID
	LEFT JOIN PatchUPVersion U WITH(NOLOCK) ON pcup.UpdatePackID = U.UPVersionID
WHERE @inReleaseId = S1.Release AND @inBuild = S1.Build AND @inSPMajor = S1.SPMajor AND @inSPMinor = S1.SPMinor AND @inTransactionId = S1.TransactionId
-- For now we only return higher or equal entries at SP level
IF EXISTS (SELECT 1 FROM @tmpTbl)
BEGIN
SELECT
	(
		(
			SELECT
				DISTINCT
					osid as 'OSInfo/@updateOSId',
					CUNum AS 'UpdatePack/@Number',
					TransactionId AS 'UpdatePack/@TransactionId',
					FriendlyName AS 'UpdatePack/@FriendlyName',
					@inReleaseId - 5 AS 'SPVersion/@Version',
					@inReleaseId AS 'SPVersion/@ReleaseId',
					@inBuild AS 'SPVersion/@Build',
					@inSPMajor	AS 'SPVersion/@Major',
					@inSPMinor	AS 'SPVersion/@Minor',
					@inTransactionId	AS 'SPVersion/@TransactionId'
			FROM @tmpTbl
		FOR XML PATH ('CacheSetup'), TYPE
		)
	)
	FOR XML PATH ('UpdatePatches_CacheUpdateInfo')
END
ELSE
SELECT NULL FOR XML PATH ('UpdatePatches_CacheUpdateInfo')
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simGetAllCUs')
	delete from GxQscripts where name = 'simGetAllCUs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetAllCUs')
	delete from GXDBVersions where aliasname = 'simGetAllCUs'
GO

insert into GXDBVersions values(2, 'simGetAllCUs',  '00010001000200020000', 'simGetAllCUs', '00010001000200020000')
GO

