

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetAgentsList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetAgentsList.sp,v $ $Id: simGetAgentsList.sp,v 1.6.88.1 2018/03/27 09:00:00 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetAgentsList <<<'

IF EXISTS (select * from sysobjects where name='simGetAgentsList')
	drop procedure simGetAgentsList
IF EXISTS (select * from GxQscripts where name='simGetAgentsList')
	delete from GxQscripts where name = 'simGetAgentsList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetAgentsList')
	delete from GXDBVersions where aliasname = 'simGetAgentsList'
GO
print '... Creating Procedure: simGetAgentsList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure simGetAgentsList
  @xmlText XML
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
      declare           @tempTblClients       TABLE (ClientId int)
      declare           @tempTblClientsWithPackagesInstalled       TABLE (ClientId int, ComponentId int, ComponentName varchar(1024))
      declare           @tempTblComponents TABLE (ComponentId int, ComponentName varchar(1024), installed int, releaseid int, nstatus int, OSType varchar(1024))
      declare           @clientId               INT
      --Get all non-zero clients from the input XML.
      INSERT INTO @tempTblClients
      SELECT ref.value('@clientId', 'int')
      FROM @xmlText.nodes('App_GetAgentsListReq/clients') R (ref) where ref.value('@clientId', 'int') <> 0
      --select * from @tempTblClients
      --Now for each client get the packages installed
      declare @currentclientid int
      declare tempclientlist cursor for
      select ClientId from @tempTblClients
      open tempclientlist
      fetch next from tempclientlist into @currentclientid
      while @@FETCH_STATUS = 0
      begin
		delete from @tempTblComponents
		insert into @tempTblComponents (ComponentId , ComponentName , installed , releaseid , nstatus, OSType)
			exec  simGetInstalledPackages @currentclientid, 1
		--select * from @tempTblComponents
		insert into @tempTblClientsWithPackagesInstalled select @currentclientid, ComponentId, ComponentName from @tempTblComponents
		--Filter FS Core, driver packages
		delete from @tempTblClientsWithPackagesInstalled where ComponentId in (1, 2, 1002, 1003, 257, 259, 452, 453, 503, 551, 552, 554, 701, 1113, 1118, 1401, 1105)
		fetch next from tempclientlist into @currentclientid
      end
	  close  tempclientlist
	  deallocate  tempclientlist
	  --select * from @tempTblClientsWithPackagesInstalled
      --SELECT @xmlText
      declare @outxml XML
      set @outxml = (
						select (select	ComponentId  '@ComponentId',
										ComponentName  '@ComponentName'
								FROM @tempTblClientsWithPackagesInstalled
								GROUP BY ComponentId, ComponentName
								HAVING COUNT(*) in (select COUNT(*) from @tempTblClients)
								FOR XML PATH('commonAgents'), TYPE ),
								(select distinct ComponentId  '@ComponentId',
												 ComponentName  '@ComponentName'
								 FROM @tempTblClientsWithPackagesInstalled
								 FOR XML PATH('allAgents') , TYPE)
								 FOR XML PATH(''), ROOT('App_GetAgentsListRes')
					)
		select @outxml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'simGetAgentsList')
	delete from GxQscripts where name = 'simGetAgentsList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetAgentsList')
	delete from GXDBVersions where aliasname = 'simGetAgentsList'
GO

insert into GXDBVersions values(2, 'simGetAgentsList',  '00010006008800010000', 'simGetAgentsList', '00010006008800010000')
GO

