

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simGetAgentStatuses.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simGetAgentStatuses.sp,v $ $Id: simGetAgentStatuses.sp,v 1.1.2.5 2018/03/27 08:51:40 jiechen Exp $";
--  +========================================================================+
--  |	Cursor:  simGetAgentStatuses
--  |
--  |   Revisions  Author          Description
--  |   ---------  -------------   ---------------------------------------------
--  |	1.1        Philip Miller   Get the list of packages installed on CS from app manager and licensing tables.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simGetAgentStatuses <<<'

IF EXISTS (select * from sysobjects where name='simGetAgentStatuses')
	drop procedure simGetAgentStatuses
IF EXISTS (select * from GxQscripts where name='simGetAgentStatuses')
	delete from GxQscripts where name = 'simGetAgentStatuses'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetAgentStatuses')
	delete from GXDBVersions where aliasname = 'simGetAgentStatuses'
GO
print '... Creating Procedure: simGetAgentStatuses'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simGetAgentStatuses
  @i_clientId integer
AS
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_clientId integer
  DECLARE @o_packageId integer
  DECLARE @o_appType integer
  DECLARE @o_agentStatus integer
-- These lines represent the actual SQL code that will get executed.
SET NOCOUNT ON
SELECT DISTINCT clientId, packageId, appType, MAX(agentStatus) as agentStatus
FROM
	(
	SELECT clientId, dbo.GetPackageID(ida.appTypeId, ac.simOperatingSystemId) as packageId, appTypeId as appType, (CASE ida.status when 2 then 0 else 1 end) as agentStatus
		FROM APP_IDAName ida
		JOIN app_client ac WITH (NOLOCK) on ida.clientid = ac.id
		WHERE ida.clientid = @i_clientId AND ida.status in (0,2)
	UNION
	SELECT @i_ClientId, t_packageid, t_apptype, (CASE ida.status when 2 then 0 else 1 end) as agentStatus
		FROM simGetClientPropAppTypesForClient(@i_ClientId) app
		JOIN simApptypeProp atp ON app.t_apptype = atp.componentNameId
		JOIN APP_IDAName ida ON atp.componentNameId = ida.appTypeId AND ida.clientid = @i_ClientId
		WHERE ida.status in (0,2) AND atp.attrName = 'AddOnPackageId' AND t_packageid = attrVal
	UNION
	SELECT clientid,
		CASE WHEN ac.releaseId < 16 AND dbo.GetPackageID(1002, ac.simOperatingSystemId) = 54 THEN 51
			ELSE dbo.GetPackageID(1002, ac.simOperatingSystemId)
		END, 1002,  (CASE l.OpType WHEN 'Install' THEN 1 ELSE 0 END) as agentStatus
		FROM MMHost mm WITH (NOLOCK)
		JOIN licusage l on mm.clientid = l.cid
		JOIN app_client ac WITH (NOLOCK) on mm.clientid = ac.id
		where l.apptype = 1002 AND mm.clientid = @i_clientId
	UNION
	SELECT @i_ClientId, app.t_packageid, app.t_apptype, (CASE l.OpType WHEN 'Install' THEN 1 ELSE 0 END) as agentStatus
		FROM simGetClientPropAppTypesForClient(@i_ClientId) app
		JOIN simApptypeProp atp ON app.t_apptype = atp.componentnameid
		JOIN MMHost mm WITH (NOLOCK) ON mm.ClientId = @i_ClientId
		JOIN licusage l on mm.clientid = l.cid
		WHERE app.t_apptype = 1002 AND atp.attrName = 'AddOnPackageId' AND app.t_packageid = atp.attrVal
	) as AgentStatuses
GROUP BY clientId, packageId, appType
GO
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simGetAgentStatuses')
	delete from GxQscripts where name = 'simGetAgentStatuses'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simGetAgentStatuses')
	delete from GXDBVersions where aliasname = 'simGetAgentStatuses'
GO

insert into GXDBVersions values(2, 'simGetAgentStatuses',  '00010001000200050000', 'simGetAgentStatuses', '00010001000200050000')
GO

