

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simFixCSClientInImportedDB.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simFixCSClientInImportedDB.sp,v $ $Id: simFixCSClientInImportedDB.sp,v 1.1.2.2 2020/12/03 13:17:06 xsui Exp $";
--  +===================================================+
--  | Stored Proc:  simFixCSClientInImportedDB		|
--  +===================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='simFixCSClientInImportedDB')
BEGIN
	print '>>> Drop Stored Procedure: simFixCSClientInImportedDB <<<'
	drop procedure simFixCSClientInImportedDB
END
IF EXISTS (select * from GxQscripts where name='simFixCSClientInImportedDB')
	delete from GxQscripts where name = 'simFixCSClientInImportedDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simFixCSClientInImportedDB')
	delete from GXDBVersions where aliasname = 'simFixCSClientInImportedDB'
GO
print '... Creating Procedure: simFixCSClientInImportedDB'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure simFixCSClientInImportedDB
  @i_bWin INT
AS
  DECLARE @o_bOSChanged INT
  DECLARE @o_errorCode INT
  DECLARE @o_errorStr VARCHAR(MAX)
DECLARE @CSClientId	INT = 2
DECLARE @bCSWindows	INT = ISNULL((select 1 from APP_Client C JOIN SimOperatingSystem O ON C.id = @CSClientId AND C.simOperatingSystemID = O.id AND O.type = 'Windows'), 0)
DECLARE @appTypeId	INT = 0
DECLARE @nLicType	INT = 0
SET @o_bOSChanged = 0
SET @o_errorCode = 0
SET @o_errorStr	= ''
--1) Is updating DB required
IF @i_bWin = @bCSWindows
BEGIN
	DECLARE @sOS VARCHAR(64) = CASE @i_bWin WHEN 0 THEN 'LINUX' ELSE 'WINDOWS' END
	SET @o_errorStr	= 'No CS update is required for [' + @sOS + '] CS'
	GOTO SP_EXIT
END
BEGIN TRANSACTION
BEGIN TRY
SET @o_bOSChanged = 1
--2) delete all packages
DELETE SimInstalledPackages WHERE ClientID = @CSClientId
--3) deconfigure all agents
DECLARE DeconfigureAgentCur CURSOR LOCAL FORWARD_ONLY FOR SELECT appTypeId FROM APP_iDAName WHERE clientID = @CSClientId
OPEN DeconfigureAgentCur FETCH DeconfigureAgentCur INTO @appTypeId
WHILE @@FETCH_STATUS = 0
BEGIN
	EXEC AppConfDeconf @CSClientId, @appTypeId, 0, 2, @o_errorCode OUTPUT, @o_errorStr OUTPUT
        IF @@ERROR <> 0 OR @o_errorCode <> 0 GOTO SP_EXIT
	SET @nLicType = ISNULL((select licType from LicUsage where cid = @CSClientId AND appType = @appTypeId AND optype = 'Install'), 0)
	IF @nLicType > 0
	BEGIN
		EXEC LicenseIncrement @CSClientId, @nLicType, @appTypeId, 0, 0, 0, @o_errorStr OUTPUT
		IF @@ERROR <> 0
		BEGIN
SET @o_errorCode = -18
			GOTO SP_EXIT
		END
	END
        FETCH NEXT FROM DeconfigureAgentCur INTO @appTypeId
END
CLOSE DeconfigureAgentCur
DEALLOCATE DeconfigureAgentCur
--4) disable MA
UPDATE MMHost SET mmHostEnabled = 0 WHERE clientID = @CSClientID
--5) fix CS DB instanceName on clients with DB packages installed
DECLARE @curUnixTime		INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @InstanceName		VARCHAR(32) = (CASE @i_bWin WHEN 0 THEN '' ELSE 'Commvault' END)
DECLARE @ClientsWithDBPkg	TABLE (t_id INT, t_csHostName VARCHAR(1024))
-- prepare client info
INSERT INTO @ClientsWithDBPkg
SELECT DISTINCT clientID, (SELECT csHostName FROM APP_Client WHERE id = clientID)
FROM simInstalledPackages WHERE simPackageID > 800 AND simPackageID < 900 AND clientID > @CSClientId
-- add work queue
INSERT INTO APP_WorkQueueRequest (clientId, workToken, createTime, lastUpdateTime, retryCount, flag, remoteClient, workTokenParams)
SELECT DISTINCT t_id, 64/*WORK_TOKEN_UPDATE_CSDB_INSTANCE_NAME*/, @curUnixTime, 0, 0, 0, -1,
	(SELECT t_csHostName AS '@csHostName', @InstanceName AS '@csDbInstanceName' FOR XML PATH('App_ProcessCsDbInstanceNameChangeWorkQueueParam'))
FROM @ClientsWithDBPkg
-----------------------------------
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errorCode = ERROR_NUMBER()
    SET @o_errorStr = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message [' +ERROR_MESSAGE() + '].'
END CATCH
SP_EXIT:
IF @o_bOSChanged > 0
BEGIN
	IF @o_errorCode = 0
		COMMIT TRANSACTION
	ELSE
        ROLLBACK TRANSACTION
END
SELECT @o_bOSChanged, @o_errorCode, @o_errorStr
GO

IF EXISTS (select * from GxQscripts where name = 'simFixCSClientInImportedDB')
	delete from GxQscripts where name = 'simFixCSClientInImportedDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simFixCSClientInImportedDB')
	delete from GXDBVersions where aliasname = 'simFixCSClientInImportedDB'
GO

insert into GXDBVersions values(2, 'simFixCSClientInImportedDB',  '00010001000200020000', 'simFixCSClientInImportedDB', '00010001000200020000')
GO

