

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simDisAssocSCP.sp] ---------- 

-- Modified for (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simDisAssocSCP.sp,v $ $Id: simDisAssocSCP.sp,v 1.5.278.1 2018/03/22 01:49:54 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: simDisAssocSCP
--  |
--  | Description:	During OS or application upgrades, run this stored procedure
--  |				to disassociate the subclient policies
--  |   Revisions  Author           Description
--  |   ---------  -------          ---------------------------------------------
--  |   1.0        M J Venkatesh    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simDisAssocSCP <<<'

IF EXISTS (select * from sysobjects where name='simDisAssocSCP')
	drop procedure simDisAssocSCP
IF EXISTS (select * from GxQscripts where name='simDisAssocSCP')
	delete from GxQscripts where name = 'simDisAssocSCP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simDisAssocSCP')
	delete from GXDBVersions where aliasname = 'simDisAssocSCP'
GO
print '... Creating Procedure: simDisAssocSCP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure simDisAssocSCP
  @in_ClientId INTEGER,
  @in_AppType INTEGER
AS
-- Output variables of the stored procedure
  DECLARE @out_Error INTEGER
	SET NOCOUNT ON
	set @out_Error = 0
	DECLARE		@id				INTEGER
	DECLARE		@clientid		INTEGER
	DECLARE		@apptypeid		INTEGER
	DECLARE		@backupsetid	INTEGER
	declare		@timeStamp		integer
	declare @appId				integer
	declare @appClientId		integer
	declare @appAppTypeId		integer
	declare @appinstanceId		integer
	declare @appbackupsetId		integer
	declare @appappNumberId		integer
	declare @appdArchId			integer
	declare @applArchId			integer
	declare @apprefTime			integer
	declare @appmodifiedTime	integer
	declare @appscStatus		integer
	declare @newSCId			integer
	declare @SCPId				integer
	declare @appscName			nvarchar(128)
	declare @rc					integer
	declare @createdTime integer
	set @timeStamp = ( select dbo.getunixtime( getutcdate() ) )
	DECLARE	DisAssociateSCP CURSOR FOR
		SELECT distinct backupset FROM application
			WHERE clientid = @in_ClientId and apptypeid = @in_AppType
	OPEN DisAssociateSCP
	FETCH DisAssociateSCP INTO @backupsetid
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		IF EXISTS ( SELECT id FROM backupsetProp
			WHERE componentnameId = @backupsetid AND attrName = N'Associated subclient Policy' AND
				CONVERT( int, attrval ) > 0 )
		BEGIN
			----Create the subclient underneath the backupset
			DECLARE	GetSubclientsCursor CURSOR FOR
			SELECT * FROM application where backupset = @backupsetid
			OPEN GetSubclientsCursor
			FETCH GetSubclientsCursor INTO @appId, @appClientId, @appAppTypeId ,@appinstanceId, @appbackupsetId, @appappNumberId, @appdArchId,
										@applArchId, @apprefTime,   @appmodifiedTime, @appscName, @appscStatus
			WHILE	@@FETCH_STATUS = 0
			BEGIN
				set @SCPId = 0
				set @createdTime  = 0
				Select @SCPId = attrVal ,  @createdTime = created from APP_subclientProp where componentnameId = @appId and attrName = N'Associated subclient Policy' and modified = 0
				if (@SCPId > 0)
				BEGIN
					DECLARE @insertSCfile TABLE (type INTEGER, filename NVarChar(1024), created INTEGER, modified integer)
					----Insert the subclient content into the associated subclient
 					Insert into @insertSCfile SELECT distinct  type, filename, created, modified
						from APP_scfilterfile where componentnameId = @SCPId and (modified = 0 OR created > @createdTime)
					update @insertSCfile set created = @createdTime where modified = 0 and created < @createdTime
					----Insert the subclient content into the associated subclient
 					Insert into APP_scfilterfile (componentNameId, type, fileName, created, modified)
 							SELECT distinct @appId, type, filename, created, modified from @insertSCfile
					DECLARE @insertSCProp TABLE (attrName NVarChar(256), attrTYpe integer,  attrVal nvarchar(1024), created INTEGER, modified integer)
 					----Insert the subclient properties into the associated subclient
 					Insert into @insertSCProp SELECT distinct  attrName, attrType, attrVal, created, modified
						from APP_subclientProp where componentnameId = @SCPId  and (modified = 0 OR created > @createdTime)
					update @insertSCProp set created = @createdTime where modified = 0 and created < @createdTime
 					Insert into APP_subclientProp SELECT distinct @appId, attrName, attrType, attrVal, created, modified, 0 from @insertSCProp
					Update APP_subclientProp set modified = @timeStamp where componentnameId = @appId and attrName = N'Associated subclient Policy' and modified = 0
				END
				FETCH GetSubclientsCursor INTO @appId, @appClientId, @appAppTypeId ,@appinstanceId, @appbackupsetId, @appappNumberId, @appdArchId,
										@applArchId, @apprefTime,   @appmodifiedTime, @appscName, @appscStatus
			END
			CLOSE GetSubclientsCursor
			DEALLOCATE GetSubclientsCursor
			----Remove the association in backupset prop
			UPDATE APP_backupsetProp SET modified = @timeStamp WHERE componentnameId = @backupsetid AND attrName = N'Associated subclient Policy' and modified = 0
		END
		FETCH DisAssociateSCP INTO @backupsetid
	END
	CLOSE DisAssociateSCP
	DEALLOCATE DisAssociateSCP
	SET NOCOUNT OFF
	SELECT @out_Error
GO

IF EXISTS (select * from GxQscripts where name = 'simDisAssocSCP')
	delete from GxQscripts where name = 'simDisAssocSCP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simDisAssocSCP')
	delete from GXDBVersions where aliasname = 'simDisAssocSCP'
GO

insert into GXDBVersions values(2, 'simDisAssocSCP',  '00010005027800010000', 'simDisAssocSCP', '00010005027800010000')
GO

