

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simDeconfigureIndexServers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018 CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simDeconfigureIndexServers.sp,v $ $Id: simDeconfigureIndexServers.sp,v 1.1.2.1 2018/03/27 15:34:10 philipmiller Exp $";
--
--  +========================================================================+
--  |   Cursor:  simDeconfigureIndexServers
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |   1.0       Phil	  Deconfigure all index servers for a given client
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simDeconfigureIndexServers <<<'

IF EXISTS (select * from sysobjects where name='simDeconfigureIndexServers')
	drop procedure simDeconfigureIndexServers
IF EXISTS (select * from GxQscripts where name='simDeconfigureIndexServers')
	delete from GxQscripts where name = 'simDeconfigureIndexServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simDeconfigureIndexServers')
	delete from GXDBVersions where aliasname = 'simDeconfigureIndexServers'
GO
print '... Creating Procedure: simDeconfigureIndexServers'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simDeconfigureIndexServers
-- INPUT PARAMETERS
  @i_clientId integer
AS
-- OUTPUT PARAMETERS
  DECLARE @o_cloudId integer
  DECLARE @o_cloudName nvarchar(256)
  DECLARE @o_cloudDisplayName nvarchar(256)
  DECLARE @o_errorCode integer = 0
  DECLARE @o_errorStr varchar(512) = 'Success'
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
-- These lines represent the actual SQL code that will get executed.
SET NOCOUNT ON
IF object_id('tempdb.dbo.#tIndexServersTable') IS NOT NULL DROP TABLE #tIndexServersTable
CREATE TABLE #tIndexServersTable (id INT, name VARCHAR(256))
INSERT INTO #tIndexServersTable
SELECT DISTINCT C.cloudId, CL2.name
FROM DM2Cloud C (NOLOCK)
JOIN DM2SearchServerCoreInfo S (NOLOCK) ON S.CloudId = C.cloudId
JOIN APP_Client CL (NOLOCK) ON S.ClientId = CL.id
JOIN APP_Client CL2 (NOLOCK) ON C.pseudoClientId = CL2.id  --do not include deleted index server clients
WHERE C.cloudId in (SELECT R.cloudId FROM DM2CloudCoreRole R (NOLOCK) INNER JOIN DM2CloudRoleMaster M (NOLOCK) ON M.roleId = R.roleId WHERE M.roleTypeName = 'Data Analytics')
AND S.CloudType IN (1, 5)
AND S.ClientId = @i_clientId
AND C.status = 1
DECLARE @inputXML XML
DECLARE @cloudID INT
DECLARE @cloudName VARCHAR(256)
DECLARE simIndexServersCursor CURSOR FOR SELECT id, name FROM #tIndexServersTable
OPEN simIndexServersCursor
FETCH NEXT FROM simIndexServersCursor INTO @cloudID, @cloudName
WHILE @@FETCH_STATUS = 0
BEGIN
	SELECT @inputXML = (SELECT 	1 as configureNodes,
								2 as opType,
								1 as type,
								(SELECT 169 as [_type_], @cloudID as cloudId, @cloudName as cloudName, @cloudName as cloudDisplayName FOR XML RAW ('cloudInfoEntity'), TYPE)
						FOR XML RAW('App_CloudInfo'))
	EXEC AppAnalyticsCloudOperation 1, @inputXML
	FETCH NEXT FROM simIndexServersCursor INTO @cloudID, @cloudName
END
SP_EXIT:
CLOSE simIndexServersCursor
DEALLOCATE simIndexServersCursor
DROP TABLE #tIndexServersTable
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simDeconfigureIndexServers')
	delete from GxQscripts where name = 'simDeconfigureIndexServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simDeconfigureIndexServers')
	delete from GXDBVersions where aliasname = 'simDeconfigureIndexServers'
GO

insert into GXDBVersions values(2, 'simDeconfigureIndexServers',  '00010001000200010000', 'simDeconfigureIndexServers', '00010001000200010000')
GO

