

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simDeconfigForPackageUninstall.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simDeconfigForPackageUninstall.sp,v $ $Id: simDeconfigForPackageUninstall.sp,v 1.1.2.3 2020/11/19 06:57:18 bsingha Exp $";
--
--  +========================================================================+
--  | Stored Proc:  simDeconfigForPackageUninstall
--  |
--  | Description: Misc DB update during package uninstall
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='simDeconfigForPackageUninstall')
BEGIN
	print '>>> Drop Stored Procedure: simDeconfigForPackageUninstall <<<'
	drop procedure simDeconfigForPackageUninstall
END
IF EXISTS (select * from GxQscripts where name='simDeconfigForPackageUninstall')
	delete from GxQscripts where name = 'simDeconfigForPackageUninstall'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simDeconfigForPackageUninstall')
	delete from GXDBVersions where aliasname = 'simDeconfigForPackageUninstall'
GO
print '... Creating Procedure: simDeconfigForPackageUninstall'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure simDeconfigForPackageUninstall
  @i_clientId integer,
  @i_packageId integer
AS
--	The next lines are the columns, in order, that will be in the result set for this cursor.
--  EXTREME CAUTION must be exercised to ensure that these match up with the result set
--  in terms of type, size and order!
  DECLARE @o_error integer
SET NOCOUNT ON
IF @i_packageId = 808
BEGIN
	DELETE WF_Deploy WHERE clientId = @i_clientId
END
ELSE IF @i_packageId = 24
BEGIN
	DECLARE @linkedCSClient VARCHAR(32) = ISNULL((select attrval FROM APP_clientProp NOLOCK WHERE componentNameID = @i_clientId  AND attrName = 'Linked CS client' AND modified=0), '')
	DELETE APP_clientProp WHERE attrName IN ('Linked CS client', 'Active CS Client') and attrval = @linkedCSClient AND modified=0
DELETE APP_clientProp WHERE componentNameID = @i_clientId AND attrName = 'Failover Remote cache sync' AND modified=0
	-- Update additional setting on CS Live Sync smart client group
	DECLARE @CSLiveSyncClientsGroupId INTEGER = 0
	SELECT @CSLiveSyncClientsGroupId = id
	FROM APP_ClientGroup
	WHERE name='Clients For Commserv LiveSync'
	IF @CSLiveSyncClientsGroupId<>0
	BEGIN
		DECLARE @interfaceList NVARCHAR(MAX) = ''
		SET @interfaceList = STUFF ((SELECT ',' + AC.net_hostname
								FROM APP_Client AC
								INNER JOIN APP_ClientProp ACP
								ON AC.id=ACP.componentNameId
								WHERE ACP.attrName = 'Linked CS Client' AND ACP.modified=0 AND AC.status=0
								FOR XML PATH('')), 1, 1, '')
		IF @interfaceList<>''
		BEGIN
			DECLARE @errorCodeTbl TABLE (errorCode INT)
			INSERT INTO @errorCodeTbl
			EXEC AppSetAdditionalSettingsForEntity @CSLiveSyncClientsGroupId, 28, 'sCSINTERFACELIST', 'CommServe', 'STRING', @interfaceList, 0, 'Comma separated list of all CS LiveSync node hostnames'
		END
	END
END
SELECT @@ERROR
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simDeconfigForPackageUninstall')
	delete from GxQscripts where name = 'simDeconfigForPackageUninstall'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simDeconfigForPackageUninstall')
	delete from GXDBVersions where aliasname = 'simDeconfigForPackageUninstall'
GO

insert into GXDBVersions values(2, 'simDeconfigForPackageUninstall',  '00010001000200030000', 'simDeconfigForPackageUninstall', '00010001000200030000')
GO

