

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simCreateDummyFailoverCSClient.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simCreateDummyFailoverCSClient.sp,v $ $Id: simCreateDummyFailoverCSClient.sp,v 1.1.4.7 2020/11/10 09:29:06 bsingha Exp $";
--  +===================================================+
--  | Stored Proc:  simCreateDummyFailoverCSClient	|
--  +===================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='simCreateDummyFailoverCSClient')
BEGIN
	print '>>> Drop Stored Procedure: simCreateDummyFailoverCSClient <<<'
	drop procedure simCreateDummyFailoverCSClient
END
IF EXISTS (select * from GxQscripts where name='simCreateDummyFailoverCSClient')
	delete from GxQscripts where name = 'simCreateDummyFailoverCSClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simCreateDummyFailoverCSClient')
	delete from GXDBVersions where aliasname = 'simCreateDummyFailoverCSClient'
GO
print '... Creating Procedure: simCreateDummyFailoverCSClient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure simCreateDummyFailoverCSClient
  @i_xmlClientConfig XML,
  @i_CSHostName VARCHAR(MAX)
AS
  DECLARE @o_clientID integer
  DECLARE @o_errorCode integer
  DECLARE @o_errorStr VARCHAR(MAX)
DECLARE @CSID			INT = 2
DECLARE	@failoverFocus		VARCHAR(MAX) = ''
DECLARE	@failoverclient		VARCHAR(MAX) = ''
DECLARE	@failoverclientID	INT = 0
DECLARE	@failoverActive		INT = 0
DECLARE	@clientName		VARCHAR(MAX) = ''
DECLARE	@hostName		VARCHAR(MAX) = ''
DECLARE	@password		VARCHAR(MAX) = ''
DECLARE	@cvdPort		INT = 0
DECLARE	@binarySetID		VARCHAR(MAX) = ''
DECLARE	@installDir		VARCHAR(MAX) = ''
DECLARE	@jobResultDir		VARCHAR(MAX) = ''
DECLARE	@verRelease		VARCHAR(MAX) = ''
DECLARE	@verBuild		VARCHAR(MAX) = ''
DECLARE	@OSName			VARCHAR(MAX) = ''
DECLARE	@OSBuild		VARCHAR(MAX) = ''
DECLARE	@OSProcessorType	VARCHAR(MAX) = ''
DECLARE	@OSType			VARCHAR(MAX) = ''
DECLARE	@OSSubType		VARCHAR(MAX) = ''
DECLARE	@OSPlatformType		VARCHAR(MAX) = ''
DECLARE	@OSVersion		VARCHAR(MAX) = ''
DECLARE	@spVersion		VARCHAR(MAX) = ''
DECLARE	@spFriendlyName		VARCHAR(MAX) = ''
DECLARE	@upNumber		INT = 0
DECLARE	@transactionID		INT = 0
DECLARE	@upTransactionID	INT = 0
DECLARE	@revisionID		INT = 0
DECLARE	@clientRelease		INT = 0
DECLARE	@osID			INT = 0
DECLARE	@opDate			DATETIME = GETUTCDATE()
DECLARE	@opTime			INT = dbo.GetUnixTime(@opDate)
DECLARE @clientGUID     	VARCHAR(64) = UPPER(newid())
DECLARE	@clPropTbl		TABLE (t_clientId INT, t_attrName VARCHAR(MAX), t_attrType INT, t_attrVal VARCHAR(MAX), t_copyDB INT)
DECLARE	@pkgTbl			TABLE (t_pkgId INT, t_patches VARCHAR(MAX))
DECLARE @tmpResultTbl 		TABLE(t_ID INT)
SET NOCOUNT ON
-------------------------------------
-- INITIALIZE
SET @o_clientID = 0
SET @o_errorCode = 0
SET @o_errorStr = ''
-------------------------------------
-- VALIDATE INPUT
SELECT	@failoverFocus = ISNULL(XProp.value('@Focus', 'VARCHAR(MAX)'), ''),
	@failoverclient = ISNULL(XProp.value('@AssociatedClient', 'VARCHAR(MAX)'), ''),
	@failoverActive = ISNULL(XProp.value('@IsActive', 'INT'), 0)
FROM @i_xmlClientConfig.nodes('CVInstallManager_ClientsComposition/failoverCS') AS XTbl(XProp)
IF @failoverFocus = '' OR @failoverclient = ''
BEGIN
	SET @o_errorCode = -1
	SET @o_errorStr = 'No failover info is available'
	GOTO SP_EXIT
END
SELECT @failoverclientID = id FROM App_Client NOLOCK WHERE name = @failoverclient
IF @failoverclientID = 0
BEGIN
	SET @o_errorCode = 1
	SET @o_errorStr = 'Linked failover client [' + @failoverclient + '] is not found'
	GOTO SP_EXIT
END
-------------------------------------
-- GET XML DATA
SELECT	@clientName = ISNULL(XProp.value('client[1]/clientEntity[1]/@clientName', 'VARCHAR(MAX)'), ''),
	@hostName = ISNULL(XProp.value('client[1]/clientEntity[1]/@hostName', 'VARCHAR(MAX)'), ''),
	@password = ISNULL(XProp.value('client[1]/@clientPassword', 'VARCHAR(MAX)'), ''),
	@cvdPort = ISNULL(XProp.value('client[1]/@cvdPort', 'INT'), 0),
	@installDir = ISNULL(XProp.value('client[1]/@installDirectory', 'VARCHAR(MAX)'), ''),
	@jobResultDir = ISNULL(XProp.value('client[1]/jobResulsDir[1]/@path', 'VARCHAR(MAX)'), ''),
	@verRelease = ISNULL(XProp.value('client[1]/versionInfo[1]/GalaxyRelease[1]/@ReleaseString', 'VARCHAR(MAX)'), ''),
	@verBuild = ISNULL(XProp.value('client[1]/versionInfo[1]/@GalaxyBuildNumber', 'VARCHAR(MAX)'), ''),
	@OSType = ISNULL(XProp.value('client[1]/osInfo[1]/@Type', 'VARCHAR(MAX)'), ''),
	@OSSubType = ISNULL(XProp.value('client[1]/osInfo[1]/@SubType', 'VARCHAR(MAX)'), ''),
	@OSPlatformType = ISNULL(XProp.value('client[1]/osInfo[1]/@PlatformType', 'VARCHAR(MAX)'), ''),
	@OSVersion = ISNULL(XProp.value('client[1]/osInfo[1]/@Version', 'VARCHAR(MAX)'), ''),
	@OSName = ISNULL(XProp.value('client[1]/osInfo[1]/OsDisplayInfo[1]/@OSName', 'VARCHAR(MAX)'), ''),
	@OSBuild = ISNULL(XProp.value('client[1]/osInfo[1]/OsDisplayInfo[1]/@OSBuild', 'VARCHAR(MAX)'), ''),
	@OSProcessorType = ISNULL(XProp.value('client[1]/osInfo[1]/OsDisplayInfo[1]/@ProcessorType', 'VARCHAR(MAX)'), ''),
	@binarySetID = ISNULL(XProp.value('clientProps[1]/@BinarySetID', 'VARCHAR(MAX)'), '')
FROM @i_xmlClientConfig.nodes('CVInstallManager_ClientsComposition/clientInfo') AS XTbl(XProp)
IF CHARINDEX('.', @verRelease) > 0 SET @verRelease = SUBSTRING(@verRelease, 0, CHARINDEX('.', @verRelease))
-------------------------------------
-- GET XML DATA: PACKAGE/PATCH INFO
INSERT INTO @pkgTbl
SELECT	XProp.value('@ComponentId', 'INT'), ''
FROM @i_xmlClientConfig.nodes('CVInstallManager_ClientsComposition/components/componentInfo') AS XTbl(XProp)
UNION
SELECT	XProp.value('@pkgId', 'INT'), ''
FROM @i_xmlClientConfig.nodes('CVInstallManager_ClientsComposition/patchInformation/packagePatches') AS XTbl(XProp)
DELETE @pkgTbl WHERE t_pkgId = 0 OR t_pkgId > 800 AND t_pkgId < 850
UPDATE @pkgTbl
SET t_patches = (	SELECT t_patches + ','  + patch
			FROM	(	SELECT pkgId = XProp.value('../@pkgId', 'INT'), patch = XProp.value('@val', 'VARCHAR(MAX)')
					FROM @i_xmlClientConfig.nodes('CVInstallManager_ClientsComposition/patchInformation/packagePatches/additionalPatches') AS XTbl(XProp)) T
			WHERE pkgId = t_pkgId FOR XML PATH(''))
UPDATE @pkgTbl
 SET t_patches = SUBSTRING(t_patches, 2, LEN(t_patches))
 WHERE CHARINDEX(',', t_patches) = 1 AND LEN(t_patches) > 1
-------------------------------------
-- VALIDATE INPUT: CLIENT INFO
IF @clientName = ''
BEGIN
	SET @o_errorCode = -1
	SET @o_errorStr = 'Client name is missing'
	GOTO SP_EXIT
END
-------------------------------------
-- GET OS ID
INSERT INTO @tmpResultTbl EXEC SimGetOperatingSystemID @OSType, @OSSubType, @OSVersion, @OSPlatformType, 1
SELECT TOP 1 @osID = t_ID FROM @tmpResultTbl
-------------------------------------
-- GET RELEASE ID
SELECT @clientRelease = id FROM simAllGalaxyRel NOLOCK WHERE release = @verRelease
-------------------------------------
-- GET DB DATA
SELECT	@osID = CASE @osID WHEN 0 THEN simOperatingSystemId ELSE @osID END,
	@hostName = CASE @hostName WHEN '' THEN net_hostname ELSE @hostName END,
	@password = CASE @password WHEN '' THEN client_password ELSE @password END,
	@jobResultDir = CASE @jobResultDir WHEN '' THEN jobResultDir ELSE @jobResultDir END,
	@cvdPort = CASE @cvdPort WHEN 0 THEN cvdPort ELSE @cvdPort END,
	@clientRelease = CASE @clientRelease WHEN 0 THEN releaseId ELSE @clientRelease END,
	@clientGUID = CASE @clientGUID WHEN '' THEN GUID ELSE @clientGUID END
FROM	App_Client NOLOCK
WHERE	id = @CSID
UPDATE @clPropTbl SET t_attrVal = attrVal FROM App_ClientProp NOLOCK WHERE componentNameID = @CSID AND attrName = t_attrName and t_attrVal = '' AND t_copyDB = 1 AND modified = 0
IF @installDir = '' SELECT @installDir = install_dir FROM APP_Platform NOLOCK WHERE clientID = @CSID AND platformType = 4
-------------------------------------
-- ADD CLIENT
SELECT @o_clientID = id FROM App_Client NOLOCK WHERE name = @clientName AND clientDescription = 'Failover CS client'
IF @o_clientID > 0
BEGIN
	UPDATE App_Client
	SET simOperatingSystemId=@osID, net_hostname=@hostName, client_password=@password, csHostName = @i_CSHostName, jobResultDir = @jobResultDir, cvdPort = @cvdPort, releaseId = @clientRelease, GUID = @clientGUID
	WHERE id = @o_clientID AND (simOperatingSystemId<>@osID OR net_hostname<>@hostName OR client_password<>@password OR csHostName <> @i_CSHostName OR jobResultDir <> @jobResultDir OR cvdPort <> @cvdPort OR releaseId <> @clientRelease OR GUID <> @clientGUID )
	-- Making sure there is some detail to be updated to avoid firing CCS Trigger on a NODATA operation
END
ELSE
BEGIN
	INSERT INTO App_Client(name, simOperatingSystemId, net_hostname, client_password, refTime, modified, offlineEntity, offlineTimeStamp, csHostName, clientDescription, jobResultDir,
			clientSkewTime, cvdPort, evmgrcPort, status, releaseId, spaceCheckFlags, ccpId, ccpTime, origCCId, GUID, specialClientFlags, displayName)
	VALUES(@clientName, @osID, @hostName, @password, @opTime, 0, 0, 0, @i_CSHostName, 'Failover CS client', @jobResultDir, 0, @cvdPort, 0, 0, @clientRelease, 0, 0, 0, @CSID, @clientGUID, 0, @clientName)
	SET @o_clientID = SCOPE_IDENTITY()
END
IF @o_clientID = 0
BEGIN
	SET @o_errorCode = 1
	SET @o_errorStr = 'Failed to add client [' + @clientName + ']'
	GOTO SP_EXIT
END
INSERT INTO @clPropTbl VALUES(@o_clientID, 'Failover CS Instance', 1, @failoverFocus, 0)
INSERT INTO @clPropTbl VALUES(@o_clientID, 'Binary Set ID', 7, @binarySetID, 1)
INSERT INTO @clPropTbl VALUES(@o_clientID, 'Galaxy Build', 1, @verBuild, 1)
INSERT INTO @clPropTbl VALUES(@o_clientID, 'Sim OS Info', 1, CASE WHEN @OSName <> '' THEN @OSName + ':' + @OSVersion + ':' + @OSBuild + ':' + @OSProcessorType ELSE '' END, 1)
INSERT INTO @clPropTbl VALUES(@o_clientID, 'Client Version', 1, CASE WHEN @verRelease <> '' AND @verBuild <> '' THEN @verRelease + '(' + @verBuild + ')' ELSE '' END, 1)
INSERT INTO @clPropTbl VALUES(@o_clientID, 'Encryption Settings', 7, '0', 0)
INSERT INTO @clPropTbl VALUES(@failoverclientID, 'Linked CS Client', 7, CAST(@o_clientID AS VARCHAR(32)), 0)
-------------------------------------
-- ADD CLIENT PROPERTIES
UPDATE APP_clientProp SET attrVal = t_attrVal FROM @clPropTbl WHERE componentNameID = t_clientId AND attrName = t_attrName AND modified = 0 AND (attrVal<>t_attrVal)
INSERT INTO APP_clientProp SELECT t_clientId, t_attrName, 1, t_attrVal, @opTime, 0, 0 FROM @clPropTbl WHERE NOT EXISTS (select id from APP_clientProp P where P.componentNameID = t_clientId AND P.attrName = t_attrName)
IF EXISTS (SELECT 1 FROM APP_Platform WHERE clientID = @o_clientID AND platformType = 4)
	UPDATE APP_Platform SET install_dir = @installDir WHERE clientID = @o_clientID AND platformType = 4 AND install_dir <> @installDir
ELSE
	INSERT INTO APP_Platform VALUES (@o_clientID, 4, @installDir, 0)
IF @failoverActive > 0
BEGIN
	IF EXISTS (SELECT iD FROM APP_clientProp NOLOCK WHERE componentNameId = @CSID AND attrName = 'Active CS Client' AND modified=0)
		UPDATE APP_clientProp SET attrVal = @o_clientID WHERE componentNameId = @CSID AND attrName = 'Active CS Client'  AND modified=0 AND attrVal <> @o_clientID
	ELSE
		INSERT INTO APP_clientProp VALUES (@CSID, 'Active CS Client', 7, @o_clientID, @opTime, 0, 0)
END
-------------------------------------
-- ADD PACKAGES
IF EXISTS (SELECT t_pkgId FROM @pkgTbl)
BEGIN
	SELECT	@spVersion = ISNULL(XProp.value('@spVersion', 'VARCHAR(MAX)'), ''),
		@spFriendlyName = ISNULL(XProp.value('@friendlyName', 'VARCHAR(MAX)'), ''),
		@upNumber = ISNULL(XProp.value('@cumulativeUpdatePackNumber', 'INT'), 0),
		@transactionID = ISNULL(XProp.value('@transactionID', 'INT'), 0),
		@upTransactionID = ISNULL(XProp.value('@cuTransactionID', 'INT'), 0),
		@revisionID = ISNULL(XProp.value('@revisionID', 'INT'), 0)
	FROM @i_xmlClientConfig.nodes('CVInstallManager_ClientsComposition/patchInformation') AS XTbl(XProp)
	IF CHARINDEX('.', @spVersion) > 0 SET @spVersion = SUBSTRING(@spVersion, 0, CHARINDEX('.', @spVersion))
	DECLARE @ssipCreateIfNotExists integer = 1
	DECLARE @ssipClientId integer = @o_clientID
	DECLARE @ssipPackageID integer = 0
	DECLARE @ssipOpType char(25) = 'Install'
	DECLARE @ssipOpTime datetime = @opDate
	DECLARE @ssipUserID integer = 0
	DECLARE @ssipHighestSP integer = CAST(@spVersion AS INT)
	DECLARE @ssipAdditionalPatches nvarchar(MAX) = ''
	DECLARE @ssipMissingPatches nvarchar(MAX) = ''
	DECLARE @ssipNode nvarchar(255) = ''
	DECLARE @ssipIsActive integer = 1
	DECLARE @ssipSpMinorVersion integer = 0
	DECLARE @ssipBaseline integer = -2
	DECLARE @ssipBaselineDeltaSP nvarchar(MAX) = ''
	DECLARE @ssipBaselineDeltaUpdate nvarchar(MAX) = ''
	DECLARE @ssipTransactionID integer = @transactionID
	DECLARE @ssipRevisionID integer = @revisionID
	DECLARE @ssipFriendlyName varchar(256) = @spFriendlyName
	DECLARE @ssipUpdatePackNum integer = @upNumber
	DECLARE @ssipUPTransactionID integer = @upTransactionID
	DECLARE GetPackageList CURSOR FOR SELECT t_pkgId, ISNULL(t_patches, '') FROM @pkgTbl
	OPEN GetPackageList
	FETCH NEXT FROM GetPackageList INTO @ssipPackageID, @ssipAdditionalPatches
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @o_errorCode = 0
		SET @o_errorStr = ''
--- CODE BELOW HERE IS FROM simSetInstalledPackage.spb  ----------
-- in order to use, variables to be declared are...
-- INPUT : @ssipCreateIfNotExists integer, @ssipClientId integer, @ssipPackageID integer, @ssipOpTime datetime, @ssipOpType char(25), @ssipUserID integer, @ssipHighestSP integer,ssipAdditionalPatches ntext, @ssipMissingPatches ntext, @ssipNodenvarchar(255), @ssipIsActive integer, @ssipSpMinorVersion integer, @ssipBaseline integer, @ssipBaselineDeltaSP ntext, @ssipBaselineDeltaUpdate ntext, @ssipTransactionID integer = 0, @ssipRevisionID integer = 0, @ssipUPTransactionID integer = 0
DECLARE @releaseId integer
SELECT @releaseId = releaseId FROM APP_Client WITH (NOLOCK) WHERE id = @ssipClientId
DECLARE @isCSSPUpgrade INTEGER = 0
DECLARE @oldCSRelease INTEGER = 0
DECLARE @oldCSSPMajor INTEGER = 0
DECLARE @oldCSSPMinor INTEGER = 0
DECLARE @oldCSSPTransId INTEGER = 0
-- Check PatchSPVersion table for entry
DECLARE @spVersionInfo TABLE ( id int )
DECLARE @buildNum INT = dbo.GetBuildNum(@releaseId)
INSERT @spVersionInfo
EXEC simGetSPVersionID @releaseId, @buildNum, @ssipHighestSP, @ssipSpMinorVersion, @ssipTransactionId, @ssipRevisionId, @ssipFriendlyName, @ssipUpdatePackNum, @ssipUPTransactionID
DECLARE @patchSPVersionId integer
SELECT @patchSPVersionId = id FROM @spVersionInfo
IF EXISTS (SELECT 1 FROM simInstalledPackages WITH (NOLOCK) WHERE ClientId = @ssipClientId AND simPackageID = @ssipPackageId)
BEGIN
IF @ssipClientId = 2 AND @ssipPackageID = 20
	BEGIN
		DECLARE @spComparison INTEGER
		DECLARE @oldCSUpdatePackNum INTEGER
		SELECT @oldCSRelease = P.Release, @oldCSSPMajor = P.SPMajor, @oldCSSPMinor = P.SPMinor, @oldCSSPTransId = P.TransactionId, @oldCSUpdatePackNum = S.UPNumber
		FROM simInstalledPackages S WITH(NOLOCK) JOIN PatchSPVersion P WITH(NOLOCK) ON S.SPVersionID = P.Id WHERE S.ClientId = @ssipClientId AND S.simPackageID = @ssipPackageID
		SET @spComparison = dbo.CompareServicePackLevel(@ssipHighestSP, @ssipSpMinorVersion, @ssipTransactionID, @oldCSSPMajor, @oldCSSPMinor, @oldCSSPTransId)
IF @oldCSRelease > 0 AND ((16 > @oldCSRelease) OR (@spComparison > 0) OR (@spComparison = 0 AND @ssipUpdatePackNum > @oldCSUpdatePackNum))  -- ServicePack upgrade
		BEGIN
			SET @isCSSPUpgrade = 1
		END
	END
	UPDATE simInstalledPackages
	SET OpTime = CASE WHEN @ssipOpTime <> 0 THEN @ssipOpTime ELSE OpTime END,
		OpType = CASE WHEN @ssipOpType <> '' THEN @ssipOpType ELSE OpType END,
		UserID = @ssipUserID,
		HighestSP = @ssipHighestSP,
		AdditionalPatches = @ssipAdditionalPatches,
		MissingPatches = @ssipMissingPatches,
		Node = @ssipNode,
		IsActive = @ssipIsActive,
		SpMinorVersion = @ssipSpMinorVersion,
		Baseline = @ssipBaseline,
		BaselineDeltaSP = @ssipBaselineDeltaSP,
		BaselineDeltaUpdate = @ssipBaselineDeltaUpdate,
		SPVersionID = @patchSPVersionId,
		UPNumber = @ssipUpdatePackNum
	WHERE ClientId = @ssipClientId AND simPackageID = @ssipPackageId
	-- Invalidate all RCs which did not have latest media
	IF @isCSSPUpgrade = 1
	BEGIN
		UPDATE PatchUpdateAgentInfo
		SET inSyncWithCS = 0, packageStatus = 0
		WHERE isDeleted = 0 AND clientId <> 2
			AND NOT EXISTS (SELECT * FROM PatchMultiCache M WITH(NOLOCK) JOIN PatchSPVersion P WITH(NOLOCK) ON M.SPVersionID = P.Id
WHERE P.Release = 16 AND M.ClientId = PatchUpdateAgentInfo.ClientId AND P.SPMajor = @ssipHighestSP AND P.SPMinor = @ssipSpMinorVersion AND P.TransactionId = @ssipTransactionID)
	END
END
ELSE IF (@ssipCreateIfNotExists & 1) > 0
BEGIN
	INSERT INTO simInstalledPackages(ClientId,simPackageID,OpTime,OpType,UserID,HighestSP,AdditionalPatches,MissingPatches,Node,IsActive,SpMinorVersion,Baseline,BaselineDeltaSP,BaselineDeltaUpdate,SPVersionID)
	VALUES(@ssipClientId, @ssipPackageID, @ssipOpTime, @ssipOpType, @ssipUserID, @ssipHighestSP, @ssipAdditionalPatches, @ssipMissingPatches, @ssipNode, @ssipIsActive, @ssipSpMinorVersion, @ssipBaseline, @ssipBaselineDeltaSP, @ssipBaselineDeltaUpdate, @patchSPVersionId)
END
IF (@ssipCreateIfNotExists & 2) > 0
	EXEC SetInstalledUpdateSummary @ssipClientId, @ssipPackageID, 'UpdateSync', @ssipHighestSP, @ssipUpdatePackNum, @ssipAdditionalPatches, @ssipMissingPatches
		IF @o_errorCode <> 0
		BEGIN
			CLOSE GetPackageList
			DEALLOCATE GetPackageList
			GOTO SP_EXIT
		END
		FETCH NEXT FROM GetPackageList INTO @ssipPackageID, @ssipAdditionalPatches
	END
	CLOSE GetPackageList
	DEALLOCATE GetPackageList
END
ELSE
BEGIN
	INSERT INTO SimInstalledPackages
	SELECT @o_clientID, simPackageID, @opDate, 'Install', UserID, HighestSP, AdditionalPatches, MissingPatches, Node, IsActive, SpMinorVersion, Baseline, BaselineDeltaSP, BaselineDeltaUpdate, SPVersionID, UPNumber
	FROM SimInstalledPackages P
	WHERE P.clientID = @CSID AND (P.simPackageID < 800 OR P.simPackageID > 850) AND P.simPackageID NOT IN (SELECT P2.simPackageID FROM SimInstalledPackages P2 WHERE P2.clientID = @o_clientID)
	INSERT INTO @tmpResultTbl EXEC UpdateVersionStringProp @o_clientID
END
-- Update additional setting on CS Live Sync smart client group
	DECLARE @CSLiveSyncClientsGroupId INTEGER = 0
	SELECT @CSLiveSyncClientsGroupId = id
	FROM APP_ClientGroup
	WHERE name='Clients For Commserv LiveSync'
	IF @CSLiveSyncClientsGroupId<>0
	BEGIN
		DECLARE @interfaceList NVARCHAR(MAX) = ''
		SET @interfaceList = STUFF ((SELECT ',' + AC.net_hostname
								FROM APP_Client AC
								INNER JOIN APP_ClientProp ACP
								ON AC.id=ACP.componentNameId
								WHERE ACP.attrName = 'Linked CS Client' AND ACP.modified=0 AND AC.status=0
								FOR XML PATH('')), 1, 1, '')
		IF @interfaceList<>''
		BEGIN
			DECLARE @errorCodeTbl TABLE (errorCode INT)
			INSERT INTO @errorCodeTbl
			EXEC AppSetAdditionalSettingsForEntity @CSLiveSyncClientsGroupId, 28, 'sCSINTERFACELIST', 'CommServe', 'STRING', @interfaceList, 0, 'Comma separated list of all CS LiveSync node hostnames'
		END
	END
-- Configure automatic Remote cache
	DECLARE @SWCachePath VARCHAR(MAX) = ''
	DECLARE @tmpConfigResultTbl 		TABLE(t_ClientID INT, t_ErrorCode INT, t_ErrorStr VARCHAR(MAX))
	IF @failoverActive=1
	   SELECT @SWCachePath=value FROM GxGlobalParam WHERE name = 'Patch Directory'
	ELSE
	BEGIN
	  IF @OSType='Unix'
	      SET @SWCachePath=CONCAT(@installDir,'/SW')
	  ELSE
	      SET @SWCachePath=CONCAT(@installDir,'\SW')
	END
	INSERT INTO @tmpConfigResultTbl EXEC simConfigureAutomaticRemoteCacheOnFailoverClient @failoverclient, @failoverclientID, @SWCachePath, @failoverActive
	SELECT TOP 1 @o_errorCode = t_ErrorCode, @o_errorStr = t_ErrorStr FROM @tmpConfigResultTbl
----------------------------------------------------------------------------------
-- DONE
SP_EXIT:
	SELECT @o_clientID, @o_errorCode, @o_errorStr
GO

IF EXISTS (select * from GxQscripts where name = 'simCreateDummyFailoverCSClient')
	delete from GxQscripts where name = 'simCreateDummyFailoverCSClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simCreateDummyFailoverCSClient')
	delete from GXDBVersions where aliasname = 'simCreateDummyFailoverCSClient'
GO

insert into GXDBVersions values(2, 'simCreateDummyFailoverCSClient',  '00010001000400070000', 'simCreateDummyFailoverCSClient', '00010001000400070000')
GO

