

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simConfigureAutomaticRemoteCacheOnFailoverClient.sp] ---------- 

--  +===================================================================+
--  | Stored Proc: simConfigureAutomaticRemoteCacheOnFailoverClient.sp	|
--  +===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='simConfigureAutomaticRemoteCacheOnFailoverClient')
BEGIN
	print '>>> Drop Stored Procedure: simConfigureAutomaticRemoteCacheOnFailoverClient <<<'
	drop procedure simConfigureAutomaticRemoteCacheOnFailoverClient
END
IF EXISTS (select * from GxQscripts where name='simConfigureAutomaticRemoteCacheOnFailoverClient')
	delete from GxQscripts where name = 'simConfigureAutomaticRemoteCacheOnFailoverClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simConfigureAutomaticRemoteCacheOnFailoverClient')
	delete from GXDBVersions where aliasname = 'simConfigureAutomaticRemoteCacheOnFailoverClient'
GO
print '... Creating Procedure: simConfigureAutomaticRemoteCacheOnFailoverClient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure simConfigureAutomaticRemoteCacheOnFailoverClient
  @i_FailoverClient VARCHAR(MAX),
  @i_FailoverClientID INTEGER,
  @i_SWCachePath VARCHAR(MAX),
  @i_IsActiveNode INTEGER
AS
  DECLARE @o_clientID integer
  DECLARE @o_errorCode integer
  DECLARE @o_errorStr VARCHAR(MAX)
DECLARE @featureEnabledFlag INT = 0
DECLARE @tmpResultTbl 		TABLE(t_ID INT)
SET NOCOUNT ON
-------------------------------------
-- INITIALIZE
SET @o_clientID = @i_FailoverClientID
SET @o_errorCode = 0
SET @o_errorStr = ''
-------------------------------------
-- VALIDATE INPUT
IF @i_FailoverClient=''
BEGIN
	SET @o_errorCode = -1
	SET @o_errorStr = 'Input clientName [' + @i_FailoverClient +'] is incorrect.'
	GOTO SP_EXIT
END
IF @i_FailoverClientID=0
BEGIN
	SET @o_errorCode = -1
	SET @o_errorStr = 'Input clientID [' + @i_FailoverClientID +'] is incorrect.'
	GOTO SP_EXIT
END
IF NOT EXISTS(SELECT TOP 1 id FROM GXGlobalParam WHERE name = 'ConfigureFailoverClientAsRemoteCache' AND value = '1' and modified = 0)
GOTO SP_EXIT
EXEC QS_ConfigureRemoteCache @i_FailoverClient, @i_SWCachePath
IF NOT EXISTS (SELECT TOP 1 id FROM PatchUpdateAgentInfo WHERE clientId = @i_FailoverClientID)
BEGIN
   	SET @o_errorCode = 1
	SET @o_errorStr = 'Failed to configure Remote cache on client [' + @i_FailoverClient + ']'
	GOTO SP_EXIT
END
-- disable the Remote cache on active node
IF @i_IsActiveNode=1
	UPDATE PatchUpdateAgentInfo SET isEnabled=0 WHERE clientId=@i_FailoverClientID
IF EXISTS (SELECT id FROM APP_ClientProp WITH(NOLOCK) WHERE modified = 0 AND componentNameID = @i_FailoverClientID AND attrName = 'Failover Remote cache sync')
UPDATE APP_CLientProp SET attrVal = 1 WHERE modified = 0 AND componentNameID = @i_FailoverClientID AND attrName = 'Failover Remote cache sync'
ELSE
INSERT INTO APP_CLientProp SELECT @i_FailoverClientID, 'Failover Remote cache sync', 7, 1, dbo.GetUnixTime(GETUTCDATE()), 0, 0
-------------------------------------
-- DONE
SP_EXIT:
	SELECT @o_clientID, @o_errorCode, @o_errorStr
GO

IF EXISTS (select * from GxQscripts where name = 'simConfigureAutomaticRemoteCacheOnFailoverClient')
	delete from GxQscripts where name = 'simConfigureAutomaticRemoteCacheOnFailoverClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simConfigureAutomaticRemoteCacheOnFailoverClient')
	delete from GXDBVersions where aliasname = 'simConfigureAutomaticRemoteCacheOnFailoverClient'
GO

insert into GXDBVersions values(2, 'simConfigureAutomaticRemoteCacheOnFailoverClient',  '00000000000000000000', 'simConfigureAutomaticRemoteCacheOnFailoverClient', '00000000000000000000')
GO

