

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simCleanPackageInstallStateForClientDuringUpgrade.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simCleanPackageInstallStateForClientDuringUpgrade.sp,v $ $Id: simCleanPackageInstallStateForClientDuringUpgrade.sp,v 1.1.2.5 2018/03/27 08:42:34 jiechen Exp $";
--
--  +==========================================================================================================+
--  |	Procedure:  simCleanPackageInstallStateForClientDuringUpgrade
--  |
--  |   Revisions Author  Description
--  |   --------- -------------  ------------------------------------------------------------------------------
--  |	1.1       Philip Miller  Get the list of packages installed on CS FROM app manager and licensing tables.
--  +==========================================================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simCleanPackageInstallStateForClientDuringUpgrade <<<'

IF EXISTS (select * from sysobjects where name='simCleanPackageInstallStateForClientDuringUpgrade')
	drop procedure simCleanPackageInstallStateForClientDuringUpgrade
IF EXISTS (select * from GxQscripts where name='simCleanPackageInstallStateForClientDuringUpgrade')
	delete from GxQscripts where name = 'simCleanPackageInstallStateForClientDuringUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simCleanPackageInstallStateForClientDuringUpgrade')
	delete from GXDBVersions where aliasname = 'simCleanPackageInstallStateForClientDuringUpgrade'
GO
print '... Creating Procedure: simCleanPackageInstallStateForClientDuringUpgrade'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simCleanPackageInstallStateForClientDuringUpgrade
  @i_clientId integer
AS
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up WITH the result set in terms of type, size,
--  and order!
  DECLARE @o_packageId int
  DECLARE @o_updateType varchar(128)
-- These lines represent the actual SQL code that will get executed.
-- :PARAM input lines
SET NOCOUNT ON
DECLARE @clientPropTbl TABLE (t_clientId int, t_attrName nvarchar(1028), t_attrVal nvarchar(1028))
DECLARE @clientPropPackages TABLE (t_clientId int, t_packageId int, t_attrName nvarchar(1028), t_configuredState nvarchar(1028))
DECLARE @currentPackage int
DECLARE @deprecatedUninstalledPackages TABLE (
	t_packageId int,
	t_packageName varchar(128),
	t_bConfigured int,
	t_releaseId int,
	t_flag int,
	t_osType varchar(64))
DECLARE @updatedEntries TABLE(
	t_packageId int,
	t_updateType varchar(128))
DECLARE @filterSelection int
set @filterSelection = (1 | 4)
INSERT INTO @deprecatedUninstalledPackages
EXEC simGetInstalledPackages @i_clientId, @filterSelection
INSERT INTO @clientPropTbl
SELECT componentNameId, attrName, attrVal
FROM app_clientProp
WHERE componentNameId = @i_clientId
AND modified = 0
INSERT INTO @clientPropPackages
SELECT
	acp.t_clientId
	,cpname.simPackageId as t_packageId
	,acp.t_attrName as t_attrName
	,acp.t_attrVal as t_configuredState
FROM @clientPropTbl acp
JOIN SIMClientPropInstalledName cpname ON acp.t_attrName = cpname.attrName
JOIN app_client ac ON acp.t_clientId = ac.id
JOIN simoperatingsystem sos ON ac.simOperatingSystemId = sos.id
WHERE cpname.simpackageid >
		CASE sos.Type
			WHEN 'Windows' THEN 0
			WHEN 'UNIX' THEN 1000
			WHEN 'NetWare' THEN 2000
		END
AND cpname.simpackageId <
		CASE sos.Type
			WHEN 'Windows' THEN 1000
			WHEN 'UNIX' THEN 2000
			WHEN 'NetWare' THEN 3000
		END
DECLARE PackageCursor CURSOR FOR SELECT t_packageId FROM @deprecatedUninstalledPackages
OPEN PackageCursor;
FETCH NEXT FROM PackageCursor INTO @currentPackage
WHILE @@FETCH_STATUS = 0
BEGIN
	--Get entries for  'PackageStateForId ' + @currentPackage
	IF EXISTS(SELECT * FROM @clientPropPackages where t_packageId = @currentPackage)
	BEGIN
		DELETE FROM app_clientprop
		WHERE componentnameid = @i_clientId AND attrname IN (SELECT attrName from simGetClientPropInstalledNames(@currentPackage))
		INSERT INTO @updatedEntries VALUES (@currentPackage, 'Removed app_clientProp entry')
	END
	FETCH NEXT FROM PackageCursor into @currentPackage
END
CLOSE PackageCursor;
DEALLOCATE PackageCursor;
INSERT INTO @updatedEntries SELECT simPackageID, 'Deleted simInstalledPackages entry' FROM simInstalledPackages where clientid = @i_clientId
DELETE FROM simInstalledPackages where clientid = @i_clientId
SELECT t_packageId, t_updateType FROM @updatedEntries ORDER BY t_updateType, t_packageId
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simCleanPackageInstallStateForClientDuringUpgrade')
	delete from GxQscripts where name = 'simCleanPackageInstallStateForClientDuringUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simCleanPackageInstallStateForClientDuringUpgrade')
	delete from GXDBVersions where aliasname = 'simCleanPackageInstallStateForClientDuringUpgrade'
GO

insert into GXDBVersions values(2, 'simCleanPackageInstallStateForClientDuringUpgrade',  '00010001000200050000', 'simCleanPackageInstallStateForClientDuringUpgrade', '00010001000200050000')
GO

