

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simCheckForSCDataReaders.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simCheckForSCDataReaders.sp,v $ $Id: simCheckForSCDataReaders.sp,v 1.3.304.1 2018/03/22 01:45:43 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: simCheckForSCDataReaders
--  |
--  | Description:	During the MA reinstalls or upgrades, delete the proxy host
--	|				property in APP_Client prop table and also update the release id
--	|				for all NAS clients pointing to that MA to current release
--  |
--  |
--  |   Revisions  Author           Description
--  |   ---------  -------          ---------------------------------------------
--  |   1.0        M J Venkatesh    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simCheckForSCDataReaders <<<'

IF EXISTS (select * from sysobjects where name='simCheckForSCDataReaders')
	drop procedure simCheckForSCDataReaders
IF EXISTS (select * from GxQscripts where name='simCheckForSCDataReaders')
	delete from GxQscripts where name = 'simCheckForSCDataReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simCheckForSCDataReaders')
	delete from GXDBVersions where aliasname = 'simCheckForSCDataReaders'
GO
print '... Creating Procedure: simCheckForSCDataReaders'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simCheckForSCDataReaders
  @in_dummy INTEGER
AS
-- Output variables of the stored procedure
  DECLARE @out_clientId INTEGER
  DECLARE @out_clientHostName NVARCHAR(255)
  DECLARE @out_subClientId INTEGER
  DECLARE @out_subClientName NVARCHAR(128)
	SET NOCOUNT ON
	SELECT A.clientid, C.net_hostname, subclientId = A.id, A.subclientName FROM APP_Application A, APP_Client C WHERE A.id in (
			SELECT componentnameid FROM APP_SubClientProp WHERE attrName = 'sys:nStreams' )
				AND C.id = A.clientid
GO

IF EXISTS (select * from GxQscripts where name = 'simCheckForSCDataReaders')
	delete from GxQscripts where name = 'simCheckForSCDataReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simCheckForSCDataReaders')
	delete from GXDBVersions where aliasname = 'simCheckForSCDataReaders'
GO

insert into GXDBVersions values(2, 'simCheckForSCDataReaders',  '00010003030400010000', 'simCheckForSCDataReaders', '00010003030400010000')
GO

