

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simCheckEntityOfTypeEnabled.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018 CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simCheckEntityOfTypeEnabled.sp,v $ $Id: simCheckEntityOfTypeEnabled.sp,v 1.1.2.1 2018/03/27 15:34:21 philipmiller Exp $";
--
--  +========================================================================+
--  |   Cursor:  simCheckEntityOfTypeEnabled
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |   1.0       Phil	  Check if entity type is enabled for a client
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: simCheckEntityOfTypeEnabled <<<'

IF EXISTS (select * from sysobjects where name='simCheckEntityOfTypeEnabled')
	drop procedure simCheckEntityOfTypeEnabled
IF EXISTS (select * from GxQscripts where name='simCheckEntityOfTypeEnabled')
	delete from GxQscripts where name = 'simCheckEntityOfTypeEnabled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simCheckEntityOfTypeEnabled')
	delete from GXDBVersions where aliasname = 'simCheckEntityOfTypeEnabled'
GO
print '... Creating Procedure: simCheckEntityOfTypeEnabled'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simCheckEntityOfTypeEnabled
-- INPUT PARAMETERS
  @i_entityID integer,
  @i_entityType integer, 
  @i_selectResults integer = 0,
  @o_typeEnabled integer = 0 OUTPUT
AS
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
-- OUTPUT PARAMETERS
  DECLARE @typeEnabled integer
-- These lines represent the actual SQL code that will get executed.
SET NOCOUNT ON
IF @i_entityType IN (0, 1)
BEGIN
	IF EXISTS (	SELECT 1
				FROM DM2Cloud C (NOLOCK)
				JOIN DM2SearchServerCoreInfo S (NOLOCK) ON S.CloudId = C.cloudId
				WHERE
				(
@i_entityType = 0 AND S.CloudType = 1 OR
@i_entityType = 1 AND S.CloudType = 5
				)
				AND S.ClientId = @i_entityID
				AND C.status = 1)
		SET @o_typeEnabled = 1
END
--Return the value for enabled or disabled
IF @i_selectResults = 1
	SELECT @o_typeEnabled
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simCheckEntityOfTypeEnabled')
	delete from GxQscripts where name = 'simCheckEntityOfTypeEnabled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simCheckEntityOfTypeEnabled')
	delete from GXDBVersions where aliasname = 'simCheckEntityOfTypeEnabled'
GO

insert into GXDBVersions values(2, 'simCheckEntityOfTypeEnabled',  '00010001000200010000', 'simCheckEntityOfTypeEnabled', '00010001000200010000')
GO

