

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simCanAgentBeUpgraded.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simCanAgentBeUpgraded.sp,v $ $Id: simCanAgentBeUpgraded.sp,v 1.1.2.4 2019/03/25 18:37:13 xsui Exp $";
--
--  +========================================================================+
--  |      Cursor:  simCanAgentBeUpgraded
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simCanAgentBeUpgraded')
BEGIN
	print '>>> Drop Stored Procedure: simCanAgentBeUpgraded <<<'
	drop procedure simCanAgentBeUpgraded
END
IF EXISTS (select * from GxQscripts where name='simCanAgentBeUpgraded')
	delete from GxQscripts where name = 'simCanAgentBeUpgraded'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simCanAgentBeUpgraded')
	delete from GXDBVersions where aliasname = 'simCanAgentBeUpgraded'
GO
print '... Creating Procedure: simCanAgentBeUpgraded'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simCanAgentBeUpgraded
  @in_clientId INTEGER,
  @in_appTypeId INTEGER,
  @in_releaseId INTEGER
AS
  DECLARE @o_agentIsInstalled INTEGER = 0
  DECLARE @o_agentCanBeUpgraded INTEGER = 1
DECLARE @dummyOrDeletedOrUninstalled INTEGER = 0x00010 + 0x00004 + 0x00002
DECLARE @t_installedInstances TABLE (t_instanceId integer, t_version varchar(max))
DECLARE @attrDbVersion VARCHAR(1024)=''
SET @attrDbVersion = 	CASE @in_appTypeId
WHEN 3 	THEN 'Informix Version' 	-- CV_APPTYPE_INFORMIX = 3
WHEN 5		THEN 'SYBASE version'  		-- CV_APPTYPE_SYBASE = 5
WHEN 22		THEN 'Oracle Version'  		-- CV_APPTYPE_ORACLE8 = 22
WHEN 80	THEN 'Oracle Version'  		-- CV_APPTYPE_ORACLE_RAC = 80
WHEN 37			THEN 'DB2 Version' 			-- CV_APPTYPE_DB2 = 37
WHEN 62	THEN 'DB2 Version' 			-- CV_APPTYPE_UNIX_DB2 = 62
WHEN 103		THEN 'DB2 Version' 			-- CV_APPTYPE_DB2_DPF = 103
WHEN 81		THEN 'MSSQL Version' 		-- CV_APPTYPE_MSSQL = 81
WHEN 104 		THEN 'MySQL Version'		-- CV_APPTYPE_MYSQL = 104
WHEN 125	THEN 'PostgreSQL version'	-- CV_APPTYPE_POSTGRES = 125
						END
-- Find installed version
INSERT INTO @t_installedInstances
SELECT I.id, IP.attrVal
FROM APP_Application A WITH (NOLOCK)
JOIN APP_InstanceName I WITH (NOLOCK) ON A.instance = I.id
JOIN APP_InstanceProp IP WITH (NOLOCK) ON I.id = IP.componentNameId
WHERE 	A.clientId = @in_clientId AND
		((A.subclientStatus & @dummyOrDeletedOrUninstalled) = 0 ) AND
		IP.modified = 0 AND IP.attrName = @attrDbVersion AND
		((I.status & @dummyOrDeletedOrUninstalled) = 0 )
IF EXISTS (SELECT 1 FROM @t_installedInstances)
BEGIN
	SET @o_agentIsInstalled = 1
	-- Determine based on app type
IF @in_appTypeId = 3 -- CV_APPTYPE_INFORMIX = 3
	BEGIN
		-- Informix version < 11.5
		IF EXISTS (SELECT 1 FROM @t_installedInstances WHERE CAST(SUBSTRING(t_version,1,4) AS FLOAT) < 11.5)
			SET @o_agentCanBeUpgraded = 0
	END
ELSE IF @in_appTypeId = 5 -- CV_APPTYPE_SYBASE = 5
	BEGIN
		-- Sybase version 12.5
		IF EXISTS (SELECT 1 FROM @t_installedInstances WHERE t_version LIKE '%/12.5%')
			SET @o_agentCanBeUpgraded = 0
	END
ELSE IF @in_appTypeId = 22 OR @in_appTypeId = 80 -- CV_APPTYPE_ORACLE8 = 22, CV_APPTYPE_ORACLE_RAC = 80
	BEGIN
		-- Oracle 9i
		IF EXISTS (SELECT 1 FROM @t_installedInstances WHERE t_version LIKE '9%')
			SET @o_agentCanBeUpgraded = 0
	END
ELSE IF @in_appTypeId IN (37, 62, 103) -- CV_APPTYPE_DB2 = 37, CV_APPTYPE_UNIX_DB2 = 62, CV_APPTYPE_DB2_DPF = 103
	BEGIN
		-- DB2 version < 9.5
		-- Format is like SQL0901C
		IF EXISTS (SELECT 1 FROM @t_installedInstances WHERE CAST(SUBSTRING(t_version,4,4) AS INT) < 905)
			SET @o_agentCanBeUpgraded = 0
	END
ELSE IF @in_appTypeId = 81 -- CV_APPTYPE_MSSQL = 81
	BEGIN
		-- SQL 2000
IF EXISTS (SELECT 1 FROM @t_installedInstances WHERE t_version LIKE '8%' AND @in_releaseId >= 15)
			SET @o_agentCanBeUpgraded = 0
	END
ELSE IF @in_appTypeId = 104 -- CV_APPTYPE_MYSQL = 104
	BEGIN
		-- MySQL version < 5.5
		UPDATE @t_installedInstances SET t_version = (CASE	WHEN CHARINDEX('Distrib ', t_version) > 0
															THEN SUBSTRING(t_version, CHARINDEX('Distrib ', t_version) + 8, 5)
															ELSE t_version END)
		IF EXISTS (SELECT 1 FROM @t_installedInstances WHERE dbo.simCompareDottedVersion(t_version, 5, 5) < 0)
			SET @o_agentCanBeUpgraded = 0
	END
ELSE IF @in_appTypeId = 125 -- CV_APPTYPE_POSTGRES = 125
	BEGIN
		-- PostgreSQL version < 9.2
		IF EXISTS (SELECT 1 FROM @t_installedInstances WHERE dbo.simCompareDottedVersion(t_version, 9, 2) < 0)
			SET @o_agentCanBeUpgraded = 0
	END
END
SELECT @o_agentIsInstalled, @o_agentCanBeUpgraded
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simCanAgentBeUpgraded')
	delete from GxQscripts where name = 'simCanAgentBeUpgraded'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simCanAgentBeUpgraded')
	delete from GXDBVersions where aliasname = 'simCanAgentBeUpgraded'
GO

insert into GXDBVersions values(2, 'simCanAgentBeUpgraded',  '00010001000200040000', 'simCanAgentBeUpgraded', '00010001000200040000')
GO

