

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/simAdjustPkgListForRemoteOperation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/simAdjustPkgListForRemoteOperation.sp,v $ $Id: simAdjustPkgListForRemoteOperation.sp,v 1.1.2.14 2020/10/04 00:31:18 kgao Exp $";
--
--  +========================================================================+
--  |   Cursor:  simAdjustPkgListForRemoteOperation
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |   1.0       Phil	  Adjust list of packages for remote operation
--  |   				  - needed when packages are split and combined
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='simAdjustPkgListForRemoteOperation')
BEGIN
	print '>>> Drop Stored Procedure: simAdjustPkgListForRemoteOperation <<<'
	drop procedure simAdjustPkgListForRemoteOperation
END
IF EXISTS (select * from GxQscripts where name='simAdjustPkgListForRemoteOperation')
	delete from GxQscripts where name = 'simAdjustPkgListForRemoteOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simAdjustPkgListForRemoteOperation')
	delete from GXDBVersions where aliasname = 'simAdjustPkgListForRemoteOperation'
GO
print '... Creating Procedure: simAdjustPkgListForRemoteOperation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure simAdjustPkgListForRemoteOperation
-- INPUT PARAMETERS
-- Comma-delimited list of packages
  @i_pkgList VARCHAR(MAX),
-- Remote cache sync=0, INSTALL/UPDATE/UPGRADE=1
  @i_operationType integer=0,
-- Remote cache=0, client=1
  @i_remoteEntityType integer=0,
  @i_remoteEntityID integer=0,
-- V11=16, V10=15, V9=14
  @i_previousReleaseID integer=0,
  @i_newReleaseID integer=0,
  @i_updateOSId integer=0
AS
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
-- OUTPUT PARAMETERS
-- Comma-delimited list of packages
  DECLARE @o_pkgList VARCHAR(MAX)
-- These lines represent the actual SQL code that will get executed.
SET NOCOUNT ON
--temporary table using the split
DECLARE @t_pkgList TABLE (pkgID integer)
INSERT INTO @t_pkgList SELECT _ID FROM dbo.SplitStringByDelimiter(@i_pkgList, ',')
--Adjust packages for an Install, Update or Upgrade operation
IF @i_operationType = 1
BEGIN
IF @i_remoteEntityType = 1
	BEGIN
		-- During push install, there may be package splits that can only be identified by version information
		-- The below packages are split:
		   --> In V11 SP12, Network storage server (3DFS) is split from MediaAgent
		   --> In V11 SP13, Intellisnap is split from MediaAgent
		   --> In V11 SP13, push Hadoop
        DECLARE @bIsReleaseUpgrade INT = 0
        IF @i_previousReleaseID > 0 AND @i_previousReleaseID < @i_newReleaseID
            SET @bIsReleaseUpgrade = 1
		DECLARE @bIsServicePackUpgrade INT = 0
		DECLARE @previousMajorSP INT=0
		DECLARE @newMajorSP INT=0
		SELECT TOP 1 @previousMajorSP = psp.SPMajor
		FROM simInstalledPackages sip WITH(NOLOCK)
		JOIN PatchSPVersion psp WITH(NOLOCK) ON sip.SPVersionID = psp.id
		WHERE sip.clientId = @i_remoteEntityID
		AND psp.Release = @i_previousReleaseID
		ORDER BY psp.SPMajor DESC
		DECLARE @isCommServerInstall INT = 0
		IF @i_remoteEntityID = 2 OR EXISTS (SELECT 1 FROM APP_VMtoPMMap WITH(NOLOCK) WHERE VMClientId = 2 AND PMClientId = @i_remoteEntityID)
			SET @isCommServerInstall = 1
		SELECT TOP 1 @newMajorSP = spnum.major
		FROM patchGetCacheInfoByLevel(2, @i_newReleaseID, 0, @i_updateOsId, @isCommServerInstall) pmc
		CROSS APPLY dbo.GetServicePackNumbers(pmc.HighestSP) spnum
		ORDER by spnum.major DESC
		IF @bIsReleaseUpgrade = 0 AND @previousMajorSP > 0 AND @previousMajorSP < @newMajorSP
			SET @bIsServicePackUpgrade = 1
		IF @i_newReleaseID >= 16
		BEGIN
IF EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 51)
			BEGIN
				-- Add Analytics package for MediaAgent clients
IF NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 55)
				BEGIN
					-- Add analytics to the pkg list if Analytics is enabled
					DECLARE @hasAnalytics INT = 0
EXEC simCheckEntityOfTypeEnabled @i_remoteEntityID, 0, 0, @hasAnalytics OUTPUT;
					IF @hasAnalytics = 1
INSERT INTO @t_pkgList VALUES(55)
				END
				-- If Media Agent is configured, add 3DFS package
				IF (@bIsReleaseUpgrade=1 OR @bIsServicePackUpgrade=1 AND @previousMajorSP < 12) AND @newMajorSP >= 12
AND EXISTS (SELECT 1 FROM simInstalledPackages WITH(NOLOCK) WHERE clientId = @i_remoteEntityID AND simPackageID = 51)
AND NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 56)
INSERT INTO @t_pkgList VALUES(56)
				-- If Media Agent is configured, add Intellisnap package
				IF (@bIsReleaseUpgrade=1 OR @bIsServicePackUpgrade=1 AND @previousMajorSP < 13) AND @newMajorSP >= 13
AND EXISTS (SELECT 1 FROM simInstalledPackages WITH(NOLOCK) WHERE clientId = @i_remoteEntityID AND simPackageID = 51)
AND NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 504)
INSERT INTO @t_pkgList VALUES(504)
			END
IF EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 1301)
AND EXISTS (SELECT 1 FROM simInstalledPackages WITH(NOLOCK) WHERE clientId = @i_remoteEntityID AND simPackageID = 1301)
			BEGIN
				IF (@bIsReleaseUpgrade=1 OR @bIsServicePackUpgrade=1 AND @previousMajorSP < 12) AND @newMajorSP >= 12
AND @i_updateOSID IN (15,16)
AND NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 1307)
INSERT INTO @t_pkgList VALUES(1307)
				IF (@bIsReleaseUpgrade=1 OR @bIsServicePackUpgrade=1 AND @previousMajorSP < 13) AND @newMajorSP >= 13
AND NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 1402)
INSERT INTO @t_pkgList VALUES(1402)
			END
			--> In V11 SP13, push Hadoop
IF @newMajorSP >= 13 AND EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 1002) AND NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 1282)
			BEGIN
				DECLARE @bHadoopUpgradeRequired INT = 0
				EXEC AppCheckIfHadoopUpgradeRequired @i_remoteEntityID, @bHadoopUpgradeRequired OUTPUT
				IF @bHadoopUpgradeRequired > 0
INSERT INTO @t_pkgList VALUES(1282)
			END
			-- TODO: remove the mongo DB insertion once we have side by side simDependency ready
IF EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 252 OR pkgID = 20) AND NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 952)
			BEGIN
INSERT INTO @t_pkgList VALUES(952)
			END
IF EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 1174 OR pkgID = 1020) AND NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 1604)
			BEGIN
INSERT INTO @t_pkgList VALUES(1604)
			END
		END
	END
END
IF @i_operationType = 0
BEGIN
	-- Add WebConsole package for AdminConsole transition
IF EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 728)
AND NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 726)
INSERT INTO @t_pkgList VALUES(726)
IF EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 51)
	BEGIN
		-- During SP6, MediaAgent package is split into MACore, MA and Analytics, Upgrading MA from SP5 or less to SP6/SP7 will fail if MA client is pointing
		-- to a remote cache in which only MA package is configured for Sync up.
		-- If Media Agent is configured, add analytics package for SYNC if not already added/selected
IF NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 55)
INSERT INTO @t_pkgList VALUES(55)
		-- If Media Agent is configured, add Network Storage Server package for SYNC
IF NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 56)
INSERT INTO @t_pkgList VALUES(56)
		-- If Media Agent is configured, add Intellisnap package for SYNC
IF NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 504)
INSERT INTO @t_pkgList VALUES(504)
	END
IF EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 1301)
	BEGIN
		-- If Media Agent is configured, add Network Storage Server package for SYNC
IF NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 1307)
INSERT INTO @t_pkgList VALUES(1307)
		-- If Media Agent is configured, add Intellisnap package for SYNC
IF NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 1402)
INSERT INTO @t_pkgList VALUES(1402)
	END
	-- Database Upgrade package is required for pre-installation of clients, and is needed for upgrade with a db engine is present
IF NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 717)
AND EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID BETWEEN 800 AND 900)
INSERT INTO @t_pkgList VALUES(717)
	-- If UNIX BASE CLIENT is included, add Hadoop package for SYNC
IF EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 1002) AND NOT EXISTS (SELECT 1 FROM @t_pkgList WHERE pkgID = 1282)
INSERT INTO @t_pkgList VALUES(1282)
END
SELECT @o_pkgList = COALESCE(@o_pkgList+',' ,'') + CONVERT(VARCHAR(MAX), pkgId)
FROM @t_pkgList
--Return the adjusted package list
SELECT COALESCE(@o_pkgList, '')
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'simAdjustPkgListForRemoteOperation')
	delete from GxQscripts where name = 'simAdjustPkgListForRemoteOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='simAdjustPkgListForRemoteOperation')
	delete from GXDBVersions where aliasname = 'simAdjustPkgListForRemoteOperation'
GO

insert into GXDBVersions values(2, 'simAdjustPkgListForRemoteOperation',  '00010001000200140000', 'simAdjustPkgListForRemoteOperation', '00010001000200140000')
GO

