

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/setCSDB.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='setCSDB')
BEGIN
	print '>>> Drop Stored Procedure: setCSDB <<<'
	drop procedure setCSDB
END
IF EXISTS (select * from GxQscripts where name='setCSDB')
	delete from GxQscripts where name = 'setCSDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='setCSDB')
	delete from GXDBVersions where aliasname = 'setCSDB'
GO
print '... Creating Procedure: setCSDB'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure setCSDB
  @GalaxyHomeDir nvarchar(255),
  @VirtualClient nvarchar(255),
  @VirtualHostName nvarchar(255),
  @XmlMessage Xml,
  @GalaxyInstanceName nvarchar(255) = null
AS
declare @retVal integer
SET NOCOUNT ON
set @retVal = 0
declare @str_DRDestination	nvarchar(1024)
declare @str_user			nvarchar(1024)
declare @str_pwd			nvarchar(1024)
declare @temp_pwd           nvarchar(1024)
declare @str_ERuser			nvarchar(1024)
declare @str_ERpwd			nvarchar(1024)
declare @str_FTPuser		nvarchar(1024)
declare @str_FTPpwd			nvarchar(1024)
declare @str_FTPLocation	nvarchar(1024)
declare @i_CommcellPasswordExists	integer
declare @tempstr			nvarchar(1024)
declare @dbname				nvarchar(1024)
declare @errCode			integer
-- Install Mode Values
--	Fresh Install	= 1
--	Fresh Install with Existing DB = 2
--	Fresh Install with Customer DB = 3
--	Process Upgrade = 4
--	Tool Upgrade = 5
declare @i_InstallMode		integer
-- declare @i_CommservSurveyEnabled	integer
DECLARE @nowTime	integer
SET                @nowTime        = dbo.GetUnixTime (GetUTCdate())
SET @str_DRDestination = ISNULL(( SELECT ref.value('@path', 'nvarchar(1024)')
						FROM  @XmlMessage.nodes('CVInstallManager_CSDBInfo/ERPath') R ( ref )), '')
SET @str_ERuser = ISNULL((SELECT ref.value('@userName', 'nvarchar(1024)')
						FROM @XmlMessage.nodes('CVInstallManager_CSDBInfo/ERPath/userAccount') R (ref)), '')
SET @str_ERpwd = ISNULL((SELECT ref.value('@password', 'nvarchar(1024)')
						FROM @XmlMessage.nodes('CVInstallManager_CSDBInfo/ERPath/userAccount') R (ref)), '')
SET @str_FTPLocation = ISNULL(( SELECT ref.value('@path', 'nvarchar(1024)')
						FROM  @XmlMessage.nodes('CVInstallManager_CSDBInfo/FTPLocation') R ( ref ) ), '')
SET @str_FTPuser = ISNULL((SELECT ref.value('@userName', 'nvarchar(1024)')
						FROM @XmlMessage.nodes('CVInstallManager_CSDBInfo/FTPLocation/userAccount') R (ref)), '')
SET @str_FTPpwd = ISNULL((SELECT ref.value('@password', 'nvarchar(1024)')
						FROM @XmlMessage.nodes('CVInstallManager_CSDBInfo/FTPLocation/userAccount') R (ref)), '')
SET @str_user = ISNULL(( SELECT ref.value('@userName', 'nvarchar(1024)')
						FROM  @XmlMessage.nodes('CVInstallManager_CSDBInfo/CommCellUser') R ( ref ) ), '')
SET @str_pwd = ISNULL(( SELECT ref.value('@password', 'nvarchar(1024)')
						FROM  @XmlMessage.nodes('CVInstallManager_CSDBInfo/CommCellUser') R ( ref ) ), '')
SET @i_CommcellPasswordExists = ISNULL(( SELECT ref.value('@CommcellPasswordExists', 'int')
						FROM  @XmlMessage.nodes('CVInstallManager_CSDBInfo') R ( ref ) ), 0)
SET @i_InstallMode = ISNULL(( SELECT ref.value('@installMode', 'int')
						FROM  @XmlMessage.nodes('CVInstallManager_CSDBInfo') R ( ref ) ), 0)
-- SET @i_CommservSurveyEnabled = ISNULL(( SELECT ref.value('@CommservSurveyEnabled', 'int')
--						FROM  @XmlMessage.nodes('CVInstallManager_CSDBInfo') R ( ref ) ), 0)
-- Do this only on fresh install, after that do not change it
-- Replace execute SetSimpleRecoveryMode.sql
DECLARE	@databaseName nvarchar(256)
DECLARE @sqlStatement NVARCHAR(1024)
IF (@i_InstallMode = 1)
BEGIN
	SET		@databaseName = DB_NAME()
	SET @sqlStatement = 'ALTER DATABASE ' + @databaseName + ' SET RECOVERY SIMPLE'
	EXEC sp_executesql @sqlStatement
END
-- Extended store procedure creation
IF ( (@i_InstallMode IN (1, 2, 3, 5)) AND (@GalaxyHomeDir IS NOT NULL)  AND (LEN(RTRIM(LTRIM(@GalaxyHomeDir))) <> 0))
BEGIN
	IF EXISTS (select * from sysobjects where name='executeCSSetupScripts')
	begin
		exec @retVal = executeCSSetupScripts @GalaxyHomeDir
		if @@error <> 0 OR @retVal <> 0
		Begin
			GOTO CX_EXIT
		End
	end
	else
	begin
		SET @retVal = -1	--executeCSSetupScripts not found
		goto CX_EXIT
	end
END
-- Overall CCS Functionality disabled / enabled on the CommServer?
-- Perform requested operations to enable or disable CCS Functionality on the CommServer.
DECLARE @ccsEnabled	INT = 0
SELECT @ccsEnabled = CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'CommServCCSEnabled'
IF (@ccsEnabled = 0)
BEGIN
	-- delete all rows inserted by triggers upto this point and time, if any
	TRUNCATE TABLE APP_CCSTriggerRows
	-- Make sure all CCS Functionality on the CommServ and its clients is disabled!
	EXEC APPCCSControls @opCode=6, @force=1, @silentMode=1
	-- New requirements for CCS is for only Clients with FS Core installed with Laptop Configured all other configurations should be disabled
	EXEC APPCCSControls @opCode=16, @silentMode=1
END
ELSE
BEGIN
	-- New requirements for CCS is for only Clients with FS Core installed with Laptop Configured all other configurations should be disabled
	EXEC APPCCSControls @opCode=16, @silentMode=1
	-- May need to throttle CCS Clients from massively loading their database so disable all CCS Clients?
	-- This will allow for blocks of clients to be re-abled to load their CCS databases without DoS the CS.
	--EXEC APPCCSControls @opCode=17, @silentMode=1
	-- Make sure all CCS Functionality on the CommServ and its clients is re-enabled !
	EXEC APPCCSControls @opCode=7, @force=1, @silentMode=1
END
BEGIN TRANSACTION SETCSDB
IF (@i_InstallMode IN (4, 5))
BEGIN
	-- ALWAYS - STU
	exec @retVal = Br_ntPopulateAlertTemplate
	set @errCode = @@ERROR
	IF @errCode <> 0 OR @retVal <> 0 GOTO CX_EXIT
END
IF (@i_InstallMode = 1)
begin
	-- For fresh installs modify entity association for system created subscription based alerts to all clients.
	DECLARE @xmlEntities		AS nvarchar(MAX)= '<?xml version="1.0" encoding="UTF-16" standalone="no" ?><CVGui_CommCellTreeNode>  <associations _type_="2" /></CVGui_CommCellTreeNode>'
	DECLARE @dloClientGroup INT = ISNULL((SELECT MAX(id) FROM APP_ClientGroup WHERE flag&4096=4096 AND name = 'Laptop Clients'), 0)
	if (@dloClientGroup>0)
	begin
		set @xmlEntities = '<CVGui_CommCellTreeNode><associations _type_="28" clientGroupId="'+convert(nvarchar(max),@dloClientGroup)+'" clientGroupName="Laptop Clients" /></CVGui_CommCellTreeNode>'
		update NTnotificationRule
		set xmlEntityList=@xmlEntities
		where revision=1
		and notificationName in ('No backup for last 4 days','No backup for last 3 days','Restore job failed')
and (status & 128)>0
	end
end
-- Fresh Install Only - CHRIS
--DO NOT MODIFY THIS PROPERTY DURING UPGRADE OR INSTALL USING EXISTING DB
--Replacing call to simSetExpressPasswordCheck
IF (@i_InstallMode = 1) AND (NOT exists (Select value from GXGlobalParam where name = 'Enable password check for commcell Console' AND modified = 0))
BEGIN
	Insert into GXGlobalParam(name, value, created, modified)
	Values('Enable password check for commcell Console', LTRIM(RTRIM(STR(@i_CommcellPasswordExists))), @nowTime, 0)
	set @errCode = @@ERROR
	IF @errCode <> 0 GOTO RETURN_PROC
END
IF (@i_InstallMode = 1) AND (@GalaxyInstanceName IS NOT NULL AND LEN(@GalaxyInstanceName) > 0)
						AND (NOT exists (Select value from GXGlobalParam where name = 'CSvmInstnaceName' AND modified = 0))
BEGIN
	Insert into GXGlobalParam(name, value, created, modified)
	Values('CSvmInstnaceName', @GalaxyInstanceName, @nowTime, 0)
	set @errCode = @@ERROR
	IF @errCode <> 0 GOTO RETURN_PROC
END
-- Fresh Install
--Update the Default User password
declare @user_valid int
declare @user_perm int
declare @user_hide int
declare @user_admin int
set @user_valid = 0x001
set @user_perm = 0x002
set @user_hide = 0x004
set @user_admin = 0x040
--make admin part of administrative group
declare @i_GroupId	int
declare @i_UserId	int
-- Fresh Install or Fresh Install with Customer DB
SET @i_UserId = (SELECT TOP 1 id FROM UMUsers WHERE ((flags & @user_admin) <> 0))
if (@i_UserId IS NULL)
BEGIN
	SET @retVal = -1	--admin user not found
	goto CX_EXIT
END
IF ((@i_InstallMode = 1) OR (@i_InstallMode = 3))
BEGIN
	IF ((@i_UserId IS NOT NULL) AND (@str_user IS NOT NULL)  AND (LEN(RTRIM(LTRIM(@str_user))) <> 0))
	BEGIN
	    -- C# code always send encoded password. So we should decode it here
		-- We can stop doing this when XMLEncoder.encode() supports plain text
		IF((CHARINDEX('|#', @str_pwd, 1)) >0 )
		BEGIN
			SET @temp_pwd = (select dbo.DecodeInvalidXMLChar(@str_pwd))
			SET @temp_pwd = SUBSTRING(@temp_pwd, 2, LEN(@temp_pwd))
			SET @str_pwd = dbo.base64decode(@temp_pwd)
		END
		UPDATE UMUsers
		SET login = @str_user,
			name = 'Administrator',
			password = @str_pwd,
			description = 'Administrator',
			dateExpires = 0,
			pVer = 50,
			enabled = 1,
			policy = 0,
			lastLogInTime = 0,
			credSetTime = 0,
			umDSproviderId = 0,
			flags = (@user_valid | @user_perm | @user_admin)
		WHERE (UMUsers.id = @i_UserId)
		set @errCode = @@ERROR
		IF @errCode <> 0 GOTO RETURN_PROC
	END
END
-- Fresh Install, existing DB or Customer DB
--InsertDRDestination
IF ((@i_InstallMode = 1) OR (@i_InstallMode = 2) OR (@i_InstallMode = 3))
BEGIN
	IF ( EXISTS(SELECT name FROM GXGlobalParam WHERE name = 'DRDumpLocation' AND modified = 0))
	BEGIN
		-- DO NOT change value in DB if XML contains blank
		-- The install with existing DB option will not overwrite this path
		-- Once installer cade is fixed to not set the DR Path from registry
		-- This code can then be modified to honor the new value
		IF ((@str_DRDestination IS NOT NULL)  AND (LEN(RTRIM(LTRIM(@str_DRDestination))) <> 0))
		BEGIN
			UPDATE GXGlobalParam
			SET value = RTRIM(LTRIM(@str_DRDestination))
			WHERE name = 'DRDumpLocation' AND Modified = 0
			set @errCode = @@ERROR
			IF @errCode <> 0 GOTO RETURN_PROC
		END
	END
	ELSE
		BEGIN
			INSERT INTO GXGlobalParam(name, value, created, modified)
			VALUES ('DRDumpLocation', @str_DRDestination, @nowTime, 0)
			set @errCode = @@ERROR
			IF @errCode <> 0 GOTO RETURN_PROC
		END
END
-- Sergio will move this to tblscript
--InsertTasks
-- Fresh Install, Upgrades - Sergio
-- Fresh Install, Existing DB, Customer DB
IF((CHARINDEX('|#', @str_ERpwd, 1)) >0 )
BEGIN
	SET @temp_pwd = (select dbo.DecodeInvalidXMLChar(@str_ERpwd))
	SET @temp_pwd = SUBSTRING(@temp_pwd, 2, LEN(@temp_pwd))
	SET @str_ERpwd = dbo.base64decode(@temp_pwd)
END
IF exists (Select * from APP_Commcell where id = 2) AND
	((@str_ERuser IS NOT NULL)  AND (LEN(RTRIM(LTRIM(@str_ERuser))) <> 0)) AND
	((@str_ERpwd IS NOT NULL)  AND (LEN(RTRIM(LTRIM(@str_ERpwd))) <> 0))
BEGIN
	Update APP_Commcell
	set userName = @str_ERuser,
		userPassword = @str_ERpwd
	where id = 2
	set @errCode = @@ERROR
	IF @errCode <> 0 GOTO RETURN_PROC
END
-- Reset media password for in fresh install customer mode
--DO NOT UPDATE THE MEDIA PASSWORD ANYTIME
--SINCE WE DO NOT PROMPT FOR MEDIA PASSWORD DURING INSTALL / UPGRADE
IF (@i_InstallMode = 3) AND exists (Select value from GXGlobalParam where name = 'MediaPassword' AND modified = 0)
BEGIN
	-- set the Media password to value 2 as mentioned by Xuemei if password sent by installer is blank.
	Update GxGlobalParam
	set value = '2'
	where name = 'MediaPassword' AND modified = 0
	set @errCode = @@ERROR
	IF @errCode <> 0 GOTO RETURN_PROC
END
-- Set by the build team
--Replace simSetCustomerDBMode
if exists (Select * from GxGlobalParam where name = 'Customer DB Mode' AND modified = 0)
BEGIN
	Update GxGlobalParam
	set value = (CASE WHEN (@i_InstallMode = 3) THEN '1' ELSE '0' END)
	where name = 'Customer DB Mode' AND modified = 0
	set @errCode = @@ERROR
	IF @errCode <> 0 GOTO RETURN_PROC
END
else
BEGIN
	Insert into GxGlobalParam(name, value, created, modified)
	Values('Customer DB Mode', (CASE WHEN (@i_InstallMode = 3) THEN '1' ELSE '0' END), @nowtime, 0)
	set @errCode = @@ERROR
	IF @errCode <> 0 GOTO RETURN_PROC
END
-- Remove all data interface pairs from customer database
IF	@i_InstallMode = 3
BEGIN
	DELETE FROM archPipeline
	set @errCode = @@ERROR
	IF @errCode <> 0 GOTO RETURN_PROC
END
-- Fresh Install, other scenarios Chris will confirm
if (@i_InstallMode IN (1, 2, 3))
BEGIN
	if exists (Select * from GxGlobalParam where name = 'Patch Directory UserName' AND modified = 0)
	BEGIN
		IF ((@str_FTPuser IS NOT NULL) AND (LEN(RTRIM(LTRIM(@str_FTPuser))) <> 0))
		BEGIN
		   Update GxGlobalParam
		   set value = @str_FTPuser
		   where name = 'Patch Directory UserName' AND modified = 0
		   set @errCode = @@ERROR
		   IF @errCode <> 0 GOTO RETURN_PROC
		END
	END
	else
	BEGIN
		Insert into GxGlobalParam(name, value, created, modified)
		Values('Patch Directory UserName', @str_FTPuser, @nowTime, 0)
		set @errCode = @@ERROR
		IF @errCode <> 0 GOTO RETURN_PROC
	END
	if exists (Select * from GxGlobalParam where name = 'Patch Directory Password' AND modified = 0)
	BEGIN
		IF ((@str_FTPpwd IS NOT NULL) AND (LEN(RTRIM(LTRIM(@str_FTPpwd))) <> 0))
		BEGIN
    		Update GxGlobalParam
    		set value = @str_FTPpwd
    		where name = 'Patch Directory Password' AND modified = 0
    		set @errCode = @@ERROR
    		IF @errCode <> 0 GOTO RETURN_PROC
	   END
	END
	else
	BEGIN
		Insert into GxGlobalParam(name, value, created, modified)
		Values('Patch Directory Password', @str_FTPpwd, @nowTime, 0)
		set @errCode = @@ERROR
		IF @errCode <> 0 GOTO RETURN_PROC
	END
	if exists (Select * from GxGlobalParam where name = 'Patch Directory' AND modified = 0)
	BEGIN
		IF ((@str_FTPLocation IS NOT NULL)  AND (LEN(RTRIM(LTRIM(@str_FTPLocation))) <> 0))
		BEGIN
			Update GxGlobalParam
			set value = @str_FTPLocation
			where name = 'Patch Directory' AND modified = 0
			set @errCode = @@ERROR
			IF @errCode <> 0 GOTO RETURN_PROC
		END
	END
	else
	BEGIN
		Insert into GxGlobalParam(name, value, created, modified)
		Values('Patch Directory', @str_FTPLocation, @nowTime, 0)
		set @errCode = @@ERROR
		IF @errCode <> 0 GOTO RETURN_PROC
	END
END
-- if exists (Select * from GxGlobalParam where name = 'CommservSurveyEnabled' AND modified = 0)
-- BEGIN
--	Update GxGlobalParam
--	set value = LTRIM(RTRIM(STR(@i_CommservSurveyEnabled)))
--	where name = 'CommservSurveyEnabled' AND modified = 0
--	set @errCode = @@ERROR
--	IF @errCode <> 0 GOTO RETURN_PROC
-- END
-- else
-- BEGIN
--	Insert into GxGlobalParam(name, value, created, modified)
--	Values('CommservSurveyEnabled', LTRIM(RTRIM(STR(@i_CommservSurveyEnabled))), @nowtime, 0)
--	set @errCode = @@ERROR
--	IF @errCode <> 0 GOTO RETURN_PROC
-- END
-- Check with Waqas
-- Reserve client id 2 for virtual installs
--IF (@i_InstallMode = 1)
--BEGIN
--	IF NOT EXISTS (select * from APP_Client where id = 2) and @VirtualClient is not null and len(@VirtualClient) > 0 and @VirtualHostName is not null and len(@VirtualHostName) > 0
--	insert into App_Client
--	select @VirtualClient, 0, @VirtualHostName, '', 0, 0, 0, 0, @VirtualHostName, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 2, newid(),0, @VirtualClient
--	set @errCode = @@ERROR
--	IF @errCode <> 0 GOTO RETURN_PROC
--END
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
RETURN_PROC:
IF @retVal <> 0
	GOTO CX_EXIT
set @retVal = @errCode
CX_EXIT:
If @retVal = 0
	COMMIT TRANSACTION SETCSDB
If @retVal <> 0
	ROLLBACK TRANSACTION SETCSDB
	SELECT @retVal
	RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'setCSDB')
	delete from GxQscripts where name = 'setCSDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='setCSDB')
	delete from GXDBVersions where aliasname = 'setCSDB'
GO

insert into GXDBVersions values(2, 'setCSDB',  '00000000000000000000', 'setCSDB', '00000000000000000000')
GO

