

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_vt_Policy2Container.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_vt_Policy2Container.sp,v $ $Id: sec_vt_Policy2Container.sp,v 1.4.48.1 2017/02/10 21:57:48 sjohnson Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_vt_Policy2Container()
--  |
--  | Description:  Updates Security for selected VaultTracker Container based
--	|               on selected VaultTracker Policy and operation
--  |
--  |       Input:  outputTableArg
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--	|   1.1        SKatz	New for Release 8.0
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_vt_Policy2Container <<<'

IF EXISTS (select * from sysobjects where name='sec_vt_Policy2Container')
	drop procedure sec_vt_Policy2Container
IF EXISTS (select * from GxQscripts where name='sec_vt_Policy2Container')
	delete from GxQscripts where name = 'sec_vt_Policy2Container'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_vt_Policy2Container')
	delete from GXDBVersions where aliasname = 'sec_vt_Policy2Container'
GO
print '... Creating Procedure: sec_vt_Policy2Container'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_vt_Policy2Container
  @srcPolicyId integer,
  @dstContainerId integer,
  @flags integer
AS
  DECLARE @retVal integer
  DECLARE @retString varchar(1024)
-------------------------------
-- Following For Convenience --
-------------------------------
declare @CONTAINER_ITEM int
declare @TM_POLICY_ITEM int
SET @TM_POLICY_ITEM = 8462
SET @CONTAINER_ITEM = 8107
-------------------------------
SET @retVal    = -1				-- ASSUME THE WORST!
SET @retString = 'Unknown Error'
--------------------------
-- DID WE DO ANYTHING? ---
--------------------------
IF @flags NOT IN (1, 2, 10)
BEGIN
	SET @retVal = -2
	SET @retString = 'Invalid Operation Parameter ['+convert(varchar(2), @flags) +'].'
	GOTO PROC_EXIT
END
--------------------------
-- VALIDATE INPUTS? ---
--------------------------
IF @dstContainerId = 0
BEGIN
		set @retVal = -2
		set @retString = 'dstContainerId[' + convert(varchar(10), @dstContainerId)+']' +' must be non-zero.'
		goto PROC_EXIT
END
IF @flags IN (1,2)
BEGIN
	IF @dstContainerId = 0 OR @srcPolicyId = 0
	BEGIN
		set @retVal = -2
		set @retString = 'srcPolicyId['+ convert(varchar(10), @srcPolicyId)+']'
							+' and dstContainerId[' + convert(varchar(10), @dstContainerId)+']'
							+' must be unique and non-zero'
		goto PROC_EXIT
	END
END
IF dbo.isNewSecurity() = 0
BEGIN
	IF object_id('tempdb.dbo.#groupChanges') is not null
						DROP TABLE #groupChanges
	create table #groupChanges
	(
	gc_groupId int not null,
	operation  int not null
	)
	BEGIN TRAN
	---------------------------------------------
	-- REPLACE EXISTING GROUPS WITH NEW GROUPS --
	---------------------------------------------
	IF @flags = 2
	BEGIN
		INSERT #groupChanges				-- THIS WILL BE USED TO MARK GROUPS "Dirty"
			SELECT groupId, @flags
			FROM UMGroupAssociation
				WHERE type1=@CONTAINER_ITEM AND id1= @dstContainerId
		DELETE UMGroupAssociation						-- DELETE OLD ASSOCIATIONS
		WHERE type1=@CONTAINER_ITEM AND id1= @dstContainerId
		SET @flags = 1									-- Set up for Adding groups back in
	END
	---------------------------------------
	-- ADD NEW GROUPS TO EXISTING GROUPS --
	---------------------------------------
	IF @flags = 1					-- ADD GROUPS TO EXISTING GROUPS FOR THIS CONTAINER
	BEGIN
		INSERT #groupChanges
			SELECT groupID, @flags
			FROM  UMgroupAssociation
				WHERE type1= @TM_POLICY_ITEM AND id1=@srcPolicyID
		DELETE #groupChanges
			WHERE EXISTS ( Select * from UMGroupAssociation
							WHERE groupId = gc_groupId
							AND   type1   = @CONTAINER_ITEM
							AND   id1     = @dstContainerId
				 		  )
		INSERT UMGroupAssociation
			SELECT gc_groupId, @CONTAINER_ITEM, @dstContainerId, 0,0, 0,0, 0,0, 0
			FROM #groupChanges
			WHERE operation = 1
		SET @flags = 0									-- NO MORE TO DO!
		set @retVal = 0
		set @retString = ''
	END
	-------------------------------------
	-- DELETE ALL ASSOC. FOR CONTAINER --
	-------------------------------------
	IF @flags = 10
	BEGIN
		INSERT #groupChanges				-- THIS WILL BE USED TO MARK GROUPS "Dirty"
			SELECT groupId, @flags
			FROM UMGroupAssociation
				WHERE type1=@CONTAINER_ITEM AND id1= @dstContainerId
		DELETE UMGroupAssociation						-- DELETE OLD ASSOCIATIONS
		WHERE type1=@CONTAINER_ITEM AND id1= @dstContainerId
		SET @flags = 0									-- NO MORE TO DO!
		set @retVal = 0
		set @retString = ''
	END
	if @retVal = 0
		COMMIT TRAN
	else
		ROLLBACK TRAN
	-------------------------------------------------------------------------------------------------
	-- FOR CASES WHERE WE'VE ADDED BACK IN THE SAME GROUP, WE DON'T NEED TO MARK THE GROUP "DIRTY" --
	-------------------------------------------------------------------------------------------------
	DELETE G1
		FROM #groupChanges as G1, #groupChanges as G2
			WHERE G1.gc_groupId = G2.gc_groupId
				AND G1.operation = 1
				AND G2.operation = 2
	drop table #groupChanges
END
ELSE
BEGIN
	BEGIN TRAN
	IF @flags IN (1,2)
	BEGIN
EXEC sec_cloneSecurityAssociationsFromEntity @flags, 0, @retVal OUTPUT, @retString OUTPUT, 21, @srcPolicyId, 130, @dstContainerId
	END
	IF @flags = 10
	BEGIN
EXEC sec_deleteSecurityAssociationsForEntity 130, @dstContainerId
		SET @retVal = 0
		SET @retString = ''
	END
	if @retVal = 0
		COMMIT TRAN
	else
		ROLLBACK TRAN
END
PROC_EXIT:
select @retVal, @retString
GO


IF EXISTS (select * from GxQscripts where name = 'sec_vt_Policy2Container')
	delete from GxQscripts where name = 'sec_vt_Policy2Container'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_vt_Policy2Container')
	delete from GXDBVersions where aliasname = 'sec_vt_Policy2Container'
GO

insert into GXDBVersions values(2, 'sec_vt_Policy2Container',  '00010004004800010000', 'sec_vt_Policy2Container', '00010004004800010000')
GO

