

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_validatePrivacy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Ravneet Arora
--	Date:   1/18/2014
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_validatePrivacy.sp,v $ $Id: sec_validatePrivacy.sp,v 1.1.2.9 2020/05/16 00:47:23 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_validatePrivacy')
BEGIN
	print '>>> Drop Stored Procedure: sec_validatePrivacy <<<'
	drop procedure sec_validatePrivacy
END
IF EXISTS (select * from GxQscripts where name='sec_validatePrivacy')
	delete from GxQscripts where name = 'sec_validatePrivacy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_validatePrivacy')
	delete from GXDBVersions where aliasname = 'sec_validatePrivacy'
GO
print '... Creating Procedure: sec_validatePrivacy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_validatePrivacy
  @i_userId INT,
  @i_entityId INT,
  @i_type INT,
  @i_localeId INT
AS
  DECLARE @o_errorCode INT
  DECLARE @o_errorString nvarchar(max)
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @o_errorCode = 0
	DECLARE @clientId INT = 0
	SET @clientId = (SELECT CASE
WHEN @i_type = 7 THEN (SELECT distinct clientId from App_Application where id = @i_entityId)
WHEN @i_type = 5 THEN (SELECT distinct clientId from App_Application where instance = @i_entityId)
WHEN @i_type = 6 THEN (SELECT distinct clientId from App_Application where backupset = @i_entityId)
							 ELSE @i_entityId
							END)
	IF @clientId = 0 OR @i_userId =0
	BEGIN
SET @o_errorCode = (2263 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO ENDSP
	END
	-- Fetch the latest property with modified set to 0.
	-- Reading the encrypted Enable Data Security attributeValue and converting back to 0 and 1 respectively
	DECLARE @is_clientLocked INT = ISNULL((SELECT CASE attrVal
WHEN  'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a'  THEN 1
														ELSE 0
																  END FROM APP_ClientProp WHERE componentNameId=@clientId
AND attrName='7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807' and modified=0),0)
	-- 1. If locked at client level, then only client owner can access it as before
	IF  @is_clientLocked = 1
	BEGIN
		IF dbo.IsClientOwner(@clientId,@i_userId) = 0
		BEGIN
SET @o_errorCode = (2264 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO ENDSP
		END
		SET @o_errorCode = 0
		GOTO ENDSP
	END
	-- Allow privacy at company level only for MSP.
	-- 2. If the lock is enabled at company level/commcell level then MSP admin cannot view the company data
	-- Do we need upgrade script to populate PROP_ASSOCIATED_COMPANY_ID property for all
	DECLARE @clientcompanyId INTEGER = ISNULL((SELECT CONVERT(INTEGER,attrval)  FROM APP_ClientProp WHERE
attrname='Installation Company ID' AND componentNameId=@i_entityId AND modified=0) , -1)
	IF @clientcompanyId = -1
	BEGIN
			SET	@clientcompanyId = ISNULL((select TOP 1 componentNameId from App_CompanyProp ACP
INNER JOIN APP_ClientGroupAssoc ACGA on ACP.attrValInt=ACGA.clientGroupId AND  ACP.attrName='Associated Smart Client Group' AND ACP.cs_attrName = checksum('Associated Smart Client Group')
																INNER JOIN APP_Client AC on AC.id = ACGA.clientId
																WHERE AC.id = @i_entityId AND ACP.modified = 0),0)
	END
	IF @clientcompanyId > 0
	BEGIN
		-- Use check sum to fetch the property
		DECLARE @is_orgLocked INT = ISNULL((SELECT(
													 CASE
WHEN attrVal = 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a' THEN 1
													 ELSE 0
													 END
												)  FROM APP_CompanyProp where componentNameId=@clientcompanyId AND
attrName='7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807'
AND modified = 0 AND cs_attrName = CHECKSUM('7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807')),0)
		IF @is_orgLocked = 1
		BEGIN
			-- Simplifying MSP admin cannot view data  as only the users who belongs to that company
			-- with appropriate rights on the client can browse/restore the locked client data
			-- Rights will be checked in APIs, this is prelim check to see if they belong to this category and prevent admins.
			IF @clientcompanyId <> dbo.AppGetOrganizationForUser(@i_userId)
			BEGIN
				-- Not company user
SET @o_errorCode = (3972 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO ENDSP
			END
IF EXISTS(SELECT 1 FROM UMUserGroup UU INNER JOIN UMGroups UG ON UU.groupId=UG.id where UG.groupFlags & 0x40000<> 0 and UU.userId=@i_userId)
			BEGIN
				-- Not company user
SET @o_errorCode = (3971 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO ENDSP
			END
		END
	END
	SET @o_errorCode = 0
	GOTO ENDSP
	ENDSP:
	SET @o_errorString = (SELECT Message
    from EvLocaleMsgs
    where EvLocaleMsgs.MessageId = @o_errorCode
    AND [localeId] = @i_localeId)
	SELECT @o_errorCode as o_errorCode,@o_errorString as o_errorString
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_validatePrivacy')
	delete from GxQscripts where name = 'sec_validatePrivacy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_validatePrivacy')
	delete from GXDBVersions where aliasname = 'sec_validatePrivacy'
GO

insert into GXDBVersions values(2, 'sec_validatePrivacy',  '00010001000200090000', 'sec_validatePrivacy', '00010001000200090000')
GO

