

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_validatePermissionList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ------------------------------------------------------------------------
-- Input: temp table #categoryPermissionAssociationConsolidated should exist
-- Return: errorCode and errorString
-- Description:
-- This SP is for doing a sanity check on the input before inserting the
-- values into UMRolesPermissions table. This SP should be called only with
-- a table called as #categoryPermissionAssociationConsolidated which should
-- have the following column names - hierarchyLevel, categoryId, permissionId,
-- excludeCategory, excludePermission, shouldInsert. All are integer columns
-- and shouldInsert should be set to 0 for all the entries. This SP will check
-- that the table follows the role category-permission hierarchy and then marks
-- the rows that are to be inserted as shouldInsert = 1
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_validatePermissionList <<<'

IF EXISTS (select * from sysobjects where name='sec_validatePermissionList')
	drop procedure sec_validatePermissionList
IF EXISTS (select * from GxQscripts where name='sec_validatePermissionList')
	delete from GxQscripts where name = 'sec_validatePermissionList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_validatePermissionList')
	delete from GXDBVersions where aliasname = 'sec_validatePermissionList'
GO
print '... Creating Procedure: sec_validatePermissionList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_validatePermissionList
  @localeId INT,
  @errorCode INT OUTPUT,
  @errorString nvarchar(max) OUTPUT  	
AS
SET @errorCode = 0
SET @errorString  = 'Successful'
DECLARE @allCategoriesEntity AS INT = 123
DECLARE @categoryEntity AS INT = 121
DECLARE @permissionEntity AS INT = 122
DECLARE @allCategoriesIncluded AS INT = 0
DECLARE @invalidEntry NVARCHAR(MAX) = N''
--Check if all ids are filled properly
IF EXISTS (SELECT *
		   FROM #categoryPermissionAssociationConsolidated
		   WHERE (hierarchyLevel = @categoryEntity  AND categoryId <= 0 ))
BEGIN
SET @errorCode = (2415 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2415 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
    GOTO END_PROCESSING
END
IF EXISTS (SELECT *
		   FROM #categoryPermissionAssociationConsolidated
		   WHERE (hierarchyLevel = @permissionEntity AND permissionId <= 0))
BEGIN
SET @errorCode = (2416 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2416 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
    GOTO END_PROCESSING
END
--THere should not be duplicate category / permission row
IF EXISTS (SELECT 1
		   FROM #categoryPermissionAssociationConsolidated
		   GROUP BY categoryId, permissionId
		   HAVING COUNT(*) > 1)
BEGIN
SET @errorCode = (2417 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2417 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
	SET @invalidEntry = (SELECT TOP 1 '[' + dbo.sec_getLocalizedCategory(categoryId, @localeId) + '] - [' + dbo.sec_getLocalizedPermission(permissionId, @localeId) + ']'
						 FROM #categoryPermissionAssociationConsolidated
						 GROUP BY categoryId, permissionID
						 HAVING COUNT(*) > 1)
	SET @errorString = REPLACE (@errorString, '^1%s', @invalidEntry)
    GOTO END_PROCESSING
END
--All categories cannot be excluded
IF EXISTS (SELECT 1
		   FROM #categoryPermissionAssociationConsolidated
		   WHERE hierarchyLevel = @allCategoriesEntity AND (excludeCategory = 1 OR excludePermission = 1))
BEGIN
SET @errorCode = (2418 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2418 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
    GOTO END_PROCESSING
END
IF EXISTS (SELECT * FROM #categoryPermissionAssociationConsolidated WHERE hierarchyLevel = @allCategoriesEntity)
BEGIN
	--All category row must be inserted
	UPDATE #categoryPermissionAssociationConsolidated
	SET shouldInsert = 1
	WHERE hierarchyLevel = @allCategoriesEntity
	SET @allCategoriesIncluded = 1
END
DECLARE @temphierarchylevel AS INT
DECLARE @tempCategoryId AS INT
DECLARE @tempPermissionId AS INT
DECLARE @includeTbl AS TABLE (hierarchyLevel INT, categoryId INT, permissionId INT)
DECLARE @excludeTbl AS TABLE (hierarchyLevel INT, categoryId INT, permissionId INT)
DECLARE @parentCategoriesTbl TABLE(categoryId INT)
DECLARE @thisCategoryName AS NVARCHAR(MAX) = ''
DECLARE @thisPermissionName AS NVARCHAR(MAX) = ''
--At this point there will be only one row for each category-permission combination
INSERT INTO @includeTbl
	SELECT hierarchyLevel, categoryId, permissionId
	FROM #categoryPermissionAssociationConsolidated
	WHERE excludecategory = 0 AND excludepermission = 0 AND hierarchyLevel <> @allCategoriesEntity
INSERT INTO @excludeTbl
	SELECT hierarchyLevel, categoryId, permissionId
	FROM #categoryPermissionAssociationConsolidated
	WHERE excludeCategory = 1 OR excludePermission = 1
--Note: All the checks done hereafter are order-based. DONOT CHANGE THE ORDER IN WHICH THESE CHECKS ARE DONE
DECLARE includeCursor CURSOR STATIC FOR
	SELECT hierarchyLevel, categoryId, permissionId
	FROM @includeTbl
OPEN includeCursor
FETCH NEXT FROM includeCursor INTO @tempHierarchyLevel, @tempCategoryId, @tempPermissionId
WHILE @@FETCH_STATUS = 0
BEGIN
	DELETE FROM @parentCategoriesTbl
	SET @thisCategoryName = ''
	SET @thisPermissionName = ''
	--1. Get all parents of given category or permission
	INSERT INTO @parentCategoriesTbl
		SELECT categoryId
		FROM dbo.getAllParentsForCatOrPerm(@tempCategoryId, @tempPermissionId)
	--2. Check if any parent is excluded, if so throw error
	DECLARE @excludedParentCategoryId AS INT = 0
	SET @excludedParentCategoryId = ISNULL((SELECT TOP 1 categoryId
											FROM @excludeTbl
											WHERE hierarchyLevel = @categoryEntity AND
												  categoryId IN (SELECT Parent.categoryId FROM @parentCategoriesTbl AS Parent)),0)
	IF @excludedParentCategoryId <> 0
	BEGIN
		SET @thisCategoryName = dbo.sec_getLocalizedCategory(@tempCategoryId, @localeId)
		SET @thisPermissionName  = CASE WHEN @temppermissionId <> 0 THEN dbo.sec_getLocalizedPermission(@tempPermissionId, @localeId)
										ELSE ''
									END
SET @errorCode = (2419 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2419 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', dbo.sec_getLocalizedCategory(@excludedParentCategoryId, @localeId))
		SET @errorString = REPLACE(@errorString, '^2%s', @thisCategoryName)
		SET @errorString = REPLACE(@errorString, '^3%s', @thisPermissionName)
		CLOSE includecursor
		DEALLOCATE includecursor
		GOTO END_PROCESSING
	END
	--3. Now we are sure there is no excluded parent. We are left with 2 options - either some parents are included or no parent is included.
	--If some parent is included, then no need to include this. If not then include this.
	IF @allCategoriesIncluded = 1 OR EXISTS (SELECT * FROM @includeTbl WHERE hierarchyLevel = @categoryEntity AND categoryId IN (SELECT categoryid FROM @parentCategoriesTbl ))
	BEGIN
		FETCH NEXT FROM includeCursor INTO @tempHierarchyLevel, @tempCategoryId, @tempPermissionId
		CONTINUE
	END
	--4. Mark this row for insertion
	UPDATE #categoryPermissionAssociationConsolidated
	SET shouldInsert = 1
	WHERE hierarchyLevel = @temphierarchylevel AND categoryId = @tempCategoryId AND permissionId = @tempPermissionId
	FETCH NEXT FROM includeCursor INTO @tempHierarchyLevel, @tempCategoryId, @tempPermissionId
END
CLOSE includeCursor
DEALLOCATE includeCursor
DECLARE excludeCursor CURSOR STATIC FOR
	SELECT hierarchyLevel, categoryId, permissionId
	FROM @excludeTbl
OPEN excludecursor
FETCH NEXT FROM excludecursor INTO @temphierarchyLevel, @tempCategoryId, @tempPermissionId
WHILE @@FETCH_STATUS = 0
BEGIN
	DELETE FROM @parentCategoriesTbl
	SET @thisCategoryName = ''
	SET @thisPermissionName = ''
	--1. Get all the parents
	INSERT INTO @parentCategoriesTbl
		SELECT categoryId
		FROM dbo.getAllParentsForCatOrPerm(@tempCategoryId, @tempPermissionId)
	--2. If any of the parent is excluded then no need to exclude this explicitly
	IF EXISTS (SELECT * FROM @excludeTbl WHERE hierarchyLevel = @categoryEntity AND categoryId IN (SELECT categoryId FROM @parentCategoriesTbl  ))
	BEGIN
		FETCH NEXT FROM excludecursor INTO @temphierarchyLevel, @tempCategoryId, @tempPermissionId
		CONTINUE
	END
	--3. If some parent is included explicitly then we can exclude this. If not throw error
	IF @allcategoriesincluded = 1 OR EXISTS (SELECT * FROM @includeTbl WHERE hierarchyLevel = @categoryEntity AND categoryId IN (SELECT categoryId FROM @parentCategoriesTbl ))
	BEGIN
		--Mark this row for insertion
		UPDATE #categoryPermissionAssociationConsolidated
		SET shouldInsert = 1
		WHERE hierarchyLevel = @temphierarchylevel AND categoryId = @tempCategoryId AND permissionId = @tempPermissionId
	END
	ELSE
	BEGIN
		--No parent is included. Then cannot exclude category / permission also.
		SET @thisCategoryName = dbo.sec_getLocalizedCategory(@tempCategoryId, @LocaleId)
		SET @thisPermissionName = CASE WHEN @temppermissionId <> 0 THEN dbo.sec_getLocalizedPermission(@tempPermissionId, @localeId)
															ELSE ''
														END
SET @errorCode = (2420 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2420 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', @thisCategoryName)
		SET @errorString = REPLACE(@errorString, '^2%s', @thisPermissionName)
		CLOSE excludecursor
		DEALLOCATE excludecursor
		GOTO END_PROCESSING
	END
	FETCH NEXT FROM excludecursor INTO @temphierarchyLevel, @tempCategoryId, @tempPermissionId
END
CLOSE excludeCursor
DEALLOCATE excludeCursor
END_PROCESSING:
GO

IF EXISTS (select * from GxQscripts where name = 'sec_validatePermissionList')
	delete from GxQscripts where name = 'sec_validatePermissionList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_validatePermissionList')
	delete from GXDBVersions where aliasname = 'sec_validatePermissionList'
GO

insert into GXDBVersions values(2, 'sec_validatePermissionList',  '00000000000000000000', 'sec_validatePermissionList', '00000000000000000000')
GO

