

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_validateNewOwnerInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ----------------------------------------------------------------------
--
--          Stored procedure to check if given new owner Info
--          is valid as selected by logged in user.
--			How it works:
--			1. If new owner is user,
--			    a. If it is SystemAdmin then checks if logged in user is Commcell Admin user.
--			    b. If it is same as logged in user then no check.
--			    c. If it is different user then check if logged in user has 'Add, delete and modify a user' permission on that user.
--			2. If new owner is user group,
--			    a. If logged in user is Commcell Admin user then allow any group.
--			    b. Else check if logged in user is member of the user group.
--			Note: Commcell Admin User - User having 'Change Security Settings' permission on commcell.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_validateNewOwnerInfo')
BEGIN
	print '>>> Drop Stored Procedure: sec_validateNewOwnerInfo <<<'
	drop procedure sec_validateNewOwnerInfo
END
IF EXISTS (select * from GxQscripts where name='sec_validateNewOwnerInfo')
	delete from GxQscripts where name = 'sec_validateNewOwnerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_validateNewOwnerInfo')
	delete from GXDBVersions where aliasname = 'sec_validateNewOwnerInfo'
GO
print '... Creating Procedure: sec_validateNewOwnerInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_validateNewOwnerInfo
  @loggedInUserId INT,
  @newOwnerUserId INT,
  @newOwnerGroupId INT,
  @locale INT,
  @errorCode INT = 0 OUTPUT,
  @errorMessage NVARCHAR(1024) = '' OUTPUT,
  @shouldReturnValue INT = 0
AS
  DECLARE @o_errorCode INT
  DECLARE @o_errorMessage NVARCHAR(1024)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @isAdminUser INT = 0
IF @newOwnerUserId <> 0
BEGIN
	IF (ISNULL((SELECT enabled FROM UMUsers where id = @newOwnerUserId), 0) = 0)
	BEGIN
SET @errorCode = (3497 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3497 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
		GOTO EXITPROC
	END
IF @newOwnerUserId = ISNULL((SELECT id FROM UMUSers WHERE flags & 0x1000 <> 0), 0)
	BEGIN
EXEC sec_checkPermissionOnEntity @loggedInUserId, 107, @isAdminUser OUTPUT, 1, 2
		IF @isAdminUser = 0
		BEGIN
SET @errorCode = (2408 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2408 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @loggedInUserId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2406 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (468 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
			GOTO EXITPROC
		END
	END
	ELSE IF @newOwnerUserId <> @loggedInUserId
	BEGIN
		DECLARE @hasEditUserPermission INT = 0
EXEC sec_checkPermissionOnEntity @loggedInUserId, 101, @hasEditUserPermission OUTPUT, 13, @newOwnerUserId
		IF @hasEditUserPermission = 0
		BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @loggedInUserId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2403 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
			SET @errorMessage = REPLACE(@errorMessage, '^3%s', ISNULL((SELECT login FROM UMUsers WHERE id = @newOwnerUserId),''))
SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2371 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
			GOTO EXITPROC
		END
	END
END
ELSE
BEGIN
	IF ((ISNULL((SELECT groupFlags FROM UMGroups WHERE id  = @newOwnerGroupId), 0) & 1) = 0)
	BEGIN
SET @errorCode = (3497 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3497 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
		GOTO EXITPROC
	END
EXEC sec_checkPermissionOnEntity @loggedInUserId, 107, @isAdminUser OUTPUT, 1, 2
	IF @isAdminUser = 0
	BEGIN
		DECLARE @isMemberOfGroup INT = 0
		EXEC sec_isMemberOfGroup @loggedInUserId, @newOwnerGroupId, @isMemberOfGroup OUTPUT
		IF @isMemberOfGroup = 0
		BEGIN
SET @errorCode = (2989 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2989 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			GOTO EXITPROC
		END
	END
END
EXITPROC:
IF @shouldReturnValue <> 0
	SELECT @errorCode, @errorMessage
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_validateNewOwnerInfo')
	delete from GxQscripts where name = 'sec_validateNewOwnerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_validateNewOwnerInfo')
	delete from GXDBVersions where aliasname = 'sec_validateNewOwnerInfo'
GO

insert into GXDBVersions values(2, 'sec_validateNewOwnerInfo',  '00000000000000000000', 'sec_validateNewOwnerInfo', '00000000000000000000')
GO

