

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_userHasCapability.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code. --
--
-- Input : i_userId : userId
--			i_capability: OBSOLETED  (code written for 10.0 older) its capability bit mask to check if user has on any entity or not . ( it will support only less than 64 ids)
--							any new code should always use i_permissionId varchar
--	        i_permissionId  :is comma separated list of permission id need to be check. ( 1,2,3)
--			i_anyCapability <>0  (OR) condition IF any one present is present return true
--							=0 (AND) all permission should present to return true.
--		Output: if both i_capability and i_permissionId is filled : return 0.... populate any 1 of them always.. ( its error condition).
--				i_anyCapability <>0 : AND : check if all permission are present.
--								=0 : OR : If any input permission is present.
--		NOTE: i_permissionId and i_anyCapability is applicable  only for new security
--
-- ------------------------------------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_userHasCapability')
BEGIN
	print '>>> Drop Stored Procedure: sec_userHasCapability <<<'
	drop procedure sec_userHasCapability
END
IF EXISTS (select * from GxQscripts where name='sec_userHasCapability')
	delete from GxQscripts where name = 'sec_userHasCapability'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_userHasCapability')
	delete from GXDBVersions where aliasname = 'sec_userHasCapability'
GO
print '... Creating Procedure: sec_userHasCapability'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_userHasCapability
  @i_userId integer,
  @i_capability bigint,
  @o_userHasCapability integer OUTPUT,
  @i_returnCursor integer=0,
  @i_anyCapability integer=0,
  @i_permissionId varchar(MAX)=''
AS
  DECLARE @o_iscapability integer;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @o_userHasCapability = 0
IF dbo.isNewSecurity() = 0
BEGIN
	--------------------------------------------------
	-- USERS FROM DISABLED PROVIDERS CANNOT LOG IN! --
	--------------------------------------------------
	DECLARE @groupTbl TABLE (groupId INTEGER)
	DECLARE @providerId INTEGER=(select umDSproviderId FROM UMUsers where id = @i_userId)
	DECLARE @providerEnabled  INTEGER = ISNULL((select enabled from UMDSProviders where id = @providerId), 0)
	-----------------------------------------------------------
	--	Special Case of install capability.
	--  If this call has been made for install cap, it means user is not concernd with associations ( new client Install)
	--So we should return true only if User got this capability expliclty not via client/client group owner ship
	--Instead of directly querying cache table now we will check directly in UMUserGroups table.
	------------------------------------------------------------------------------------------------
	IF @providerEnabled = 0
	BEGIN
		GOTO GET_USER_CREDENTIALS_EXIT
	END
IF(@i_capability & CONVERT(bigint, (POWER(2.0, 7-1))) <>@i_capability)
	BEGIN
		IF object_id('tempdb.dbo.#sec_userHasCapability_userObjects') is not null 		DROP TABLE #sec_userHasCapability_userObjects
create table  #sec_userHasCapability_userObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		EXEC sec_getUserObjects @i_userId,0,0,'#sec_userHasCapability_userObjects'
		IF EXISTS (select 1 FROM #sec_userHasCapability_userObjects WHERE capabilities&@i_capability<>0)
		BEGIN
			SET @o_userHasCapability = 1
		END
			GOTO GET_USER_CREDENTIALS_EXIT
		END
	INSERT INTO @groupTbl
	EXEC sec_getLocalUserGroupsOfUser @i_userId
	DELETE GRPTBL
	from @groupTbl GRPTBL inner join UMGroups G on  G.id=GRPTBL.groupId
	where groupFlags=0 or groupFlags=2
	IF EXISTS
			(SELECT 1
			 FROM UMGroups
			 WHERE allCapabilities=1 AND id in (SELECT groupId FROM @groupTbl) )
			OR EXISTS
			(SELECT 1  FROM UMGroupCapability UGC
						WHERE groupId in (SELECT groupId FROM @groupTbl)
						AND (CAST(POWER(2.0, capabilityId - 1) AS bigint)&@i_capability)<>0
			)
		SET @o_userHasCapability = 1
END
ELSE
BEGIN
	IF OBJECT_ID ('tempdb.dbo.#userAndGroupId') IS NOT NULL
		DROP TABLE #userAndGroupId
	CREATE TABLE #userAndGroupId (userOrGroupId INT, isUser INT)
	DECLARE @permissionIdList TABLE (permissionId INT)
	IF(@i_capability<>0 AND @i_permissionId<>'')
	BEGIN
		SET @o_userHasCapability	=0
		GOTO GET_USER_CREDENTIALS_EXIT
	END
	IF(@i_capability<>0)
	BEGIN
		INSERT INTO @permissionIdList
		SELECT DISTINCT Map.permissionId
		FROM dbo.sec_getCapabilityBitMaskToPermissionMap(@i_capability, 1) AS Map
	END
	ELSE IF(@i_permissionId<>'')
	BEGIN
		INSERT INTO @permissionIdList
		SELECT _ID
		FROM dbo.SplitIDs(@i_permissionId)
	END
	ELSE
	BEGIN
		--No permission list is pass. Return false.
		SET @o_userHasCapability	=0
		GOTO GET_USER_CREDENTIALS_EXIT
	END
	INSERT INTO #userAndGroupId
              SELECT DISTINCT id, 0
			  FROM UMGroups INNER JOIN (SELECT groupId, 0 AS isUser FROM UMUserGroup INNER JOIN UMGroups ON UMUserGroup.groupId = UMGroups.id WHERE userId = @i_userId
										UNION
										SELECT umGroupId, 0 FROM UMDSGroupMaps (NOLOCK) INNER JOIN UMUserGroup (NOLOCK) ON UMDSGroupMaps.umDSgroupId = UMUserGroup.groupId AND userId = @i_userId) AS UG
			  ON UMGroups.id = UG.groupId
			  WHERE groupFlags & 1 = 1
			  UNION
			  SELECT @i_userId, 1
	DECLARE @inputPermissionEntityMapTable TABLE (permissionId integer, entityType integer)
	--get mapped entities type for input permission.
	INSERT INTO @inputPermissionEntityMapTable
	SELECT input.permissionId,ISNULL(entityType,0)
	FROM @permissionIdList input LEFT OUTER JOIN   UMPermissionEntityTypeMap Map ON MAp.permissionId=input.permissionId
	DECLARE @userClassicPermissions TABLE			-- This is just going to be the list of permissions that user has, out of the given input permissions. A very small list, max 2 or 3 entries from caller code in CVS.
	(
		permissionId INT PRIMARY KEY
	)
	INSERT INTO @userClassicPermissions
		SELECT RPE.permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN #userAndGroupId UG
				ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId
			INNER JOIN UMRolesWithPermissionsExpanded RPE
				ON Sec.roleId > 0 AND Sec.roleId = RPE.roleId
			INNER JOIN UMRoles R
				ON Sec.roleId > 0 AND Sec.roleId = R.id AND R.disabled = 0
			INNER JOIN @inputPermissionEntityMapTable PE
				ON RPE.permissionId = PE.permissionId
				AND (PE.entityType = 0 OR (Sec.entityType1 = 1 AND Sec.entityId1 = 2) OR PE.entityType = Sec.entityType1)
		UNION
		SELECT Sec.permissionId
		FROM UMSecurityAssociations Sec
			INNER JOIN #userAndGroupID UG
				ON Sec.isUser = UG.isUser AND Sec.userORGroupId = UG.userOrGroupID
			INNER JOIN @inputPermissionEntityMapTable PE
				ON Sec.permissionId > 0 AND Sec.permissionId = PE.permissionId
				AND (PE.entityType = 0 OR (Sec.entityType1 = 1 AND Sec.entityId1 = 2) OR PE.entityType = Sec.entityType1)
	IF(@i_anyCapability = 0)
	BEGIN
		-- Older version of this stored proc was using a lot of subqueries. It will be a huge performance killer with the number of rows that were returned from subqueries.
		-- The logic had a bug as well, so rewriting this piece with an optimized and corrected version.
		-- Check that all permissions in input table is present.
		IF NOT EXISTS (SELECT TOP 1 1
					   FROM @userClassicPermissions UserPermissions
							RIGHT OUTER JOIN @permissionIdList InputPermissions
								ON UserPermissions.permissionId = InputPermissions.permissionId
					   WHERE
							UserPermissions.permissionId IS NULL)
					   SET @o_userHasCapability = 1
	END
	ELSE
	BEGIN
		-- Check if at least one permission is there. Since User Classic Permissions table itself is containing only the permissions passed in input table, if it contains at least
		-- one entry, then we are good.
		IF EXISTS (SELECT TOP 1 1
				   FROM @userClassicPermissions UserPermissions)
				SET @o_userHasCapability = 1
	END
	IF @o_userHasCapability = 0			--look into owners table
	BEGIN
		IF OBJECT_ID ('tempdb.dbo.#tempOwnerRoles') IS NOT NULL
			DROP TABLE #tempOwnerRoles
		CREATE TABLE #tempOwnerRoles (roleId INT,entityType int, entityId int)
		--if the user is owner of commcell then he has all the entity owner's roles
		IF EXISTS (SELECT entitytype
				   FROM UMOwners owners INNER JOIN #userAndGroupId UG
				   ON owners.isUser = UG.isUser AND owners.userOrGroupId = UG.userOrGroupId
				   WHERE owners.entityType = 1 AND owners.entityId = 2)
		BEGIN
			INSERT INTO #tempOwnerRoles
				SELECT DISTINCT roleId,entitytype, entityId
				FROM UMOwnerRoles
		END
		--else get list of owner roles that user has
		ELSE
		BEGIN
			--A user will have these roles -
			--1. All the owner roles on the children entities of the parent entities for whom the user is owner of
			--2. All the owner roles on the parent entities of the children entities for whom the user is owner of
			--3. All the owner roles on the entity for whom he is the owner of
			--if user is a owner of a entity get the list of roles of that entity
			-- we should get owner roles for only entity types mapped to input permsision time
			INSERT INTO #tempOwnerRoles
				SELECT ownerroles.roleid ,ownerroles.entityType,ownerroles.entityId
				FROM UMOwnerRoles ownerroles INNER JOIN UMOwners owners
				ON ownerroles.entityType = owners.entityType AND ownerroles.entityId = owners.entityId
				INNER JOIN #userAndGroupId ug
				ON owners.isuser = ug.isuser AND owners.userOrGroupId = ug.userorgroupid
			DECLARE @associationquery NVARCHAR(MAX) = N''
			DECLARE @localassociationquery NVARCHAR(MAX) = N''
			DECLARE @dynamicsql NVARCHAR(MAX) = N''
			--if user or group is owner of parent, then has to get all children roles
			--a single parent may be parent of many entity types
			--example, user group entity (15) is parent of user entity (13) and external group entity (62)
			--so get a union of those queries
			DECLARE entityParentTypeCursor CURSOR FOR
				SELECT DISTINCT associationQuery
				FROM (SELECT DISTINCT owners.entitytype
					  FROM UMOwners owners INNER JOIN #userAndGroupId ug
					  ON owners.isuser = ug.isuser AND owners.userOrGroupId = ug.userorgroupid) ownerEntities
				INNER JOIN app_entityparentassociation entityparentassoc
				ON entityparentassoc.parentEntityType = ownerEntities.entityType
			OPEN entityParentTypeCursor
			FETCH NEXT FROM entityParentTypeCursor INTO @localassociationquery
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF @associationquery <> ''
					SET @associationquery = @associationquery + CHAR(10) + ' UNION ' + CHAR(10) + @localassociationquery
				ELSE
					SET @associationquery = @localassociationquery
				FETCH NEXT FROM entityParentTypeCursor INTO @localassociationquery
			END
			CLOSE entityParentTypeCursor
			DEALLOCATE entityParentTypeCursor
			IF(@associationquery <> '' and @associationquery IS NOT NULL)
			BEGIN
				SET @dynamicsql = 'INSERT INTO #tempOwnerRoles
								   SELECT DISTINCT ownerroles.roleid,ownerroles.entityType,0
								   FROM UMOwners owners
								   INNER JOIN (' +
								   CHAR(10) +
								   @associationquery +
								   CHAR(10) +
								   ') assoc
									ON assoc.parententitytype = owners.entitytype AND assoc.parentid = owners.entityid
									INNER JOIN umownerroles ownerroles
									ON ownerroles.entitytype = assoc.childentitytype AND ownerroles.entityid = assoc.childid
									INNER JOIN #userAndGroupId UG ON
									owners.isUser = UG.isUser AND owners.userOrGroupId = UG.userOrGroupId'
				EXEC (@dynamicsql)
			END
			SET @associationquery = ''
			SET @localassociationquery = ''
			SET @dynamicsql = ''
			--if user or group is owner of children has to get parent roles
			--a single child entity can be part of multiple parent entities
			--example, user entity is a child of user group entity, domain user group entity and nameserver entity
			--so get a union of those queries
			DECLARE childEntityTypeCursor CURSOR FOR
				SELECT DISTINCT associationQuery
				FROM (SELECT DISTINCT owners.entitytype
					  FROM UMOwners owners INNER JOIN #userAndGroupId ug
					  ON owners.isuser = ug.isuser AND owners.userOrGroupId = ug.userorgroupid) ownerEntities
				INNER JOIN app_entityparentassociation entityparentassoc
				ON entityparentassoc.childEntityType = ownerEntities.entityType
			OPEN childEntityTypeCursor
			FETCH NEXT FROM childEntityTypeCursor INTO @localassociationquery
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF @associationquery <> ''
					SET @associationquery = @associationquery + CHAR(10) + ' UNION ' + CHAR(10) + @localassociationquery
				ELSE
					SET @associationquery = @localassociationquery
				FETCH NEXT FROM childEntityTypeCursor INTO @localassociationquery
			END
			CLOSE childEntityTypeCursor
			DEALLOCATE childEntityTypeCursor
			IF(@associationquery <> '' AND @associationquery IS NOT NULL)
			BEGIN
				SET @dynamicsql = 'INSERT INTO #tempOwnerRoles
								   SELECT DISTINCT ownerroles.roleid,ownerroles.entityType,owners.entityId
								   FROM UMOwners owners
								   INNER JOIN (' +
								   CHAR(10) +
								   @associationquery +
								   CHAR(10) +
								   ') assoc
									ON assoc.childEntityType = owners.entitytype AND assoc.childId = owners.entityid
									INNER JOIN umownerroles ownerroles
									ON ownerroles.entitytype = assoc.parentEntityType AND ownerroles.entityid = assoc.parentId
									INNER JOIN #userAndGroupId UG ON
									owners.isUser = UG.isUser AND owners.userOrGroupId = UG.userOrGroupId'
				EXEC (@dynamicsql)
			END
		END
		-- Bug fix: Commcell owner role is being missed in temp owner roles table. If the user / group is owner of some entity, then Commcell owner role needs to be included by default.
		IF EXISTS (SELECT TOP 1 1
				   FROM UMOwners O
						INNER JOIN #userAndGroupId UG
							ON O.isUser = UG.isUser AND O.userOrGroupId = UG.userOrGroupId
				   )
			INSERT INTO #tempOwnerRoles
				SELECT roleId, entityType, entityId
				FROM UMOwnerRoles
				WHERE
					entityType = 1 AND entityId = 2
		DECLARE @userPermissions TABLE
		(
			permissionId INT PRIMARY KEY
		)
		INSERT INTO @userPermissions
			SELECT permissionId
			FROM @userClassicPermissions
			UNION
			SELECT RPE.permissionID
			FROM #tempOwnerRoles T
				INNER JOIN UMRolesWithPermissionsExpanded RPE
					ON T.roleId = RPE.roleId
				INNER JOIN @inputPermissionEntityMapTable PE
					ON RPE.permissionId = PE.permissionId
					AND (PE.entityType = 0 OR (T.entityType = 1 AND T.entityId = 2) OR T.entityType = PE.entityType)
		IF (@i_anyCapability = 0)
		BEGIN
			IF NOT EXISTS (SELECT TOP 1 1
						   FROM @userPermissions UserPermissions
								RIGHT OUTER JOIN @permissionIdList InputPermissions
									ON UserPermissions.permissionId = InputPermissions.permissionId
							WHERE
								UserPermissions.permissionId IS NULL)
								SET @o_userHasCapability = 1
		END
		ELSE
		BEGIN
			IF EXISTS(SELECT TOP 1 1
					  FROM @userPermissions)
							SET @o_userHasCapability = 1
		END
	END
END
GET_USER_CREDENTIALS_EXIT:
IF(@i_returnCursor<>0)
  SELECT @o_userHasCapability
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_userHasCapability')
	delete from GxQscripts where name = 'sec_userHasCapability'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_userHasCapability')
	delete from GXDBVersions where aliasname = 'sec_userHasCapability'
GO

insert into GXDBVersions values(2, 'sec_userHasCapability',  '00000000000000000000', 'sec_userHasCapability', '00000000000000000000')
GO

