

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_upgradeUMUserAndGroupEntityAssociation.sp] ---------- 

--
--  +========================================================================+
--  |   Procedure:  sec_upgradeUMUserAndGroupEntityAssociation.sp()
--  |
--  | Description:  Upgrade UMUserAndGroupEntityAssociation table into UMSecurityAssociations
--  |				We are not upgrading rows with entitytypes=DM2_COMPLIANCE_DELEGATION_SEARCH_ITEM (9509) view hold entity, because it is not security associations)
--  |        Note:  Add support for specific entityTypes if needed.
--  |
--  |       Input:  None
--  |
--  |      Output:  None
--  |      Return:  None
--  |
--  |   Revisions  Author   Description
--  |   ---------  saggarwal & jswaminathan ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_upgradeUMUserAndGroupEntityAssociation')
BEGIN
	print '>>> Drop Stored Procedure: sec_upgradeUMUserAndGroupEntityAssociation <<<'
	drop procedure sec_upgradeUMUserAndGroupEntityAssociation
END
IF EXISTS (select * from GxQscripts where name='sec_upgradeUMUserAndGroupEntityAssociation')
	delete from GxQscripts where name = 'sec_upgradeUMUserAndGroupEntityAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeUMUserAndGroupEntityAssociation')
	delete from GXDBVersions where aliasname = 'sec_upgradeUMUserAndGroupEntityAssociation'
GO
print '... Creating Procedure: sec_upgradeUMUserAndGroupEntityAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_upgradeUMUserAndGroupEntityAssociation
  @errorCode INTEGER = 0 OUTPUT,
  @errorString varchar(1024) ='' OUTPUT
AS
--Upgrade scripts for entities where direct capability associations to users or user groups are supported
--like workflow, log monitoring, custom reports, etc
SET @errorCode =0
SET @errorString=''
DECLARE @userId INT
DECLARE @groupId INT
DECLARE @providerId INT
DECLARE @capabilities BIGINT
DECLARE @objectType INT
DECLARE @objectId INT
DECLARE @ownerUserId INT
DECLARE @entityType1 INT
DECLARE @entityId1 INT
DECLARE @entityType2 INT
DECLARE @entityId2 INT
DECLARE @entityType3 INT
DECLARE @entityId3 INT
DECLARE @entityType4 INT
DECLARE @entityId4 INT
DECLARE @entityType5 INT
DECLARE @entityId5 INT
DECLARE @commcellSecurityTable TABLE
(
    userId INT,
    userGroupId INT,
    externalGroupId INT,
    roleId INT,
    permissionId INT
)
DECLARE @reportManagementUserOrGroupIdTable TABLE
(
	userID INT,
    userGroupId INT
)
DECLARE @securityXML XML
EXEC sec_getSecurityForEntity 1, @securityXML OUTPUT, 1, 2
 INSERT INTO @commcellSecurityTable (userId, userGroupId, externalGroupId, roleId, permissionId)
        SELECT ISNULL(UG.value('(@userId)[1]', 'INT'), 0),
               ISNULL(UG.value('(@userGroupId)[1]', 'INT'), 0),
               ISNULL(UG.value('(@groupId)[1]', 'INT'), 0),
               ISNULL(R.value('(@roleId)[1]', 'INT'), 0),
               0
        FROM @securityXML.nodes('associations/userOrGroup') AS Input(UG)
        CROSS APPLY
        Input.UG.nodes('../properties/role') AS Role(R)
    INSERT INTO @commcellSecurityTable (userId, userGroupId, externalGroupId, roleId, permissionId)
        SELECT ISNULL(UG.value('(@userId)[1]', 'INT'), 0),
               ISNULL(UG.value('(@userGroupId)[1]', 'INT'), 0),
               ISNULL(UG.value('(@groupId)[1]', 'INT'), 0),
               0,
               ISNULL(P.value('(@permissionId)[1]', 'INT'), 0)
        FROM @securityXML.nodes('associations/userOrGroup') AS Input(UG)
        CROSS APPLY
        Input.UG.nodes('../properties/categoryPermission/categoriesPermissionList') AS Permissions(P)
INSERT INTO @reportManagementUserOrGroupIdTable
	SELECT CASE WHEN Security.userId <> 0 THEN Security.userId ELSE 0 END,
           CASE WHEN Security.userGroupId <> 0 THEN Security.userGroupId
				WHEN Security.externalGroupId <> 0 THEN Security.externalGroupId
				ELSE 0
			END
        FROM @commcellSecurityTable Security LEFT JOIN UMRolesWithPermissionsExpanded RolePerm
            ON Security.roleId = RolePerm.roleId
WHERE (Security.permissionId = 15 OR RolePerm.permissionId = 15)
        AND Security.userId <> 1 AND Security.userGroupId <> 1
--expand AD user groups to user groups
INSERT INTO @reportManagementUserOrGroupIdTable
	SELECT 0, UGM.umDSgroupId
	FROM UMDSGroupMaps UGM INNER JOIN @reportManagementUserOrGroupIdTable Rpt
	ON UGM.umgroupId = rpt.userGroupId
	EXCEPT
	SELECT *
	FROM @reportManagementUserOrGroupIdTable
--expand user groups to users
INSERT INTO @reportManagementUserOrGroupIdTable
	SELECT UG.userId, 0
	FROM UMUserGroup UG INNER JOIN @reportManagementUserOrGroupIdTable Rpt
	ON Rpt.userGroupId = UG.groupId
	EXCEPT
	SELECT *
	FROM @reportManagementUserOrGroupIdTable
	WHERE userId <> 0
--Currently this caters to Workflow, LM, custom reports, DM2 entities and client group creators
DECLARE upgradeCursor CURSOR STATIC FOR
	SELECT userId, groupId, providerId, capabilities, entityType, objectId, ownerUserId
	FROM UMUserandGroupEntityAssociation
	--WHERE entityTYpe IN (WORKFLOW_ITEM, LOG_MONITORING_POLICY_ITEM, 2900)				--2900 is custom reports entity, cannot find a macro for that
WHERE entityType NOT IN (2572, 2009,9509)						--there may be some new entities in 10.0 which use UMUserAndGroupEntityAssociation, let us not keep on adding a list
																						--instead let us frame the WHERE entityType NOT IN query
	UNION
	-- if UMSecurityAssociations already contains a creator row then do not insert again from UMUserAndGroupEntityAssociation.
	SELECT userId, groupId, providerId, capabilities, entityType, objectId, userId  --for client group creators, ownerUserId will be 0, so set @ownerUserId = @userId to have the isCreator flag set in UMSecurityAssociations table
	FROM UMUserAndGroupEntityAssociation UUG
LEFT JOIN UMSecurityAssociations USA ON  USA.entityType1 = 28 and UUG.objectId = USA.entityId1 and USA.isCreator = 1
WHERE UUG.entityType = 2572 AND UUG.ownerUserId = 0 AND UUG.userId <> 0 AND USA.entityId1 IS NULL		--change the WHERE condition - instead of taking the entity types explicitly, handle in generic way
	--change the WHERE condition - instead of taking the entity types explicitly, handle in generic way
OPEN upgradeCursor
FETCH NEXT FROM upgradeCursor INTO @userId, @groupId, @providerId, @capabilities, @objectType, @objectId, @ownerUserId
WHILE @@FETCH_STATUS = 0
BEGIN
	DECLARE @permissionsList TABLE (permissionId INT)
	DELETE FROM @permissionsList
	INSERT INTO @PermissionsList
		SELECT DISTINCT Map.permissionId
		FROM sec_getCapabilityBitMaskToPermissionMap(@capabilities, 1) AS Map
	--Permissions like agent management, storage policy management, etc. are not applicable on workflows and monitoring policies.
	--so even if it was given to workflows and monitoring policy (which was a bug in v10), we dont need to retain them on DB.
	--Only permissions mapped to WF and LM entity in UMPermissionEntityTypeMap + view + Job management (only for WF) are applicable on them.
IF @objectType IN (14033, 9646)
	BEGIN
		DELETE FROM @PermissionsList
		WHERE permissionId NOT IN (SELECT permissionId
								   FROM UMPermissionEntityTypeMap
								   WHERE entityType = dbo.sec_ObjectTypeToEntitytype(@objectType))
AND (permissionId <> 31)
AND ((@objectType <> 14033) OR (permissionId <> 16))
	END
	IF (@objectType = 2900) AND EXISTS (SELECT 1 FROM @reportManagementUserOrGroupIdTable WHERE (userId = @userID AND @userId <> 0) OR (userGroupId = @groupId AND @groupId <> 0))
AND NOT EXISTS (SELECT 1 FROM @permissionsList WHERE permissionID = 107)
INSERT INTO @permissionsList SELECT 107
	print ('Upgrading 3 way associations userId=' + CONVERT(varchar(128),@userId) +' and groupId = '+CONVERT(varchar(128),@groupId) +' and providerId = '+CONVERT(varchar(128),@providerId) +' and capabilities = '+CONVERT(varchar(128),@capabilities) +' and entityType = '+CONVERT(varchar(128),@objectType) +' and objectId = '+CONVERT(varchar(128),@objectId) +' and ownerUserId = '+CONVERT(varchar(128),@ownerUserId))
	--this is special handling for edgde drive subclients. IT cant be merge with below insert because there can ne ownerId=userID but that wont be creator associations. In edge admin userId is always given as owner Id.
	--v10 code http:--ncvs.commvault.com/source/xref/10.0-win/vaultcx/Source/CommServer/Db/Sp/AppSetEdgeDriveAndGroupsAssoc.sp#365
	--v11 code http:--ncvs.commvault.com/source/xref/win/vaultcx/Source/CommServer/Db/Sp/AppSetEdgeDriveAndGroupsAssoc.sp#368
IF(@objectType=2013)
	BEGIN
		IF NOT EXISTS(SELECT 1 from APP_Application where id=@objectId)
		BEGIN
			FETCH NEXT FROM upgradeCursor INTO @userId, @groupId, @providerId, @capabilities, @objectType, @objectId, @ownerUserId
			CONTINUE
		END
SELECT 	@entitytype1=3,
				@entityId1=clientId,
@entityType2=4,
				@entityId2=appTypeId,
@entityType3=5,
				@entityId3=instance,
@entityType4=6,
				@entityId4=backupSet,
@entityType5=7,
				@entityId5=id
				FROM APP_application where id=@objectId
				INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entitytype1, entityid1,entitytype2, entityid2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5, includeall, iscreator, authorId)
				SELECT 0, permissionId,
			   	CASE WHEN @userId <> 0 THEN @userId
			    	    ELSE @groupId
			   	END,
			   	CASE WHEN @userId <> 0 THEN 1
					ELSE 0
			   END,
			   @entityType1,@entityId1,
			   @entityType2,@entityId2,
			   @entityType3,@entityId3,
			   @entityType4,@entityId4,
			   @entityType5,@entityId5,
			 	0 ,
			   0 ,
			   @ownerUserId
			   FROM @permissionsList
	END
	ELSE
	BEGIN
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entitytype1, entityid1, includeall, iscreator, authorId)
			SELECT 0, permissionId,
				   CASE WHEN @userId <> 0 THEN @userId
				        ELSE @groupId
			   	END,
			   	CASE WHEN @userId <> 0 THEN 1
						ELSE 0
			   	END,
			   	(SELECT dbo.sec_ObjectTypeToEntitytype(@objectType)),
			   	CASE WHEN @objectId = -10 THEN 0 ELSE @ObjectId END,
			   	CASE WHEN @objectId = -10 THEN 1 ELSE 0 END,
			   	CASE WHEN (@userId <> 0 AND @ownerUserId = @userId) THEN 1 ELSE 0 END,
			   	@ownerUserId
			FROM @permissionsList
	END
	FETCH NEXT FROM upgradeCursor INTO @userId, @groupId, @providerId, @capabilities, @objectType, @objectId, @ownerUserId
END
CLOSE upgradeCursor
DEALLOCATE upgradeCursor
--Upgrade script for client owners
--THis will take care of client owners, client group owner capabilities and system owner capabilities
DECLARE upgradeClientCursor CURSOR FOR
       SELECT userId, groupId, providerId, capabilities, entityType, objectId, ownerUserId
	   FROM UMUserandGroupEntityAssociation
WHERE (entityType = 2009) OR (entityTYpe = 2572 AND userID = 0)                   --for client group just get the owner capability row, not the creator row
       UNION
SELECT 0, 0, 0, CAST (value AS BIGINT), 2018, 2, 0
       FROM GxGlobalParam
       WHERE name = 'SystemOwnerCapibilities'
OPEN upgradeClientCursor
FETCH NEXT FROM upgradeClientCursor INTO @userId, @groupId, @providerId, @capabilities, @objectType, @objectId, @ownerUserId
WHILE @@FETCH_STATUS = 0
BEGIN
	print ('Upgrading Owners  userId=' + CONVERT(varchar(128),@userId) +' and groupId = '+CONVERT(varchar(128),@groupId) +' and providerId = '+CONVERT(varchar(128),@providerId) +' and capabilities = '+CONVERT(varchar(128),@capabilities) +' and entityType = '+CONVERT(varchar(128),@objectType) +' and objectId = '+CONVERT(varchar(128),@objectId) +' and ownerUserId = '+CONVERT(varchar(128),@ownerUserId))
       DECLARE @entityTYpe INT			--this is the .x equivalent for the given item based object type
	   SET @entityType = dbo.sec_ObjectTypeToEntitytype(@objectType)
IF (@objectType = 2009) AND (@userID <> 0 OR @groupId <> 0)                --Till 10.0, only clients had owners
       BEGIN                                                                                                         --If both user and group id are 0, then it is a owner capability row, so dont insert anything into owners table
IF NOT EXISTS (SELECT * FROM UMOwners WHERE entityType = 3 AND entityId = @objectID AND ((@userId <> 0 AND @userId = userOrGroupId AND isUser = 1) OR (@groupId <> 0 AND userOrGRoupId = @groupid AND isUser = 0)))
              INSERT INTO UMOwners (entityType, entityID, userOrGroupId, isUser, authorId)
                     SELECT @entityTYpe, @objectId,
                              CASE WHEN @userID <> 0 THEN @userID
                                      ELSE @groupId
                              END,
                              CASE WHEN @userID <> 0 THEN 1
                                      ELSE 0
                              END,
                              1                       --let us hardcode the authorID as admin in this case
       END
       --Now we have to frame a role for this entity with the given capability list and then insert into UMOwnerRoles table
       DECLARE @roleId INT
       SET @roleID = ISNULL((SELECT roleID FROM UMOwnerRoles WHERE entityType = @entityType AND entityId = @objectID), 0)
       IF @roleID <> 0 --If a role already exists for this entity let us just go to next one in the loop
              GOTO NEXT_ITER
       --Break the capability bit mask into individual permissions and then frame the create role XML
	   --This table name is permissionList, the one used in the previous cursor was permission"s"List - so no compile error :)
	   --We need both category and permission ids. Because if there was a capability selected in 10.0 and it's corresponding
	   --representation in 11.0 is a category then we need to set the category as selected - not the individual permissions
       DECLARE @permissionList TABLE (categoryId INT, permissionId INT)
       DELETE FROM @permissionList
       INSERT INTO @permissionList
              SELECT DISTINCT Map.categoryId, Map.permissionId
              FROM sec_getCapabilityBitMaskToPermissionMap(@capabilities, 0) AS Map
		--IF user has administrative management than give installation too.
IF EXISTS(SELECT 1 from @permissionList  where permissionId=1 )
and  not EXISTS (select  1 from @permissionList where permissionId=7)
			INSERT @permissionList
SELECT categoryId,id FROM UMPermissions where id=7
       --Passing flag as 0 to sec_getCapabilityBitMaskToPermissionMap so that category does not get expanded to individual permissions
       DECLARE @roleName NVARCHAR(MAX)
       SET @roleName = 'SystemCreatedRole_' + CAST (@entityType AS NVARCHAR(MAX)) + '_' + CAST (@Objectid AS NVARCHAR(MAX)) + '_' + CAST(dbo.getUnixTime(GETUTCDATE()) AS NVARCHAR(MAX))
       DECLARE @ownersCapabilityXML XML
       DECLARE @roleCreationXML XML
       SET @ownersCapabilityXML =  (SELECT '2' AS '@categoriesPermissionOperationType',			--ADD as operation type
                                                                     (SELECT
                                                                           (SELECT categoryId AS '@categoryId',
                                                                                     CASE WHEN permissionId <> 0 THEN permissionId END AS '@permissionId',
CASE WHEN permissionId = 0 THEN 121 ELSE 122 END AS '@_type_'
                                                                           FOR XML PATH ('categoriesPermissionList'), TYPE)
                                                                     FROM @permissionList
                                                                     FOR XML PATH (''), TYPE)
                                                       FOR XML PATH ('categoryPermission'))
       SET @roleCreationXML = (SELECT 'System created owner role for entity' AS '@description',
                                                          (SELECT @roleName AS '@roleName'
                                                          FOR XML PATH ('role'), TYPE),
                                                          (SELECT @ownersCapabilityXML.query('.')
                                                          FOR XML PATH (''), TYPE)
                                            FOR XML PATH ('Security_Role'))
       DECLARE @outputXML XML
       EXEC sec_CreateRole @roleCreationXML, 1, 0, @outputXML OUTPUT, 0, 4
       SET @errorCode = ISNULL((SELECT UG.value('@errorCode', 'INT')
                                                       FROM @outputXML.nodes('App_GenericEntityResponse') AS Output(UG)), 0)
       SET @errorString = ISNULL((SELECT UG.value('@errorString', 'NVARCHAR(MAX)')
                                                          FROM @outputXML.nodes('App_GenericEntityResponse') AS Output(UG)), N'')
       IF @errorCode <> 0
       BEGIN
              CLOSE upgradeClientCursor
              DEALLOCATE upgradeClientCursor
              GOTO END_PROCESSING
       END
       SET @roleId = (SELECT id FROM UMROles WHERE name = @roleName)
       INSERT INTO UMOwnerROles (entityType, entityId, roleId, permissionId, authorId)
              SELECT @entityType, @ObjectId, @roleId, 0 ,1
NEXT_ITER:
       FETCH NEXT FROM upgradeClientCursor INTO @userId, @groupId, @providerId, @capabilities, @objectType, @objectId, @ownerUserId
END
CLOSE upgradeClientCursor
DEALLOCATE upgradeClientCursor
END_PROCESSING:
GO

IF EXISTS (select * from GxQscripts where name = 'sec_upgradeUMUserAndGroupEntityAssociation')
	delete from GxQscripts where name = 'sec_upgradeUMUserAndGroupEntityAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeUMUserAndGroupEntityAssociation')
	delete from GXDBVersions where aliasname = 'sec_upgradeUMUserAndGroupEntityAssociation'
GO

insert into GXDBVersions values(2, 'sec_upgradeUMUserAndGroupEntityAssociation',  '00000000000000000000', 'sec_upgradeUMUserAndGroupEntityAssociation', '00000000000000000000')
GO

