

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_upgradeStoragePolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--      Script for storage policy permissions upgrade
--      This script assigns all permissions under "storage policy" category to the
--      user has storage policy management permission
--
-- ------------------------------------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_upgradeStoragePolicy <<<'

IF EXISTS (select * from sysobjects where name='sec_upgradeStoragePolicy')
	drop procedure sec_upgradeStoragePolicy
IF EXISTS (select * from GxQscripts where name='sec_upgradeStoragePolicy')
	delete from GxQscripts where name = 'sec_upgradeStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeStoragePolicy')
	delete from GXDBVersions where aliasname = 'sec_upgradeStoragePolicy'
GO
print '... Creating Procedure: sec_upgradeStoragePolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_upgradeStoragePolicy
  @errorCode INT = 0 OUTPUT,
  @errorString NVARCHAR(1024) = N'' OUTPUT
AS
BEGIN TRY
    IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTrackINg WHERE SqlScriptGUID = '818C8A2A-5353-409B-84B5-BA9B834C519B')    -- GUID NOT present
    BEGIN
		-- Roles Association
		DECLARE @RolesListWithSPM TABLE (roleId Integer)
		DECLARE @RolesListWithAll TABLE (roleId Integer)
		DECLARE @RolesListWithAllExcluded TABLE (roleId Integer)
		INSERT INTO @RolesListWithSPM
SELECT DISTINCT roleId FROM UMRolesPermissions WHERE permissionId = 4 OR (permissionId = 0 AND categoryId = 104 )
		DELETE TMP
		FROM @RolesListWithSPM TMP
INNER JOIN UMRolesPermissions UMP ON UMP.roleId = TMP.roleId AND ( (excludePermission = 1 AND permissionId = 4) OR (excludeCategory = 1 AND categoryId = 104))
		DELETE TMP
		FROM @RolesListWithSPM TMP
INNER JOIN UMRolesPermissions UMP ON UMP.roleId = TMP.roleId AND categoryId = 134
		INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)
SELECT TMP.roleId, 121, 134, 0, 0, 0 FROM @RolesListWithSPM TMP
LEFT OUTER JOIN UMRolesPermissions UMR ON UMR.roleId = TMP.roleId AND UMR.hierarchyLevel = 121 AND UMR.categoryId = 134
				WHERE UMR.roleId IS NULL
		-- Add exclude entry for All selection and excluded permission or category
		INSERT INTO @RolesListWithAll
SELECT DISTINCT roleId FROM UMRolesPermissions WHERE hierarchyLevel = 123
		INSERT INTO @RolesListWithAllExcluded
			SELECT DISTINCT TMP.roleId FROM @RolesListWithAll TMP
INNER JOIN UMRolesPermissions UMP ON UMP.roleId = TMP.roleId AND ((categoryId = 104 AND excludecategory = 1 ) OR (permissionId = 4 AND excludepermission = 1))
		INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)
SELECT TMP.roleId, 121, 134, 0, 1, 0 FROM @RolesListWithAllExcluded TMP
LEFT OUTER JOIN UMRolesPermissions UMR ON UMR.roleId = TMP.roleId AND UMR.hierarchyLevel = 121 AND UMR.categoryId = 134 AND UMR.excludecategory = 1
				WHERE UMR.roleId IS NULL
		-- Inserting the role ids which are involved on changes into single table to run the sec_expandRoleWithPermissions SP
		INSERT INTO @RolesListWithSPM
			SELECT DISTINCT TMPEx.roleId FROM @RolesListWithAllExcluded TMPEx
			LEFT OUTER JOIN @RolesListWithSPM TMP ON TMP.roleId = TMPEx.roleId
			WHERE TMP.roleId IS NULL
		DECLARE @RoleId INTEGER = 0
		DECLARE UpgradeSPMCur CURSOR FOR
		SELECT * FROM @RolesListWithSPM
		OPEN UpgradeSPMCur
		FETCH NEXT FROM UpgradeSPMCur INTO @RoleId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			EXEC sec_expandRoleWithPermissions @RoleId, @errorCode OUTPUT, @errorString OUTPUT
			FETCH NEXT FROM UpgradeSPMCur INTO @RoleId
		END
		CLOSE UpgradeSPMCur
		DEALLOCATE UpgradeSPMCur
			--Explicit permission association
IF EXISTS(SELECT 1 FROM UMSecurityAssociations WITH (NOLOCK) WHERE permissionID = 4 AND roleId = 0)
		BEGIN
			DECLARE @StoragePolicyMgmtRoleId INTEGER = 0
DECLARE @StroagePolicyMgmtRoleName VARCHAR(50) = N'StoragePolicyManagement'
IF EXISTS(SELECT top 1 id FROM UMRoles WHERE name = N'StoragePolicyManagement' )
			BEGIN
				SELECT @StroagePolicyMgmtRoleName = @StroagePolicyMgmtRoleName + '_' + convert(VARCHAR,GETDATE(),121)
			END
			INSERT INTO UMRoles (commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties)
SELECT 2, @StroagePolicyMgmtRoleName, 'Role for St  orage Policy Management', 0, 0, 0, 1, dbo.getunixtime(getutcdate()), 0, NEWID(), ''
			SET @StoragePolicyMgmtRoleId = (SELECT top 1 id FROM UMRoles WHERE name = @StroagePolicyMgmtRoleName order by id desc)
			INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)
SELECT @StoragePolicyMgmtRoleId, 121, 134, 0, 0, 0
			EXEC sec_expandRoleWithPermissions @StoragePolicyMgmtRoleId, @errorCode OUTPUT, @errorString OUTPUT
			INSERT INTO UMSecurityAssociations (roleID, permissionId, userOrGroupId, isUser, isRoleAllowed, propagateToChildObjects, roleValidityDate, timeZone, exclude,
				entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll,	isCreator, authorId)
			SELECT @StoragePolicyMgmtRoleId, 0, UMR.userOrGroupId, UMR.isUser, UMR.isRoleAllowed, UMR.propagateToChildObjects, UMR.roleValidityDate, UMR.timeZone, UMR.exclude,
				UMR.entityType1, UMR.entityId1, UMR.entityType2, UMR.entityId2, UMR.entityType3, UMR.entityId3, UMR.entityType4, UMR.entityId4, UMR.entityType5, UMR.entityId5, UMR.includeAll,
				UMR.isCreator, UMR.authorId
FROM UMSecurityAssociations UMR WHERE UMR.permissionID = 4 AND UMR.roleId = 0
		END
		INSERT GXUniqueSQLScriptExecTracking(SqlScriptGUID,Name,Description,CreatedTime,CreatedRelId,ExpireTime,ExpireRelId)
VALUES('818C8A2A-5353-409B-84B5-BA9B834C519B','UpgradeStoragePolicyManagement','Upgrade Storage policy management permission',dbo.GetUnixTime(GETUTCDATE()),16,0,0)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = ERROR_MESSAGE()
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'sec_upgradeStoragePolicy')
	delete from GxQscripts where name = 'sec_upgradeStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeStoragePolicy')
	delete from GXDBVersions where aliasname = 'sec_upgradeStoragePolicy'
GO

insert into GXDBVersions values(2, 'sec_upgradeStoragePolicy',  '00000000000000000000', 'sec_upgradeStoragePolicy', '00000000000000000000')
GO

