

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_upgradeSecurityForVPN.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--		Script for VPN permissions upgrade
--		This script assigns VPN Management permission to users who have administrative management at CS level.
--
-- ------------------------------------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_upgradeSecurityForVPN <<<'

IF EXISTS (select * from sysobjects where name='sec_upgradeSecurityForVPN')
	drop procedure sec_upgradeSecurityForVPN
IF EXISTS (select * from GxQscripts where name='sec_upgradeSecurityForVPN')
	delete from GxQscripts where name = 'sec_upgradeSecurityForVPN'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeSecurityForVPN')
	delete from GXDBVersions where aliasname = 'sec_upgradeSecurityForVPN'
GO
print '... Creating Procedure: sec_upgradeSecurityForVPN'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_upgradeSecurityForVPN
  @errorCode INT = 0 OUTPUT,
  @errorString NVARCHAR(1024) = N'' OUTPUT
AS
BEGIN TRY
	BEGIN TRAN
-- Use the same guid which is used in sec_upgradesecurityforvpn.script so that this isnt run again if already run. Seperate guids for view and update case since
-- change for modify scenario (Checking for vpn management capability for edit vpn operation was done first)
declare @guidForVPN uniqueidentifier = '0F00C1D1-0BE7-4DB8-A458-33A3D5064FD5'
DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())
DECLARE @globalParamPlanUpdateExec INT = 0
SELECT @globalParamPlanUpdateExec = 1 FROM
    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE
    gp.SqlScriptGUID = @guidForVPN
IF (@globalParamPlanUpdateExec = 0)
BEGIN
--Handle permission for existing data source
	--  Insert permission 'VPN Management' when 'Administrative management' permission is present for Commcell level.
	INSERT UMSecurityAssociations(roleId, permissionId ,userOrGroupId,isUser,isRoleAllowed,propagateToChildObjects, roleValidityDate,timeZone,exclude,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,includeAll,isCreator,authorId )
SELECT distinct 0, 178 ,userOrGroupId,isUser,1,1, 0,0,0,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,0,isCreator,max(authorId)
    FROM UMSecurityAssociations UMSANew
WHERE permissionId = 1 AND entityType1 = 1 and entityId1=2 -- Default commcell Id
	and exclude=0
    and not exists(SELECT 1 FROM UMSecurityAssociations UMSAOld
where UMSAOld.roleId=0 AND UMSAOld.permissionId= 178  and UMSAOld.userOrGroupId=UMSANew.userOrGroupId
        and UMSAOld.isUser=UMSANew.isUser
        and UMSAOld.entityType1=UMSANew.entityType1 and UMSAOld.entityId1=UMSANew.entityId1
        and UMSAOld.entityType2=UMSANew.entityType2 and UMSAOld.entityId2=UMSANew.entityId2
        and UMSAOld.entityType3=UMSANew.entityType3 and UMSAOld.entityId3=UMSANew.entityId3
        and UMSAOld.entityType4=UMSANew.entityType4 and UMSAOld.entityId4=UMSANew.entityId4
        and UMSAOld.entityType5=UMSANew.entityType5 and UMSAOld.entityId5=UMSANew.entityId5
        )
	group by userOrGroupId,isUser,entityType1, entityId1, entityType2, entityId2, entityType3, entityID3, entityType4, entityId4, entityType5, entityID5, isCreator
	--  Insert permission 'VPN Management' when 'Administrative management' permission is present for a role which is assigned to user at Commcell level.
	INSERT UMSecurityAssociations(roleId, permissionId ,userOrGroupId,isUser,isRoleAllowed,propagateToChildObjects, roleValidityDate,timeZone,exclude,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,includeAll,isCreator,authorId )
SELECT distinct 0, 178 ,userOrGroupId,isUser,1,1,0,0,0,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,0,isCreator,max(authorId)
    FROM UMSecurityAssociations UMSANew
WHERE roleId IN (SELECT UMRolesWithPermissionsExpanded.roleId FROM UMRolesWithPermissionsExpanded WHERE permissionId= 1)
AND entityType1 = 1 and entityId1=2 -- Default commcell Id
	 and exclude=0
     and not exists(SELECT 1 FROM UMSecurityAssociations UMSAOld
where UMSAOld.roleId=0 AND UMSAOld.permissionId= 178  and UMSAOld.userOrGroupId=UMSANew.userOrGroupId
        and UMSAOld.isUser=UMSANew.isUser
        and UMSAOld.entityType1=UMSANew.entityType1 and UMSAOld.entityId1=UMSANew.entityId1
        and UMSAOld.entityType2=UMSANew.entityType2 and UMSAOld.entityId2=UMSANew.entityId2
        and UMSAOld.entityType3=UMSANew.entityType3 and UMSAOld.entityId3=UMSANew.entityId3
        and UMSAOld.entityType4=UMSANew.entityType4 and UMSAOld.entityId4=UMSANew.entityId4
        and UMSAOld.entityType5=UMSANew.entityType5 and UMSAOld.entityId5=UMSANew.entityId5
        )
	group by userOrGroupId,isUser,entityType1, entityId1, entityType2, entityId2, entityType3, entityID3, entityType4, entityId4, entityType5, entityID5, isCreator
		INSERT GXUniqueSQLScriptExecTrackINg(SqlScriptGUID,Name,Description,CreatedTime,CreatedRelId,ExpireTime,ExpireRelId)
		VALUES(@guidForVPN,'UpgradeSecurityForVPN','Upgrade Security For VPN Management',@curUtcDateTime,16,0,18)
END
END TRY
 BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
     set @errorCode = ERROR_NUMBER()
     set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
 END CATCH
 IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
GO

IF EXISTS (select * from GxQscripts where name = 'sec_upgradeSecurityForVPN')
	delete from GxQscripts where name = 'sec_upgradeSecurityForVPN'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeSecurityForVPN')
	delete from GXDBVersions where aliasname = 'sec_upgradeSecurityForVPN'
GO

insert into GXDBVersions values(2, 'sec_upgradeSecurityForVPN',  '00000000000000000000', 'sec_upgradeSecurityForVPN', '00000000000000000000')
GO

