

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_upgradeSecurityForSubclientPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--      Script for subclient policy security upgrade
--      This script assigns permissions to
--      1) creators of subclient policy,
--		2) users having 'Administrative Management' capability at commcell level and
--		3) users having 'Agent Management' capability at client level or below
--		before upgrade
--
-- ------------------------------------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_upgradeSecurityForSubclientPolicy <<<'

IF EXISTS (select * from sysobjects where name='sec_upgradeSecurityForSubclientPolicy')
	drop procedure sec_upgradeSecurityForSubclientPolicy
IF EXISTS (select * from GxQscripts where name='sec_upgradeSecurityForSubclientPolicy')
	delete from GxQscripts where name = 'sec_upgradeSecurityForSubclientPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeSecurityForSubclientPolicy')
	delete from GXDBVersions where aliasname = 'sec_upgradeSecurityForSubclientPolicy'
GO
print '... Creating Procedure: sec_upgradeSecurityForSubclientPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_upgradeSecurityForSubclientPolicy
  @errorCode INT = 0 OUTPUT,
  @errorString NVARCHAR(1024) = N'' OUTPUT
AS
--execute the script only if this is the first time the category is getting inserted into the DB
--for the subsequent runs, this should not be run
IF EXISTS (SELECT 1 FROM UMCategories WHERE id = 121 AND (flags & CAST(0x1000 AS INT) <> 0))
BEGIN
	--Table to store subclient policies and its creators
	DECLARE @subclientPolicyCreatorsIdTable TABLE
	(
		clientId INT,
		apptypeId INT,
		instanceId INT,
		subclientPolicyId INT,
		creatorUserId INT
	)
	--Get list of subclient policy and its creators
	INSERT INTO @subclientPolicyCreatorsIdTable
		SELECT 2 /* Default Commcell ID */, 1030 /* Subclient Apptype ID */, 1 /* Default Instance ID */, SCP.id, CAST(Prop.attrVal AS int)
			FROM APP_BackupSetName SCP JOIN APP_BackupSetProp Prop
				ON SCP.id = Prop.componentNameId
			WHERE SCP.status&128 <> 0
				AND Prop.attrName = 'Subclient Policy Create UserId'
				AND CAST(Prop.attrVal AS int) <> 1						--If the owner of subclient policy is admin user himself, then no need to assign the permissions explicitly
	--Table to store users and user groups having 'Administrative Management' capability at commcell level before upgrade.
	DECLARE @administrativeManagementUserOrGroupIdTable TABLE
	(
		userOrGroupId INT,
		isUser INT
	)
	--Get list of users and user groups having 'Administrative Management' capability on commcell
	INSERT INTO @administrativeManagementUserOrGroupIdTable
		SELECT DISTINCT UMS.userOrGroupId, UMS.isUser
			FROM UMSecurityAssociations UMS
			INNER JOIN UMRolesWithPermissionsExpanded Roles
				ON UMS.roleId = Roles.roleId
AND Roles.permissionId = 1
AND UMS.entityType1 = 1
WHERE (UMS.isUser = 1 AND UMS.userOrGroupId <> 1) OR (UMS.isUser = 0 AND UMS.userOrGroupId <> 1)			--If the user is admin user or userGroup is admin group (master group), then no need to assign the permissions explicitly
		UNION
		SELECT DISTINCT userOrGroupId, isUser
			FROM UMSecurityAssociations
WHERE permissionId = 1
AND entityType1 = 1
AND ((isUser = 1 AND userOrGroupId <> 1) OR (isUser = 0 AND userOrGroupId <> 1))							--If the user is admin user or userGroup is admin group (master group), then no need to assign the permissions explicitly
	--Table to store users and user groups having 'Agent Management' capability at client level or below before upgrade.
	DECLARE @agentManagementUserOrGroupIdTable TABLE
	(
		userOrGroupId INT,
		isUser INT
	)
	--Get list of users and user groups having 'Agent Management' capability at client level or below
	INSERT INTO @agentManagementUserOrGroupIdTable
		SELECT DISTINCT UMS.userOrGroupId, UMS.isUser
			FROM UMSecurityAssociations UMS
			INNER JOIN UMRolesWithPermissionsExpanded Roles
				ON UMS.roleId = Roles.roleId
AND Roles.permissionId = 2
AND UMS.entityType1 IN (1, 28, 3)
WHERE (UMS.isUser = 1 AND UMS.userOrGroupId <> 1) OR (UMS.isUser = 0 AND UMS.userOrGroupId <> 1)			--If the user is admin user or userGroup is admin group (master group), then no need to assign the permissions explicitly
		UNION
		SELECT DISTINCT userOrGroupId, isUser
			FROM UMSecurityAssociations
WHERE permissionId = 2
AND entityType1 IN (1, 28, 3)
AND ((isUser = 1 AND userOrGroupId <> 1) OR (isUser = 0 AND userOrGroupId <> 1))							--If the user is admin user or userGroup is admin group (master group), then no need to assign the permissions explicitly
	--Already created 'Subclient Policy Owner' role with all permissions in 'Subclient Policy' category except 'Create Subclient Policy'
	--This role also has'Change Security Settings' permission.
	--This role is for creators of the subclient policy.
	--Will also be given to the users and user groups having 'Administrative Management' capability at commcell level before upgrade.
	DECLARE @subclientPolicyOwnerRoleId INT = 0
SET @subclientPolicyOwnerRoleId = ISNULL((SELECT id FROM UMRoles WHERE name = 'Subclient Policy Owner' AND (flags & 1 | 2 <> 0)), 0)			--USE_MACRO
	--Assign 'Subclient Policy Owner' role to the creators of the older subclient policies on their subclient policies
	--And to the users and user groups having 'Administrative Management' capability at commcell level before upgrade on all subclient policies
	IF @subclientPolicyOwnerRoleId <> 0
	BEGIN
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, isCreator, authorId)
SELECT DISTINCT @subclientPolicyOwnerRoleId, 0, Tbl.creatorUserId, 1, 3, Tbl.clientId, 4, Tbl.apptypeId, 5, Tbl.instanceId, 6, Tbl.subclientPolicyId, 1, 1		--USE_MACRO
			FROM @subclientPolicyCreatorsIdTable Tbl LEFT OUTER JOIN UMSecurityAssociations UMS
ON UMS.entityType1 = 3 AND UMS.entityId1 = Tbl.clientId
AND UMS.entityType2 = 4 AND UMS.entityId2 = Tbl.apptypeId
AND UMS.entityType3 = 5 AND UMS.entityId3 = Tbl.instanceId
AND UMS.entityType4 = 6 AND UMS.entityId4 = Tbl.subclientPolicyId AND UMS.isCreator = 1
				WHERE UMS.userOrGroupId IS NULL
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, isCreator, authorId, includeAll)
SELECT DISTINCT @subclientPolicyOwnerRoleId, 0, Tbl.userOrGroupId, Tbl.isUser, 3, 2, 4, 1030, 5, 1, 0, 0, 0, 1, 0		--USE_MACRO
			FROM @administrativeManagementUserOrGroupIdTable Tbl LEFT OUTER JOIN UMSecurityAssociations UMS
					ON Tbl.userOrGroupId = UMS.userOrGroupId
					AND Tbl.isUser = UMS.isUser
					AND UMS.roleId = @subclientPolicyOwnerRoleId
AND UMS.entityType1 = 3 AND UMS.entityId1 = 2
AND UMS.entityType2 = 4 AND UMS.entityId2 = 1030
AND UMS.entityType3 = 5 AND UMS.entityId3 = 1
					AND UMS.entityType4 = 0 AND UMS.entityId4 = 0
				WHERE UMS.userOrGroupId IS NULL
	END
    --Assign 'Create Subclient Policy' permission to the creators of the older subclient policies on commcell
	--Also to the users and user groups having 'Administrative Management' capability at commcell level before upgrade
	--And to the users and user groups having 'Agent Management' capability at client level or below before upgrade.
	INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
SELECT DISTINCT 0, 174, Tbl.creatorUserId, 1, 1, 2, 0, 1		--USE_MACRO
		FROM @subclientPolicyCreatorsIdTable Tbl LEFT OUTER JOIN UMSecurityAssociations UMS
				ON Tbl.creatorUserId = UMS.userOrGroupId
				AND UMS.isUser = 1
AND UMS.permissionId = 174
AND UMS.entityType1 = 1
				AND UMS.entityId1 = 2
			WHERE UMS.userOrGroupId IS NULL
	INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
SELECT DISTINCT 0, 174, Tbl.userOrGroupId, Tbl.isUser, 1, 2, 0, 1		--USE_MACRO
		FROM @administrativeManagementUserOrGroupIdTable Tbl LEFT OUTER JOIN UMSecurityAssociations UMS
				ON Tbl.userOrGroupId = UMS.userOrGroupId
				AND Tbl.isUser = UMS.isUser
AND UMS.permissionId = 174
AND UMS.entityType1 = 1
				AND UMS.entityId1 = 2
			WHERE UMS.userOrGroupId IS NULL
	INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
SELECT DISTINCT 0, 174, Tbl.userOrGroupId, Tbl.isUser, 1, 2, 0, 1		--USE_MACRO
			FROM @agentManagementUserOrGroupIdTable Tbl LEFT OUTER JOIN UMSecurityAssociations UMS
				ON Tbl.userOrGroupId = UMS.userOrGroupId
				AND Tbl.isUser = UMS.isUser
AND UMS.permissionId = 174
AND UMS.entityType1 = 1
				AND UMS.entityId1 = 2
			WHERE UMS.userOrGroupId IS NULL
	--Unset the flag in UMCategories so that the next time upgrade is run, this script does not execute
	UPDATE UMCategories
SET flags = flags & (~ CAST(0x1000 AS INT))
WHERE id = 121
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_upgradeSecurityForSubclientPolicy')
	delete from GxQscripts where name = 'sec_upgradeSecurityForSubclientPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeSecurityForSubclientPolicy')
	delete from GXDBVersions where aliasname = 'sec_upgradeSecurityForSubclientPolicy'
GO

insert into GXDBVersions values(2, 'sec_upgradeSecurityForSubclientPolicy',  '00000000000000000000', 'sec_upgradeSecurityForSubclientPolicy', '00000000000000000000')
GO

